/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.model.common.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.config.UocInitConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.common.qrybo.UocConfSupplierBo;
import com.tydic.dyc.oc.model.common.sub.UocFile;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.repository.UocChngOrderRepository;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.UocSaleOrderRepository;
import com.tydic.dyc.oc.repository.UocShipOrderRepository;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocCommonModelImpl
implements IUocCommonModel {
    @Autowired
    private UocCommonRepository uocCommonRepository;
    @Autowired
    private UocInitConfig uocInitConfig;
    @Autowired
    private UocShipOrderRepository uocShipOrderRepository;
    @Autowired
    private UocSaleOrderRepository uocSaleOrderRepository;
    @Autowired
    private UocChngOrderRepository uocChngOrderRepository;

    @Override
    public UocConfSupplierBo qryConfSupplier(String goodsSupplierNo) {
        return this.uocCommonRepository.qryConfSupplier(goodsSupplierNo);
    }

    @Override
    public UocCommonDo uploadFile(UocCommonDo uocCommonDo) {
        if (null == uocCommonDo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocCommonDo.getUocFile()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61uocFile\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocCommonDo.getUocFile().getFilename()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2[filename]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocCommonDo.getUocFile().getPath()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2[path]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocCommonDo.getUocFile().getInputStream()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2[inputStream]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocCommonDo.getUocFile().getFileType()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2[fileType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UocFile uocFile = this.uocCommonRepository.uploadFile(uocCommonDo.getUocFile());
        UocCommonDo commonDo = new UocCommonDo();
        commonDo.setUocFile(uocFile);
        return commonDo;
    }

    @Override
    public int saveOrderQueryIndex(UocOrderQueryIndex index) {
        return this.uocCommonRepository.saveOrderQueryIndex(index);
    }

    @Override
    public int dealTask(UocCommonDo uocCommonDo) {
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> nextTaskInfos;
        if (!CollectionUtils.isEmpty(uocCommonDo.getCompleteTaskInfos())) {
            uocCommonDo.getCompleteTaskInfos().forEach(completeTaskBo -> {
                UocOrderTaskInst qryInst = new UocOrderTaskInst();
                qryInst.setOrderId(uocCommonDo.getOrderId());
                qryInst.setTaskInstId(completeTaskBo.getTaskId());
                List<UocOrderTaskInst> uocOrderTaskInsts = this.uocCommonRepository.qryTaskInstList(qryInst);
                if (ObjectUtil.isEmpty(uocOrderTaskInsts)) {
                    throw new BaseBusinessException("101005", "\u4efb\u52a1\u5b9e\u4f8bid(" + completeTaskBo.getTaskId() + ")\u4e0d\u5b58\u5728");
                }
                if (UocDicConstant.PROC_TASK_FINISHED.FINISHED.equals(uocOrderTaskInsts.get(0).getFinishTag())) {
                    throw new BaseBusinessException("101005", "\u4efb\u52a1\u5b9e\u4f8bid(" + completeTaskBo.getTaskId() + ")\u5df2\u5b8c\u7ed3");
                }
                completeTaskBo.setBusiObjType(uocOrderTaskInsts.get(0).getObjType());
                completeTaskBo.setBusiObjId(uocOrderTaskInsts.get(0).getObjId());
                ArrayList<UocOrderTaskInst> updateList = new ArrayList<UocOrderTaskInst>();
                UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
                updateList.add(uocOrderTaskInst);
                uocOrderTaskInst.setOrderId(uocCommonDo.getOrderId());
                uocOrderTaskInst.setTaskInstId(completeTaskBo.getTaskId());
                this.uocCommonRepository.updateToFinished(updateList);
                if (null != completeTaskBo.getFinish() && completeTaskBo.getFinish().booleanValue()) {
                    String flag = "-F";
                    if (!StringUtils.isBlank((CharSequence)uocCommonDo.getOpFlag())) {
                        flag = flag + "-" + uocCommonDo.getOpFlag();
                    }
                    String state = this.uocInitConfig.getStateByTachecode(uocOrderTaskInsts.get(0).getProcState() + flag, completeTaskBo.getBusiObjType());
                    this.updateState(uocCommonDo, (UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo)completeTaskBo, state);
                }
            });
        }
        if (ObjectUtil.isNotEmpty(nextTaskInfos = uocCommonDo.getNextTaskInfos())) {
            ArrayList<UocOrderTaskDeal> saveDealList = new ArrayList<UocOrderTaskDeal>();
            ArrayList<UocOrderTaskInst> saveList = new ArrayList<UocOrderTaskInst>();
            for (UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo nextTaskInfo : nextTaskInfos) {
                UocOrderProcInst qryInst = new UocOrderProcInst();
                qryInst.setProcInstId(nextTaskInfo.getProcInstId());
                qryInst.setOrderId(uocCommonDo.getOrderId());
                List<UocOrderProcInst> uocOrderProcInsts = this.uocCommonRepository.qryProcInsList(qryInst);
                if (ObjectUtil.isEmpty(uocOrderProcInsts)) {
                    UocOrderProcInst createSaleProcIns = new UocOrderProcInst();
                    createSaleProcIns.setProcInstId(nextTaskInfo.getProcInstId());
                    createSaleProcIns.setOrderId(uocCommonDo.getOrderId());
                    createSaleProcIns.setProcDefId(nextTaskInfo.getProcDefId());
                    createSaleProcIns.setObjId(nextTaskInfo.getBusiObjId());
                    createSaleProcIns.setObjType(nextTaskInfo.getBusiObjType());
                    createSaleProcIns.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
                    createSaleProcIns.setId(IdUtil.nextId());
                    createSaleProcIns.setCreateTime(new Date());
                    this.uocCommonRepository.createProInst(createSaleProcIns);
                }
                UocOrderTaskInst taskBo = new UocOrderTaskInst();
                taskBo.setId(IdUtil.nextId());
                taskBo.setOrderId(uocCommonDo.getOrderId());
                taskBo.setTaskInstId(nextTaskInfo.getTaskId());
                taskBo.setObjId(nextTaskInfo.getBusiObjId());
                taskBo.setObjType(nextTaskInfo.getBusiObjType());
                taskBo.setProcState(nextTaskInfo.getStepId());
                taskBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
                taskBo.setFormUrl(nextTaskInfo.getFormUrl());
                taskBo.setProcDefId(nextTaskInfo.getProcDefId());
                taskBo.setProcInstId(nextTaskInfo.getProcInstId());
                saveList.add(taskBo);
                String assignee = nextTaskInfo.getAssignee();
                List candidates = nextTaskInfo.getCandidates();
                if (ObjectUtil.isNotEmpty((Object)assignee)) {
                    UocOrderTaskDeal deal = this.assembleTaskDealObj(uocCommonDo, nextTaskInfo);
                    deal.setDealId(assignee);
                    deal.setDealClass("1");
                    saveDealList.add(deal);
                } else if (ObjectUtil.isNotEmpty((Object)candidates)) {
                    for (String candidate : candidates) {
                        UocOrderTaskDeal deal = this.assembleTaskDealObj(uocCommonDo, nextTaskInfo);
                        deal.setDealId(candidate);
                        deal.setDealClass("2");
                        saveDealList.add(deal);
                    }
                }
                String state = this.uocInitConfig.getStateByTachecode(nextTaskInfo.getStepId(), nextTaskInfo.getBusiObjType());
                this.updateState(uocCommonDo, nextTaskInfo, state);
            }
            if (ObjectUtil.isNotEmpty(saveDealList)) {
                this.uocCommonRepository.saveOrderTaskDealList(saveDealList);
            }
            this.saveProcTaskInst(saveList);
        }
        return 1;
    }

    private void saveProcTaskInst(List<UocOrderTaskInst> saveTaskList) {
        Date createTime = new Date();
        if (ObjectUtil.isNotEmpty(saveTaskList)) {
            for (UocOrderTaskInst uocOrderTaskInst : saveTaskList) {
                uocOrderTaskInst.setCreateTime(createTime);
            }
            this.uocCommonRepository.saveProcTaskInst(saveTaskList);
        }
    }

    private UocOrderTaskDeal assembleTaskDealObj(UocCommonDo uocCommonDo, UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo nextTaskInfo) {
        UocOrderTaskDeal deal = new UocOrderTaskDeal();
        deal.setId(IdUtil.nextId());
        deal.setTaskInstId(nextTaskInfo.getTaskId());
        deal.setOrderId(uocCommonDo.getOrderId());
        deal.setObjId(nextTaskInfo.getBusiObjId());
        deal.setObjType(nextTaskInfo.getBusiObjType());
        return deal;
    }

    private void updateState(UocCommonDo uocCommonDo, UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo, String state) {
        if (ObjectUtil.isNotEmpty((Object)state)) {
            if (UocDicConstant.OBJ_TYPE.SHIP.equals(taskBo.getBusiObjType())) {
                UocShipOrderDo updateShipDo = new UocShipOrderDo();
                updateShipDo.setUpdateOperId(Convert.toStr((Object)uocCommonDo.getUserId()));
                updateShipDo.setOrderId(uocCommonDo.getOrderId());
                updateShipDo.setShipOrderId(taskBo.getBusiObjId());
                updateShipDo.setShipOrderState(state);
                if (taskBo.getFinish().booleanValue()) {
                    updateShipDo.setFinishFlag(UocConstant.SHIP_ORDER_FINISH_FLAG.FINISH);
                }
                this.updateShipStatusAndProCode(updateShipDo);
            }
            if (UocDicConstant.OBJ_TYPE.SALE.equals(taskBo.getBusiObjType())) {
                UocSaleOrderDo updateSaleDo = new UocSaleOrderDo();
                updateSaleDo.setUpdateOperId(Convert.toStr((Object)uocCommonDo.getUserId()));
                updateSaleDo.setOrderId(uocCommonDo.getOrderId());
                updateSaleDo.setSaleOrderId(taskBo.getBusiObjId());
                updateSaleDo.setSaleOrderState(state);
                this.updateSaleStatusAndProCode(updateSaleDo);
            }
            if (UocDicConstant.OBJ_TYPE.CHNG.equals(taskBo.getBusiObjType())) {
                UocChngOrderDo updateChngDo = new UocChngOrderDo();
                updateChngDo.setUpdateOperId(Convert.toStr((Object)uocCommonDo.getUserId()));
                updateChngDo.setOrderId(uocCommonDo.getOrderId());
                updateChngDo.setChngOrderId(taskBo.getBusiObjId());
                updateChngDo.setChngOrderState(state);
                this.updateShipStatusAndProCode(updateChngDo);
            }
        }
    }

    private void updateShipStatusAndProCode(UocChngOrderDo uocChngOrderDo) {
        UocChngOrderQryBo qryBo = new UocChngOrderQryBo();
        qryBo.setOrderId(uocChngOrderDo.getOrderId());
        qryBo.setChngOrderId(uocChngOrderDo.getChngOrderId());
        UocChngOrderDo chngOrderDo = this.uocChngOrderRepository.getChngOrder(qryBo);
        if (ObjectUtil.isEmpty((Object)chngOrderDo)) {
            throw new BaseBusinessException("102003", "\u8be5\u53d8\u66f4\u5355" + uocChngOrderDo.getChngOrderId() + "\u4e0d\u5b58\u5728");
        }
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(uocChngOrderDo.getChngOrderId());
        uocOrderStateChgLog.setOrderId(uocChngOrderDo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
        uocOrderStateChgLog.setOldState(chngOrderDo.getChngOrderState());
        uocOrderStateChgLog.setNewState(uocChngOrderDo.getChngOrderState());
        uocOrderStateChgLog.setChgTime(new Date());
        uocOrderStateChgLog.setOperId(uocChngOrderDo.getUpdateOperId());
        this.uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);
        this.uocChngOrderRepository.updateChngStatusAndProCode(uocChngOrderDo);
    }

    private UocSaleOrderDo updateSaleStatusAndProCode(UocSaleOrderDo reqBo) {
        this.validateUpdateSaleOrderArg(reqBo);
        UocSaleOrderQryBo qryBo = new UocSaleOrderQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.qrySaleOrder(qryBo);
        if (ObjectUtil.isEmpty((Object)uocSaleOrderDo)) {
            throw new BaseBusinessException("102001", "\u8be5\u9500\u552e\u5355" + reqBo.getSaleOrderId() + "\u4e0d\u5b58\u5728");
        }
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(reqBo.getSaleOrderId());
        uocOrderStateChgLog.setOrderId(reqBo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderStateChgLog.setOldState(uocSaleOrderDo.getSaleOrderState());
        uocOrderStateChgLog.setNewState(reqBo.getSaleOrderState());
        uocOrderStateChgLog.setChgTime(new Date());
        uocOrderStateChgLog.setOperId(reqBo.getUpdateOperId());
        this.uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);
        return this.uocSaleOrderRepository.updateSaleStatusAndProCode(reqBo);
    }

    private void validateUpdateSaleOrderArg(UocSaleOrderDo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocUpdateSaleOrderStateServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUpdateOperId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u66f4\u65b0\u4ebaid\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u8ba2\u5355id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u9500\u552e\u5355id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderState())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u9500\u552e\u5355\u72b6\u6001\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UocSaleOrderDo qrySaleOrder(UocSaleOrderQryBo uocSaleOrderQryBo) {
        if (null == uocSaleOrderQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.qrySaleOrder(uocSaleOrderQryBo);
    }

    private void updateShipStatusAndProCode(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderQryBo qryBo = new UocShipOrderQryBo();
        qryBo.setOrderId(uocShipOrderDo.getOrderId());
        qryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        UocShipOrderDo shipOrderDo = this.getShipOrderById(qryBo);
        if (ObjectUtil.isEmpty((Object)shipOrderDo)) {
            throw new BaseBusinessException("102002", "\u8be5\u53d1\u8d27\u5355" + uocShipOrderDo.getShipOrderId() + "\u4e0d\u5b58\u5728");
        }
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(uocShipOrderDo.getShipOrderId());
        uocOrderStateChgLog.setOrderId(uocShipOrderDo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        uocOrderStateChgLog.setOldState(shipOrderDo.getShipOrderState());
        uocOrderStateChgLog.setNewState(uocShipOrderDo.getShipOrderState());
        uocOrderStateChgLog.setChgTime(new Date());
        uocOrderStateChgLog.setOperId(uocShipOrderDo.getUpdateOperId());
        this.uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);
        this.uocShipOrderRepository.updateShipStatusAndProCode(uocShipOrderDo);
    }

    private UocShipOrderDo getShipOrderById(UocShipOrderQryBo uocShipOrderQryBo) {
        if (null == uocShipOrderQryBo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocShipOrderQryBo.getOrderId()) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocShipOrderRepository.getShipOrderById(uocShipOrderQryBo);
    }
}

