/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocConfEffective;
import com.tydic.dyc.oc.service.order.UocRemainingTimeQueryService;
import com.tydic.dyc.oc.service.order.bo.UocRemainingTimeInfoBo;
import com.tydic.dyc.oc.service.order.bo.UocRemainingTimeQueryServiceReqBo;
import com.tydic.dyc.oc.service.order.bo.UocRemainingTimeQueryServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.order.UocRemainingTimeQueryService"})
public class UocRemainingTimeQueryServiceImpl
implements UocRemainingTimeQueryService {
    private static final Logger log = LoggerFactory.getLogger(UocRemainingTimeQueryServiceImpl.class);
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @PostMapping(value={"querySalesRemainingTime"})
    public UocRemainingTimeQueryServiceRspBo querySalesRemainingTime(@RequestBody UocRemainingTimeQueryServiceReqBo reqBo) {
        UocRemainingTimeQueryServiceRspBo rspBo = UocRu.success(UocRemainingTimeQueryServiceRspBo.class);
        UocConfEffective uocConfEffective = new UocConfEffective();
        HashSet<String> supNo = new HashSet<String>(reqBo.getRemainingTimeInfoBoMap().size());
        HashSet<String> effectiveCode = new HashSet<String>(reqBo.getRemainingTimeInfoBoMap().size());
        HashSet<String> businessTypeCode = new HashSet<String>(reqBo.getRemainingTimeInfoBoMap().size());
        supNo.add("0");
        HashMap stringMap = new HashMap(reqBo.getRemainingTimeInfoBoMap().size());
        for (Map.Entry remainingTimeInfoBoEntry : reqBo.getRemainingTimeInfoBoMap().entrySet()) {
            List value;
            UocRemainingTimeInfoBo remainingTimeInfoBo = (UocRemainingTimeInfoBo)remainingTimeInfoBoEntry.getValue();
            supNo.add(remainingTimeInfoBo.getSupNo());
            effectiveCode.add(remainingTimeInfoBo.getEffectiveCode());
            businessTypeCode.add(remainingTimeInfoBo.getBusinessTypeCode());
            String key = remainingTimeInfoBo.getSupNo() + "|" + remainingTimeInfoBo.getEffectiveCode() + "," + remainingTimeInfoBo.getBusinessTypeCode();
            if (stringMap.containsKey(key)) {
                value = (List)stringMap.get(key);
                value.add(remainingTimeInfoBoEntry.getKey());
                stringMap.put(key, value);
                continue;
            }
            value = new ArrayList();
            value.add(remainingTimeInfoBoEntry.getKey());
            stringMap.put(key, value);
        }
        uocConfEffective.setEffectiveCodeSet(effectiveCode);
        uocConfEffective.setSupplierNoSet(supNo);
        uocConfEffective.setBusiTypeCodeSet(businessTypeCode);
        List<UocConfEffective> uocConfEffectiveList = this.iUocOrderModel.getRemainingTimeInfo(uocConfEffective);
        if (!CollectionUtils.isEmpty(uocConfEffectiveList)) {
            HashMap<String, UocRemainingTimeInfoBo> stringMap1 = new HashMap<String, UocRemainingTimeInfoBo>(reqBo.getRemainingTimeInfoBoMap().size());
            for (UocConfEffective effectivePO : uocConfEffectiveList) {
                if (!"0".equals(effectivePO.getSupplierNo())) {
                    stringMap1.put(effectivePO.getSupplierNo() + "|" + effectivePO.getEffectiveCode() + "," + effectivePO.getBusinessTypeCode(), UocRu.js(effectivePO, UocRemainingTimeInfoBo.class));
                    continue;
                }
                stringMap1.put(effectivePO.getEffectiveCode() + "," + effectivePO.getBusinessTypeCode(), UocRu.js(effectivePO, UocRemainingTimeInfoBo.class));
            }
            long time = System.currentTimeMillis();
            for (Map.Entry stringEntry : stringMap.entrySet()) {
                String key = (String)stringEntry.getKey();
                UocRemainingTimeInfoBo effectivePO = (UocRemainingTimeInfoBo)stringMap1.get(key);
                if (null == effectivePO) {
                    effectivePO = (UocRemainingTimeInfoBo)stringMap1.get(key.split("\\|")[1]);
                }
                for (String value : (List)stringEntry.getValue()) {
                    UocRemainingTimeInfoBo remainingTimeInfoBo1 = (UocRemainingTimeInfoBo)reqBo.getRemainingTimeInfoBoMap().get(value);
                    if (null == remainingTimeInfoBo1 || null == effectivePO) continue;
                    remainingTimeInfoBo1.setAging(effectivePO.getAging());
                    remainingTimeInfoBo1.setTimeLeft(Long.valueOf(effectivePO.getAging() - time + remainingTimeInfoBo1.getCalculationTime().getTime()));
                    reqBo.getRemainingTimeInfoBoMap().put(value, remainingTimeInfoBo1);
                }
            }
        }
        return rspBo;
    }
}

