package com.tydic.dyc.oc.model.insporder;

import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderMap;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocInspOrder
 * 说明:验收单
 * 时间:2022-02-21 14:33
 * 作者:罗有
 **/
@Data
public class UocInspOrderDo implements Serializable {
	private static final long serialVersionUID = -6213206622150534568L;

	@DocField(value = "验收单id")
	private Long inspOrderId;


	@DocField(value = "执行明细id")
	private Long implOrderItemId;

	@DocField(value = "销售单id")
	private Long saleOrderId;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "发货单编码")
	private String inspOrderNo;

	@DocField(value = "外部发货单编码")
	private String inspOrderNoExt;

	@DocField(value = "验收单名称")
	private String inspOrderName;

	@DocField(value = "验收单类型")
	private Integer inspOrderType;

	@DocField(value = "验收单状态")
	private String inspOrderState;

	@DocField(value = "销售金额")
	private BigDecimal totalSaleFee;

	@DocField(value = "采购金额")
	private BigDecimal totalPurchaseFee;

	@DocField(value = "实付金额")
	private BigDecimal usedFee;

	@DocField(value = "开票标识 0未开票 1已开票")
	private Integer invoiceTag;

	@DocField(value = "流转状态")
	private String procState;

	@DocField(value = "对账状态")
	private String checkState;

	@DocField(value = "租户ID")
	private String tenantId;

	@DocField(value = "竣工标志             1 竣工             0 在途")
	private Integer finishFlag;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "验收人电话")
	private String inspOperPhone;

	@DocField(value = "验收人名字")
	private String inspOper;

	@DocField(value = "允许变更时限")
	private Date allowChngTime;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "撤单时间")
	private Date cancelTime;

	@DocField(value = "撤单工号")
	private String cancelOperId;

	@DocField(value = "撤单原因")
	private String cancelReason;

	@DocField(value = "撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "其它备注")
	private String otherRemark;

	@DocField(value = "竣工时间")
	private Date finishTime;

	@DocField(value = "逾期时间")
	private Date expTime;

	@DocField(value = "总金额")
	private BigDecimal totalFee;

	@DocField(value = "总数量")
	private Integer totalCount;

	@DocField(value = "验收明细")
	private List<UocInspOrderItem> uocInspOrderItemList;

	@DocField(value = "验收发货关系")
	private List<UocShipInspRel> uocShipInspRelList;

	@DocField(value = "纵向扩展")
	private List<UocInspOrderMap> extParallelBoList;

	@DocField(value = "附件")
	private List<UocOrderAccessory> uocOrderAccessoryList;

	@DocField(value = "订单来源  1 自营单品   2 电商导入   3 协议生成    ")
	private Integer orderSource;
}
