package com.tydic.dyc.oc.model.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.repository.UocOrderRepository;
import com.tydic.dyc.oc.utils.IdUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;


/**
 * 标题:OrderModelmpl
 * 说明:
 * 时间:2022/2/16 11:39
 * 作者:田桂银
 */
@Slf4j
@Service
public class OrderModelmpl implements IUocOrderModel {

    @Autowired
    private UocOrderRepository uocOrderRepository;

    @Override
    public UocOrderDo createOrder(UocOrderDo orderDo) {
        validateCreateOrderArg(orderDo);
        orderDo.setOrderId(IdUtil.nextId());
        orderDo.setCreateTime(new Date());

        //组装地址信息（收货地址，发票地址）
        setAddressInfo(orderDo);

        //组装订单主数据
        setOrderInfo(orderDo);

        //组装发票信息
        UocOrdInvoice uocOrdInvoice = orderDo.getUocOrdInvoice();
        if (ObjectUtil.isNotEmpty(uocOrdInvoice)) {
            uocOrdInvoice.setId(IdUtil.nextId());
            uocOrdInvoice.setOrderId(orderDo.getOrderId());
            uocOrdInvoice.setContactId(orderDo.getInvoiceAddress().getContactId());
            uocOrdInvoice.setCreateOperId(orderDo.getCreateOperId());
            uocOrdInvoice.setCreateTime(orderDo.getCreateTime());
        }

        //组装附件信息
        List<UocOrderAccessory> accessoryList = orderDo.getAccessoryList();
        for (UocOrderAccessory uocOrderAccessory : accessoryList) {
            uocOrderAccessory.setId(IdUtil.nextId());
            uocOrderAccessory.setOrderId(orderDo.getOrderId());
            uocOrderAccessory.setCreateTime(orderDo.getCreateTime());
            uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
            uocOrderAccessory.setObjId(orderDo.getOrderId());
            uocOrderAccessory.setAttachmentType(UocDicConstant.ACCESSORY_TYPE.CREATE_ORDER);
        }

        //设置订单明细信息
        setOrderItemInfo(orderDo);

        //设置订单扩展信息
        setOrderExtInfo(orderDo);

        return uocOrderRepository.saveUocOrder(orderDo);
    }

    private void setOrderExtInfo(UocOrderDo orderDo) {
        List<UocOrderMap> orderExt = orderDo.getOrderExt();
        if (ObjectUtil.isNotEmpty(orderExt)) {
            for (UocOrderMap uocOrderMap : orderExt) {
                uocOrderMap.setId(IdUtil.nextId());
                uocOrderMap.setCreateTime(orderDo.getCreateTime());
                uocOrderMap.setOrderId(uocOrderMap.getOrderId());
            }
        }
    }

    private void validateCreateOrderArg(UocOrderDo orderDo) {
        if (ObjectUtil.isEmpty(orderDo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        List<UocOrderItem> orderItems = orderDo.getOrderItems();

        if (ObjectUtil.isEmpty(orderItems)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[商品列表]不能为空");
        }


    }

    @Override
    public UocOrderDo createOrderAccessory(List<UocOrderAccessory> uocOrderAccessoryList) {
        if (ObjectUtil.isEmpty(uocOrderAccessoryList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.createOrderAccessory(uocOrderAccessoryList);
    }

    private void setOrderItemInfo(UocOrderDo orderDo) {
        //订单明细数据
        List<UocOrderItem> orderItems = orderDo.getOrderItems();


        for (UocOrderItem orderItem : orderItems) {
            orderItem.setOrderItemId(IdUtil.nextId());
            orderItem.setOrderId(orderDo.getOrderId());
            orderItem.setCreateTime(orderDo.getCreateTime());
            orderItem.setCreateOperId(orderDo.getCreateOperId());

            //订单明细扩展数据，可能为空
            List<UocOrderItemMap> itemMapList = orderItem.getItemMapList();
            if (ObjectUtil.isNotEmpty(itemMapList)) {
                for (UocOrderItemMap itemMap : itemMapList) {
                    itemMap.setId(IdUtil.nextId());
                    itemMap.setOrderItemId(orderItem.getOrderItemId());
                    itemMap.setOrderId(orderDo.getOrderId());
                    itemMap.setCreateTime(orderDo.getCreateTime());
                    itemMap.setCreateOperId(orderDo.getCreateOperId());
                }
            }

            //商品延保数据，可能为空
            List<UocOrderItemEw> ewList = orderItem.getEwList();
            if (ObjectUtil.isNotEmpty(ewList)) {
                for (UocOrderItemEw ew : ewList) {
                    ew.setId(IdUtil.nextId());
                    ew.setOrderItemId(orderItem.getOrderItemId());
                    ew.setOrderId(orderDo.getOrderId());
                    ew.setCreateOperId(orderDo.getCreateOperId());
                    ew.setCreateTime(orderDo.getCreateTime());
                    ew.setSkuId(orderItem.getSkuId());
                }
            }


            if (ObjectUtil.isNotEmpty(orderItem.getAgreementId())) {
                UocOrderAgreement agrBo = orderItem.getAgrBo();
                agrBo.setOrderId(orderDo.getOrderId());
                agrBo.setId(IdUtil.nextId());
            }

        }

    }


    private void setOrderInfo(UocOrderDo orderDo) {
        //根据是否传入开票对象，判断是否需要开票
        if (ObjectUtil.isNotEmpty(orderDo.getUocOrdInvoice())) {
            orderDo.setNeedInvoiceTag(UocDicConstant.NEED_INVOICED.NEED_INVOICED_Y);
        } else {
            orderDo.setNeedInvoiceTag(UocDicConstant.NEED_INVOICED.NEED_INVOICED_N);
        }

        //设置收货地址id
        orderDo.setContactId(orderDo.getReceiverAddress() != null ? orderDo.getReceiverAddress().getContactId() : null);

        //转换，并保存订单主体数据

        //保存订单扩展数据
        if (ObjectUtil.isNotEmpty(orderDo.getOrderExt())) {
            List<UocOrderMap> orderExt = orderDo.getOrderExt();
            for (UocOrderMap map : orderExt) {
                map.setOrderId(orderDo.getOrderId());
                map.setCreateOperId(orderDo.getCreateOperId());
                map.setId(IdUtil.nextId());
                map.setCreateTime(orderDo.getCreateTime());
            }
        }
    }

    private void setAddressInfo(UocOrderDo orderDo) {
        UocOrdLogisticsRela invoiceAddress = orderDo.getInvoiceAddress();
        if (invoiceAddress != null) {
            invoiceAddress.setOrderId(orderDo.getOrderId());
            invoiceAddress.setContactId(IdUtil.nextId());
            invoiceAddress.setCreateOperId(orderDo.getCreateOperId());
            invoiceAddress.setCreateTime(orderDo.getCreateTime());
        }

        UocOrdLogisticsRela receiverAddress = orderDo.getReceiverAddress();
        if (receiverAddress != null) {
            receiverAddress.setOrderId(orderDo.getOrderId());
            receiverAddress.setContactId(IdUtil.nextId());
            receiverAddress.setCreateOperId(orderDo.getCreateOperId());
            receiverAddress.setCreateTime(orderDo.getCreateTime());
        }
    }

    @Override
    public UocOrdLogisticsRela createOrderLogisticsRela(UocOrdLogisticsRela uocOrdLogisticsRela) {
        if (null == uocOrdLogisticsRela) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.createOrderLogisticsRela(uocOrdLogisticsRela);
    }

    @Override
    public UocOrderStateChgLog createOrderStateChangeLog(UocOrderStateChgLog uocOrderStateChgLog) {
        if (null == uocOrderStateChgLog) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.createOrderStateChangeLog(uocOrderStateChgLog);
    }

    @Override
    public List<UocOrderStakeholderQryBo> qryStakeholderList(UocOrderStakeholderQryBo qryBo) {
        return uocOrderRepository.qryStakeholderList(qryBo);
    }

    @Override
    public List<UocOrderTaskInst> qryOrderTaskInstList(UocOrderTaskInstQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryOrderTaskInstList(qryBo);
    }

    @Override
    public List<UocOrderTaskDeal> qryOrderTaskDealList(UocOrderTaskDealQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryOrderTaskDealList(qryBo);
    }

    @Override
    public List<UocOrderProcInst> qryOrderProcInstList(UocOrderProcInstQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryOrderProcInstList(qryBo);
    }

    @Override
    public UocOrderDo qryOrderBy(UocOrderDo uocOrderDo) {
        if (null == uocOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryOrderBy(uocOrderDo);
    }

    @Override
    public List<UocOrderItem> qryOrderItemList(UocOrderItemQryBo uocOrderItemQryBo) {
        if (null == uocOrderItemQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryOrderItemList(uocOrderItemQryBo);
    }

    @Override
    public UocOrdLogisticsRela qryOrderLogisticsRela(UocOrdLogisticsRelaQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryOrderLogisticsRela(qryBo);
    }

    @Override
    public UocOrdInvoice qryOrderInvoice(UocOrdInvoiceQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryOrderInvoice(qryBo);
    }

    @Override
    public List<UocOrderAccessory> getOrderAccessoryList(UocOrderAccessoryQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.getOrderAccessoryList(qryBo);
    }

    @Override
    public List<UocOrderMap> qryOrderMapList(UocOrderMapQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryOrderMapList(qryBo);
    }

    @Override
    public void dealRelUpdate(UocOrderRel qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        uocOrderRepository.dealRelUpdate(qryBo);
    }

    @Override
    public List<UocOrderQueryIndex> qryOrderQueryIndexList(UocOrderQueryIndexQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryOrderQueryIndexList(qryBo);
    }

    @Override
    public UocOrderRel qryRelInfo(UocOrderRelQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryRelInfo(qryBo);
    }

    @Override
    public List<UocOrderRel> qryListRelInfo(UocOrderRelQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryListRelInfo(qryBo);
    }

    @Override
    public void createRelInfo(UocOrderRel uocOrderRel) {
        if (null == uocOrderRel) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        uocOrderRepository.createRelInfo(uocOrderRel);
    }

    @Override
    public UocOrderCheckAccount qryCheckInfo(UocOrderCheckAccountQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryCheckInfo(qryBo);
    }

    @Override
    public void createCheckInfo(UocOrderCheckAccount uocOrderCheckAccount) {
        if (null == uocOrderCheckAccount) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        uocOrderRepository.createCheckInfo(uocOrderCheckAccount);
    }

    @Override
    public void updateCheckInfo(UocOrderCheckAccount uocOrderCheckAccount) {
        if (null == uocOrderCheckAccount) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        uocOrderRepository.updateCheckInfo(uocOrderCheckAccount);
    }

    @Override
    public void modifySalePrice(UocOrderDo uocOrderDo) {
        // 修改订单单明细销售金额
        uocOrderRepository.modifyBatchItemSalePrice(uocOrderDo);
        // 统计订单明细销售价总金额
        UocOrderDo uocOrderDo2 = new UocOrderDo();
        uocOrderDo2.setOrderId(uocOrderDo.getOrderId());
        UocOrderDo uocOrderDo4 = uocOrderRepository.getOrderItemTotalPrice(uocOrderDo2);
        // 更新订单销售金额
        UocOrderDo uocOrderDo3 = new UocOrderDo();
        uocOrderDo3.setOrderId(uocOrderDo.getOrderId());
        uocOrderDo3.setTotalSaleFee(uocOrderDo4.getTotalSaleFee());
        uocOrderDo3.setUpdateOperId(uocOrderDo.getUpdateOperId());
        uocOrderDo3.setUpdateTime(uocOrderDo.getUpdateTime());
        uocOrderRepository.modifyOrderMain(uocOrderDo3);
    }

    @Override
    public BasePageRspBo<UocConfEvaluate> qryListPageConfEvaluate(UocConfEvaluateQryBo uocConfEvaluateQryBo) {
        return uocOrderRepository.qryListPageConfEvaluate(uocConfEvaluateQryBo);
    }

    @Override
    public BasePageRspBo<UocConfEffective> qryListPageConfEffective(UocConfEffectiveQryBo uocConfEffectiveQryBo) {
        return uocOrderRepository.qryListPageConfEffective(uocConfEffectiveQryBo);
    }

    @Override
    public void addConfEvaluate(UocConfEvaluate uocConfEvaluate) {
        uocOrderRepository.addConfEvaluate(uocConfEvaluate);
    }

    @Override
    public void modifyConfEvaluate(UocConfEvaluate uocConfEvaluate) {
        uocOrderRepository.modifyConfEvaluate(uocConfEvaluate);
    }

    @Override
    public void deleteConfEvaluate(UocConfEvaluate uocConfEvaluate) {
        uocOrderRepository.deleteConfEvaluate(uocConfEvaluate);
    }

    @Override
    public UocConfEvaluate getConfEvaluateById(Long id) {
        return uocOrderRepository.getConfEvaluateById(id);
    }

    @Override
    public int getCheckConfEvaluate(UocConfEvaluate uocConfEvaluate) {
        return uocOrderRepository.getCheckConfEvaluate(uocConfEvaluate);
    }

    @Override
    public List<UocConfTabOrdState> qryConfTabOrdStateList(UocConfTabOrdStateQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryConfTabOrdStateList(qryBo);
    }

    @Override
    public UocConfButton updateConfButton(UocConfButton confButton) {
        if (null == confButton) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        if (null == confButton.getId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象属性值【ID】不能为空");
        }
        return uocOrderRepository.updateConfButton(confButton);
    }

    @Override
    public List<UocConfButton> qryConfButtonList(UocConfButtonQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryConfButtonList(qryBo);
    }

    @Override
    public int deleteConfSupplierBy(UocConfSupplier uocConfSupplier) {
        return uocOrderRepository.deleteConfSupplierBy(uocConfSupplier);
    }

    @Override
    public int updateConfSupplierById(UocConfSupplier uocConfSupplier) {
        return uocOrderRepository.updateConfSupplierById(uocConfSupplier);
    }

    @Override
    public UocConfSupplier getConfSupplierModelById(long supNo) {
        return uocOrderRepository.getConfSupplierModelById(supNo);
    }

    @Override
    public UocConfSupplier getConfSupplierModelBy(UocConfSupplier uocConfSupplier) {
        return uocOrderRepository.getConfSupplierModelBy(uocConfSupplier);
    }

    @Override
    public int addConfSupplier(UocConfSupplier uocConfSupplier) {
        return uocOrderRepository.addConfSupplier(uocConfSupplier);
    }

    @Override
    public List<UocConfInspectionUse> qryInspectionConfigUseList(UocConfInspectionUse uocConfInspectionUse) {
        return uocOrderRepository.qryInspectionConfigUseList(uocConfInspectionUse);
    }

    @Override
    public List<UocConfInspection> qryInspectionConfigList(UocConfInspection uocConfInspection) {
        return uocOrderRepository.qryInspectionConfigList(uocConfInspection);
    }

    @Override
    public void updateInspectionConfigUse(UocConfInspectionUse uocConfInspectionUse) {
        uocOrderRepository.updateInspectionConfigUse(uocConfInspectionUse);
    }

    @Override
    public void deleteInspectionConfig(UocConfInspection uocConfInspection) {
        uocOrderRepository.deleteInspectionConfig(uocConfInspection);
    }

    @Override
    public void insertInspectionConfigByBatch(List<UocConfInspection> uocConfInspections) {
        uocOrderRepository.insertInspectionConfigByBatch(uocConfInspections);
    }

    @Override
    public int getCheckConfEffectiveBy(UocConfEffectiveQryBo uocConfEffectiveQryBo) {
        return uocOrderRepository.getCheckConfEffectiveBy(uocConfEffectiveQryBo);
    }

    @Override
    public void addConfEffective(UocConfEffective uocConfEffective) {
        uocOrderRepository.addConfEffective(uocConfEffective);
    }

    @Override
    public UocConfEffective getConfEffectiveBy(UocConfEffective uocConfEffective) {
        return uocOrderRepository.getConfEffectiveBy(uocConfEffective);
    }

    @Override
    public void deleteConfEffective(UocConfEffective uocConfEffective) {
        uocOrderRepository.deleteConfEffective(uocConfEffective);
    }

    @Override
    public int updateEffectiveConfById(UocConfEffective effective) {
        return uocOrderRepository.updateEffectiveConfById(effective);
    }

    @Override
    public int getCheckMsg(UocDMsgPoolQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.getCheckMsg(qryBo);
    }

    @Override
    public int insertMsgPool(UocDMsgPoolQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.insertMsgPool(qryBo);
    }

    @Override
    public BasePageRspBo<ConfSupplierQryBo> getListPage(ConfSupplierQryBo confSupplierQryBo) {
        return uocOrderRepository.qryListPageConfSupplier(confSupplierQryBo);
    }

    @Override
    public void insertOrderEvaluate(UocEvaluate uocEvaluate) {
        if (null == uocEvaluate) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        uocOrderRepository.insertOrderEvaluate(uocEvaluate);
    }

    @Override
    public List<UocEvaluate> qryOrderEvaluateList(UocEvaluateQryBo uocEvaluateQryBo) {
        if (null == uocEvaluateQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.qryOrderEvaluateList(uocEvaluateQryBo);
    }

    @Override
    public void updateOrderEvaluate(UocEvaluate uocEvaluate) {
        if (null == uocEvaluate) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        uocOrderRepository.updateOrderEvaluate(uocEvaluate);
    }

    @Override
    public List<UocDMsgPoolQryBo> getListByRunResultAndFailureCount(UocDMsgPoolQryBo qryBo) {
        return uocOrderRepository.getListByRunResultAndFailureCount(qryBo);
    }

    @Override
    public List<UocDMsgPoolQryBo> getVoteMsgList(UocDMsgPoolQryBo qryBo) {
        return uocOrderRepository.getVoteMsgList(qryBo);
    }

    @Override
    public List<UocDMsgPoolQryBo> getMsgList(UocDMsgPoolQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocOrderRepository.getMsgList(qryBo);
    }

    @Override
    public UocDMsgPoolQryBo getModelByMsgId(UocDMsgPoolQryBo qryBo) {

        return uocOrderRepository.getModelByMsgId(qryBo);
    }

    @Override
    public void updateMsgPoolById(UocDMsgPoolQryBo qryBo) {
        uocOrderRepository.upDateMsgPoolById(qryBo);
    }

    @Override
    public void updateQueryIndexById(UocOrderQueryIndexQryBo qryBo) {
        uocOrderRepository.updateQueryIndexById(qryBo);
    }

    @Override
    public List<UocTacheButton> qryTacheButton(UocTacheButtonQryBo uocTacheButtonQryBo) {
        return uocOrderRepository.qryTacheButton(uocTacheButtonQryBo);
    }

    @Override
    public void modifyTabConf(UocConfTabOrdState uocConfTabOrdState) {
        uocOrderRepository.modifyTabConf(uocConfTabOrdState);
    }

    @Override
    public List<UocOrderItemMap> qryOrderItemMapList(UocOrderItemMapQryBo uocOrderItemMapQryBo) {
        return uocOrderRepository.qryOrderItemMapList(uocOrderItemMapQryBo);
    }

    @Override
    public void deleteAuditConf(UocConfAudit uocConfAudit) {
        uocOrderRepository.deleteAuditConf(uocConfAudit);
    }

    @Override
    public List<UocConfAudit> qryListAuditConf(UocConfAuditQryBo uocConfAuditQryBo) {
        return uocOrderRepository.qryListAuditConf(uocConfAuditQryBo);
    }

    @Override
    public void updateAuditConf(UocConfAudit uocConfAudit) {
        uocOrderRepository.updateAuditConf(uocConfAudit);
    }

    @Override
    public void addExceptionAuditConf(UocConfAudit uocConfAudit) {
        uocOrderRepository.addExceptionAuditConf(uocConfAudit);
    }

    @Override
    public void modifyPurchasePrice(UocOrderDo uocOrderDo) {
        // 修改订单单明细采购金额
        uocOrderRepository.modifyBatchItemPurchasePrice(uocOrderDo);
        // 统计订单明细采购价总金额
        UocOrderDo uocOrderDo2 = new UocOrderDo();
        uocOrderDo2.setOrderId(uocOrderDo.getOrderId());
        UocOrderDo uocOrderDo4 = uocOrderRepository.getOrderItemTotalPrice(uocOrderDo2);
        // 更新订单采购金额
        UocOrderDo uocOrderDo3 = new UocOrderDo();
        uocOrderDo3.setOrderId(uocOrderDo.getOrderId());
        uocOrderDo3.setTotalPurchaseFee(uocOrderDo4.getTotalPurchaseFee());
        uocOrderDo3.setUpdateOperId(uocOrderDo.getUpdateOperId());
        uocOrderDo3.setUpdateTime(uocOrderDo.getUpdateTime());
        uocOrderRepository.modifyOrderMain(uocOrderDo3);
    }

    @Override
    public List<UocConfEffective> getRemainingTimeInfo(UocConfEffective uocConfEffective) {
        return uocOrderRepository.getRemainingTimeInfo(uocConfEffective);
    }

}


