package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocConfEffective;
import com.tydic.dyc.oc.service.order.bo.UocRemainingTimeInfoBo;
import com.tydic.dyc.oc.service.order.bo.UocRemainingTimeQueryServiceReqBo;
import com.tydic.dyc.oc.service.order.bo.UocRemainingTimeQueryServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.*;

@Slf4j
@HTServiceImpl
public class UocRemainingTimeQueryServiceImpl implements UocRemainingTimeQueryService {
    
    @Autowired
    private IUocOrderModel iUocOrderModel;
    
    @Override
    public UocRemainingTimeQueryServiceRspBo querySalesRemainingTime(UocRemainingTimeQueryServiceReqBo reqBo) {
        UocRemainingTimeQueryServiceRspBo rspBo = UocRu.success(UocRemainingTimeQueryServiceRspBo.class);
        UocConfEffective uocConfEffective = new UocConfEffective();
        
        Set<String> supNo = new HashSet<>(reqBo.getRemainingTimeInfoBoMap().size());
        Set<String> effectiveCode = new HashSet<>(reqBo.getRemainingTimeInfoBoMap().size());
        Set<String> businessTypeCode = new HashSet<>(reqBo.getRemainingTimeInfoBoMap().size());
        supNo.add("0");
        UocRemainingTimeInfoBo remainingTimeInfoBo;
        Map<String, List<String>> stringMap = new HashMap<>(reqBo.getRemainingTimeInfoBoMap().size());
        for (Map.Entry<String, UocRemainingTimeInfoBo> remainingTimeInfoBoEntry : reqBo.getRemainingTimeInfoBoMap().entrySet()) {
            remainingTimeInfoBo = remainingTimeInfoBoEntry.getValue();
            supNo.add(remainingTimeInfoBo.getSupNo());
            effectiveCode.add(remainingTimeInfoBo.getEffectiveCode());
            businessTypeCode.add(remainingTimeInfoBo.getBusinessTypeCode());
            String key = remainingTimeInfoBo.getSupNo() + "|" + remainingTimeInfoBo.getEffectiveCode() + "," + remainingTimeInfoBo.getBusinessTypeCode();
            if (stringMap.containsKey(key)) {
                List<String> value = stringMap.get(key);
                value.add(remainingTimeInfoBoEntry.getKey());
                stringMap.put(key, value);
            } else {
                List<String> value = new ArrayList<>();
                value.add(remainingTimeInfoBoEntry.getKey());
                stringMap.put(key, value);
            }
        }
        uocConfEffective.setEffectiveCodeSet(effectiveCode);
        uocConfEffective.setSupplierNoSet(supNo);
        uocConfEffective.setBusiTypeCodeSet(businessTypeCode);
        List<UocConfEffective> uocConfEffectiveList = iUocOrderModel.getRemainingTimeInfo(uocConfEffective);
    
        if (!CollectionUtils.isEmpty(uocConfEffectiveList)) {
            Map<String, UocRemainingTimeInfoBo> stringMap1 = new HashMap<>(reqBo.getRemainingTimeInfoBoMap().size());
            for (UocConfEffective effectivePO : uocConfEffectiveList) {
                if (!"0".equals(effectivePO.getSupplierNo())) {
                    stringMap1.put(effectivePO.getSupplierNo() + "|" + effectivePO.getEffectiveCode() + "," + effectivePO.getBusinessTypeCode(), UocRu.js(effectivePO,UocRemainingTimeInfoBo.class));
                } else {
                    stringMap1.put(effectivePO.getEffectiveCode() + "," + effectivePO.getBusinessTypeCode(), UocRu.js(effectivePO,UocRemainingTimeInfoBo.class));
                }
            }
            UocRemainingTimeInfoBo effectivePO;
            long time = System.currentTimeMillis();
            for (Map.Entry<String, List<String>> stringEntry : stringMap.entrySet()) {
                String key = stringEntry.getKey();
                effectivePO = stringMap1.get(key);
                if (null == effectivePO) {
                    effectivePO = stringMap1.get(key.split("\\|")[1]);
                }
                for (String value : stringEntry.getValue()) {
                    UocRemainingTimeInfoBo remainingTimeInfoBo1 = reqBo.getRemainingTimeInfoBoMap().get(value);
                    if (null != remainingTimeInfoBo1 && null != effectivePO) {
                        remainingTimeInfoBo1.setAging(effectivePO.getAging());
                        remainingTimeInfoBo1.setTimeLeft(effectivePO.getAging() - time + remainingTimeInfoBo1.getCalculationTime().getTime());
                        reqBo.getRemainingTimeInfoBoMap().put(value, remainingTimeInfoBo1);
                    }
                }
            }
        }
    
        return rspBo;
    }
}
