package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.components.notice.UocNoticeProcessor;
import com.tydic.dyc.oc.components.notice.UocNoticeProcessorManager;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题:UocNoticeProcessServiceImpl
 * 说明:
 * 时间:2022/4/15 11:58
 * 作者:田桂银
 */
@HTServiceImpl
public class UocNoticeProcessServiceImpl implements UocNoticeProcessService {

    @Autowired
    private UocNoticeProcessorManager uocNoticeProcessorManager;

    @Override
    public UocNoticeProcessServiceRspBo processNotice(UocNoticeProcessServiceReqBo reqBo) {
        UocNoticeProcessServiceRspBo rspBo = UocRu.success(UocNoticeProcessServiceRspBo.class);
        UocNoticeProcessor instance = uocNoticeProcessorManager.getInstance(reqBo.getServiceCode());
        Map<String, Object> keyMap = reqBo.getBusiDataList().stream().collect(Collectors.toMap(UocNoticeProcessServiceReqBusiDataBo::getKey, UocNoticeProcessServiceReqBusiDataBo::getValue));
        rspBo.setReceiverCondition(JUtil.js(instance.qryCondition(keyMap), UocNoticeProcessServiceRspReceiverConditionBo.class));
        rspBo.setReplaceDataList(JUtil.jsl(instance.replaceContent(keyMap), UocNoticeProcessServiceRspReplaceDataBo.class));
        return rspBo;
    }
}


