package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryAfOrderShopAddressBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryAfOrderShopAddressReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryAfOrderShopAddressRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 描述：售后商家收件地址查询
 *
 * @author tkl
 * @date 2022/5/20 14:30
 **/
@HTServiceImpl
public class UocQryAfOrderShopAddressServiceImpl implements UocQryAfOrderShopAddressService {

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;

    @Override
    public UocQryAfOrderShopAddressRspBo qryAfOrderShopAddress(UocQryAfOrderShopAddressReqBo reqBo) {
        //入参校验
        validataArg(reqBo);
        UocQryAfOrderShopAddressRspBo rspBo = new UocQryAfOrderShopAddressRspBo();
        //查询售后单
        UocAfOrder afOrder = getAfOrder(reqBo);
        if (ObjectUtil.isNotNull(afOrder)) {
            //查询收获地址
            UocOrdLogisticsRela logisticsRela = getLogisticsRela(afOrder);
            if (ObjectUtil.isNotNull(logisticsRela)) {
                rspBo.setAddress(UocRu.js(logisticsRela, UocQryAfOrderShopAddressBo.class));
            }
        }
        return rspBo;
    }

    private UocOrdLogisticsRela getLogisticsRela(UocAfOrder afOrder) {
        UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
        relaQryBo.setOrderId(afOrder.getOrderId());
        relaQryBo.setContactId(afOrder.getContactId());
        UocOrdLogisticsRela logisticsRela = iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
        return logisticsRela;
    }

    private UocAfOrder getAfOrder(UocQryAfOrderShopAddressReqBo reqBo) {
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderQryBo.setOrderId(reqBo.getOrderId());
        return iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
    }

    /**
     * 入参校验
     *
     * @param reqBo
     */
    public void validataArg(UocQryAfOrderShopAddressReqBo reqBo) {
        if (ObjectUtil.isNull(reqBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }

        if (ObjectUtil.isEmpty(reqBo.getAfOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "售后商家收件地址查询失败：售后单ID[afOrderId]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "售后商家收件地址查询失败：订单ID[orderId]不能为空");
        }
    }
}
