package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryOrderCreateResultServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryOrderCreateResultServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryOrderCreateResultServiceRspProcessDataBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 标题:UocQryOrderCreateResultServiceImpl
 * 说明:
 * 时间:2022/2/27 14:59
 * 作者:田桂银
 */
@HTServiceImpl
public class UocQryOrderCreateResultServiceImpl implements UocQryOrderCreateResultService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Override
    public UocQryOrderCreateResultServiceRspBo qryOrderCreateResult(UocQryOrderCreateResultServiceReqBo reqBo) {
        validateArg(reqBo);
        UocQryOrderCreateResultServiceRspBo rspBo = UocRu.success(UocQryOrderCreateResultServiceRspBo.class);
        UocOrderDo qryOrderDo = new UocOrderDo();
        qryOrderDo.setOrderId(reqBo.getOrderId());
        UocOrderDo uocOrderDo = iUocOrderModel.qryOrderBy(qryOrderDo);
        if (ObjectUtil.isEmpty(uocOrderDo)) {
            return rspBo;
        }
        rspBo.setOrderId(reqBo.getOrderId());
        rspBo.setOrderNo(uocOrderDo.getOrderNo());
        rspBo.setTotalSaleFee(uocOrderDo.getTotalSaleFee());

        //是否处理成功
        boolean processResult = true;
        UocSaleOrderDo qrySaleDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        List<UocSaleOrderDo> uocSaleOrderDos = iUocSaleOrderModel.qrySaleOrderList(qrySaleDo);

        List<String> qryDicList = new ArrayList<>();
        qryDicList.add(UocDicConstant.PAY_TYPE.P_CODE);
        Map<String, Map<String, String>> dictionaryMap = iUocSysDictionaryModel.getDictionaryMap(qryDicList);


        for (UocSaleOrderDo uocSaleOrderDo : uocSaleOrderDos) {
            //销售单不为空，代表该销售单处理完成了
            // 下单结果不为成功则失败
            if (!UocConstant.CREATED_RESULT.SUCCESS.equals(uocSaleOrderDo.getCreatedResult())) {
                processResult = false;
            }
            //如果销售单取消原因不为空，或者状态为取消状态，说明消费者处理失败了（取消订单）。
            UocQryOrderCreateResultServiceRspProcessDataBo resultDataBo = new UocQryOrderCreateResultServiceRspProcessDataBo();
            if (ObjectUtil.isNotEmpty(uocSaleOrderDo.getCancelReason()) || UocStateConstants.SaleOrder.XS_QX_QX.equals(uocSaleOrderDo.getSaleOrderState())) {
                resultDataBo.setMsg(uocSaleOrderDo.getCancelReason());
                resultDataBo.setResultCode(3);
                resultDataBo.setResultDescription("失败");
//                rspBo.getFailedList().add(resultDataBo);
            } else {
                resultDataBo.setResultCode(1);
                resultDataBo.setResultDescription("成功");
//                rspBo.getSuccessList().add(resultDataBo);
            }

            //查询当前
            UocOrderTaskInst qryTask = new UocOrderTaskInst();
            qryTask.setOrderId(uocSaleOrderDo.getOrderId());
            qryTask.setObjId(uocSaleOrderDo.getSaleOrderId());
//            qryTask.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            qryTask.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(qryTask);

            //不为空，则需要审批
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                for (UocOrderTaskInst uocOrderTaskInst:uocOrderTaskInsts) {
                    //审批： 无协议：N0003  协议：A0006  电商：  E0002
                    List<String> auditList = Arrays.asList("N0003", "A0006","E0002");
                    if(auditList.contains(uocOrderTaskInst.getProcState())){
                        rspBo.getNeedApprovedOrders().add(resultDataBo);
                        break;
                    }
                    // 支付  无协议：N0004 N0005
                    List<String> payList = Arrays.asList("N0004", "N0005","A0007","A0008","E0004","E0005");
                    if(payList.contains(uocOrderTaskInst.getProcState())){
                        rspBo.getCanPayOrders().add(resultDataBo);
                        break;
                    }
                }

            }

            resultDataBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            resultDataBo.setSaleOrderNo(uocSaleOrderDo.getSaleOrderNo());
            resultDataBo.setSupNo(uocSaleOrderDo.getStakeholder().getSupId());
            resultDataBo.setSupName(uocSaleOrderDo.getStakeholder().getSupName());
            resultDataBo.setFee(uocSaleOrderDo.getTotalSaleFee());
            resultDataBo.setPayType(uocSaleOrderDo.getPayType());
            resultDataBo.setPayTypeName(dictionaryMap.get(UocDicConstant.PAY_TYPE.P_CODE) != null ? dictionaryMap.get(UocDicConstant.PAY_TYPE.P_CODE).get(uocSaleOrderDo.getPayType()) : "");
            resultDataBo.setOrderSource(uocSaleOrderDo.getOrderSource());
            resultDataBo.setSeller(uocSaleOrderDo.getStakeholder().getSupName());
        }
        rspBo.setProcessResult(processResult);
        return rspBo;
    }

    private void validateArg(UocQryOrderCreateResultServiceReqBo reqBo) {

        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocQryOrderCreateResultServiceReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【订单id】不能为空");
        }

    }
}


