package com.tydic.dyc.oc.components.event.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocEventConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 标题:EventConsumerCommonSyncSale
 * 说明:单据提交时解析参数
 * 时间:2022/3/10 20:10
 * 作者:罗有
 */
@Slf4j
@Component
public class EventConsumerOrderCommit implements EventConsumer {
    @Autowired
    private UocIndexConfig uocIndexConfig;

//    @Autowired
//    private IUocImplOrderModel iUocImplOrderModel;

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;


    @Autowired
    private IUocAfOrderModel uocAfOrderModel;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerOrderCommit->{}", JSON.toJSONString(map));

        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        Long orderId = UocRu.parseLong(map.get("orderId"));
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> nextTaskInfos = UocRu.jsl(map.get("nextTaskInfos"),UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo.class);
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> completeTaskInfos = UocRu.jsl(map.get("completeTaskInfos"),UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo.class);
        nextTaskInfos.addAll(completeTaskInfos);
        nextTaskInfos.forEach(taskBo->{
            Integer objType = taskBo.getBusiObjType();
            Long objId = taskBo.getBusiObjId();
            if (UocDicConstant.OBJ_TYPE.SALE.equals(objType)) {
                addSyncParam(retList, orderId, objId, uocIndexConfig.getSaleOrderIndex());
            }
            if (UocDicConstant.OBJ_TYPE.SHIP.equals(objType)) {
                UocShipOrderDo shipOrderDo = getShipOrderDo(orderId, objId);
                if (null != shipOrderDo) {
                    addSyncParam(retList, orderId, shipOrderDo.getSaleOrderId(), uocIndexConfig.getSaleOrderIndex());
                }
                addSyncParam(retList, orderId, objId, uocIndexConfig.getShipOrderIndex());
            }
            if (UocDicConstant.OBJ_TYPE.INSPECTION.equals(objType)) {
                UocInspOrderDo inspOrderMain = getInspOrderDo(orderId, objId);
                if (null != inspOrderMain) {
                    addSyncParam(retList, orderId, inspOrderMain.getSaleOrderId(), uocIndexConfig.getSaleOrderIndex());

                    if (!CollectionUtils.isEmpty(inspOrderMain.getUocShipInspRelList())) {
                        inspOrderMain.getUocShipInspRelList().forEach(uocShipInspRel -> {
                            if (null != uocShipInspRel.getShipOrderId()) {
                                addSyncParam(retList, orderId, uocShipInspRel.getShipOrderId(), uocIndexConfig.getShipOrderIndex());
                            }
                        });
                    }
                }
                addSyncParam(retList, orderId, objId, uocIndexConfig.getInspOrderIndex());
            }

            if (UocDicConstant.OBJ_TYPE.AFTER.equals(objType)) {
                addSyncParam(retList, orderId, objId, uocIndexConfig.getAfOrderIndex());
                //销售单
                UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
                uocAfOrderQryBo.setOrderId(orderId);
                uocAfOrderQryBo.setAfOrderId(objId);
                UocAfOrder afOrderById = uocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
                Long saleOrderId = afOrderById.getSaleOrderId();
                addSyncParam(retList, orderId, saleOrderId, uocIndexConfig.getSaleOrderIndex());
            }

            if (UocDicConstant.OBJ_TYPE.CHNG.equals(objType)) {
                //异常变更
                addSyncParam(retList, orderId, objId, uocIndexConfig.getChngOrderIndex());
            }
        });


        log.info("单据提交出参:{}", JSON.toJSONString(retList));
        return retList;
    }

//    private UocImplOrderDo getImplOrderDo(Long orderId, Long objId) {
//        UocImplOrderQryBo uocImplOrderQryBo = new UocImplOrderQryBo();
//        uocImplOrderQryBo.setOrderId(orderId);
//        uocImplOrderQryBo.setImplOrderId(objId);
//        return iUocImplOrderModel.getImplOrderMain(uocImplOrderQryBo);
//    }

    private UocShipOrderDo getShipOrderDo(Long orderId, Long objId) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(orderId);
        uocShipOrderQryBo.setShipOrderId(objId);
        return iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
    }

    private void addSyncParam(List<IUocEsSyncQryEventReqBo> retList, Long orderId, Long objId, String indexName) {
        IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
        syncQryReqBo.setObjId(objId);
        syncQryReqBo.setOrderId(orderId);
        addEvent(retList, syncQryReqBo, indexName);
    }

    private UocInspOrderDo getInspOrderDo(Long orderId, Long objId) {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setOrderId(orderId);
        uocInspOrderQryBo.setInspOrderId(objId);
        return iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
    }

    private void addEvent(List<IUocEsSyncQryEventReqBo> retList, IUocEsSyncQryReqBo syncQryReqBo, String index) {
        List<IUocEsSyncQryReqBo> esSyncQryReqBoList = new ArrayList<>();
        esSyncQryReqBoList.add(syncQryReqBo);
        IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
        eventReqBo.setIndexName(index);
        eventReqBo.setDataList(esSyncQryReqBoList);
        retList.add(eventReqBo);
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOCE_ORDER_COMMIT_SYNC;
    }
}


