package com.tydic.dyc.oc.model.order.sub;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocOrderTaskInst
 * 说明:订单任务实例
 * 时间:2022-02-21 19:10
 * 作者:罗有
 **/
@Data
public class UocOrderTaskInst implements Serializable {
	private static final long serialVersionUID = 3249178701210943771L;

	@DocField(value = "id")
	private Long id;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "任务实例id")
	private String taskInstId;

	@DocField(value = "流程实例id")
	private String procInstId;

	@DocField(value = "流程key定义")
	private String procDefId;

	@DocField(value = "单据id")
	private Long objId;

	@DocField(value = "单据类型:1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单     99.其他")
	private Integer objType;

	@DocField("所在环节")
	private String procState;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "完结标志0未完结1已完结")
	private Integer finishTag;

	@DocField(value = "完成时间")
	private Date finishTime;

	@DocField(value = "表单")
	private String formUrl;
	@DocField(value = "删除标志1已删除")
	private Integer delTag;

	@DocField(value = "ids")
	private List<Long> ids;

	@DocField(value = "加签标识 0 ：环节任务   1：前加签任务  2：后加签任务  3：存在后加签任务")
	private Integer taskSignTag;


}
