package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocEventConstant;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderReqShipBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateReqShipBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 标题:EventConsumerCommonSyncSale
 * 说明:解释变更单通用
 * 时间:2022/3/10 20:10
 * 作者:罗有
 */
@Component
@Slf4j
public class EventConsumerCommonSyncChng implements EventConsumer {
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerCommonSyncChng->{}", JSON.toJSONString(map));
        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        Long orderId = UocRu.parseLong(map.get("orderId"));
        Long chngOrderId = UocRu.parseLong(map.get("chngOrderId"));
        Object objList = map.get("shipOrderIdList");
        Object inspListObj = map.get("inspOrderIdList");
        Long saleOrderId = UocRu.parseLong(map.get("saleOrderId"));
        if (ObjectUtil.isNotNull(objList)) {
            List<Long> shipOrderList = UocRu.jsl(objList, Long.class);
            List<IUocEsSyncQryReqBo> shipList = new ArrayList<>();
            shipOrderList.forEach(x -> {
                IUocEsSyncQryReqBo ship = new IUocEsSyncQryReqBo();
                ship.setOrderId(orderId);
                ship.setObjId(x);
                shipList.add(ship);
            });
            IUocEsSyncQryEventReqBo shipEvent = new IUocEsSyncQryEventReqBo();
            shipEvent.setIndexName(uocIndexConfig.getShipOrderIndex());
            shipEvent.setDataList(shipList);
            retList.add(shipEvent);
        }

        if (ObjectUtil.isNotNull(inspListObj)) {
            List<Long> inspList = UocRu.jsl(inspListObj, Long.class);
            List<IUocEsSyncQryReqBo> inspqryList = new ArrayList<>();
            inspList.forEach(x -> {
                IUocEsSyncQryReqBo ship = new IUocEsSyncQryReqBo();
                ship.setOrderId(orderId);
                ship.setObjId(x);
                inspqryList.add(ship);
            });
            IUocEsSyncQryEventReqBo shipEvent = new IUocEsSyncQryEventReqBo();
            shipEvent.setIndexName(uocIndexConfig.getInspOrderIndex());
            shipEvent.setDataList(inspqryList);
            retList.add(shipEvent);
        }

        if (ObjectUtil.isNotEmpty(saleOrderId)) {
            List<IUocEsSyncQryReqBo> saleList = new ArrayList<>();
            IUocEsSyncQryReqBo saleOrder = new IUocEsSyncQryReqBo();
            saleOrder.setOrderId(orderId);
            saleOrder.setObjId(saleOrderId);
            saleList.add(saleOrder);
            IUocEsSyncQryEventReqBo inspEvent = new IUocEsSyncQryEventReqBo();
            inspEvent.setIndexName(uocIndexConfig.getSaleOrderIndex());
            inspEvent.setDataList(saleList);
            retList.add(inspEvent);
        }
        IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
        syncQryReqBo.setOrderId(orderId);
        syncQryReqBo.setObjId(chngOrderId);
        List<IUocEsSyncQryReqBo> saleList = new ArrayList<>();
        saleList.add(syncQryReqBo);
        IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
        eventReqBo.setIndexName(uocIndexConfig.getChngOrderIndex());
        eventReqBo.setDataList(saleList);
        retList.add(eventReqBo);
        return retList;
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOCE_ES_SYNC_CHNG_ORDER;
    }
}


