/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventConsumerCommonSyncChng
implements EventConsumer {
    private static final Logger log = LoggerFactory.getLogger(EventConsumerCommonSyncChng.class);
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        IUocEsSyncQryEventReqBo shipEvent;
        log.info("event-EventConsumerCommonSyncChng->{}", (Object)JSON.toJSONString(map));
        ArrayList<IUocEsSyncQryEventReqBo> retList = new ArrayList<IUocEsSyncQryEventReqBo>();
        Long orderId = UocRu.parseLong(map.get("orderId"));
        Long chngOrderId = UocRu.parseLong(map.get("chngOrderId"));
        Object objList = map.get("shipOrderIdList");
        Object inspListObj = map.get("inspOrderIdList");
        Long saleOrderId = UocRu.parseLong(map.get("saleOrderId"));
        if (ObjectUtil.isNotNull((Object)objList)) {
            List<Long> shipOrderList = UocRu.jsl(objList, Long.class);
            ArrayList<IUocEsSyncQryReqBo> shipList = new ArrayList<IUocEsSyncQryReqBo>();
            shipOrderList.forEach(x -> {
                IUocEsSyncQryReqBo ship = new IUocEsSyncQryReqBo();
                ship.setOrderId(orderId);
                ship.setObjId((Long)x);
                shipList.add(ship);
            });
            shipEvent = new IUocEsSyncQryEventReqBo();
            shipEvent.setIndexName(this.uocIndexConfig.getShipOrderIndex());
            shipEvent.setDataList(shipList);
            retList.add(shipEvent);
        }
        if (ObjectUtil.isNotNull((Object)inspListObj)) {
            List<Long> inspList = UocRu.jsl(inspListObj, Long.class);
            ArrayList<IUocEsSyncQryReqBo> inspqryList = new ArrayList<IUocEsSyncQryReqBo>();
            inspList.forEach(x -> {
                IUocEsSyncQryReqBo ship = new IUocEsSyncQryReqBo();
                ship.setOrderId(orderId);
                ship.setObjId((Long)x);
                inspqryList.add(ship);
            });
            shipEvent = new IUocEsSyncQryEventReqBo();
            shipEvent.setIndexName(this.uocIndexConfig.getInspOrderIndex());
            shipEvent.setDataList(inspqryList);
            retList.add(shipEvent);
        }
        if (ObjectUtil.isNotEmpty((Object)saleOrderId)) {
            ArrayList<IUocEsSyncQryReqBo> saleList = new ArrayList<IUocEsSyncQryReqBo>();
            IUocEsSyncQryReqBo saleOrder = new IUocEsSyncQryReqBo();
            saleOrder.setOrderId(orderId);
            saleOrder.setObjId(saleOrderId);
            saleList.add(saleOrder);
            IUocEsSyncQryEventReqBo inspEvent = new IUocEsSyncQryEventReqBo();
            inspEvent.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
            inspEvent.setDataList(saleList);
            retList.add(inspEvent);
        }
        IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
        syncQryReqBo.setOrderId(orderId);
        syncQryReqBo.setObjId(chngOrderId);
        ArrayList<IUocEsSyncQryReqBo> saleList = new ArrayList<IUocEsSyncQryReqBo>();
        saleList.add(syncQryReqBo);
        IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
        eventReqBo.setIndexName(this.uocIndexConfig.getChngOrderIndex());
        eventReqBo.setDataList(saleList);
        retList.add(eventReqBo);
        return retList;
    }

    @Override
    public String getEvent() {
        return "UOCE_ES_SYNC_CHNG_ORDER";
    }
}

