/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.model.saleorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleItemMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleStakeholderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.repository.UocAgreementOrderRepository;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.UocSaleOrderRepository;
import com.tydic.dyc.oc.utils.IdUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocSaleOrderModelImpl
implements IUocSaleOrderModel {
    private static final Logger log = LoggerFactory.getLogger(UocSaleOrderModelImpl.class);
    @Autowired
    private UocSaleOrderRepository uocSaleOrderRepository;
    @Autowired
    private UocCommonRepository uocCommonRepository;
    @Autowired
    private UocAgreementOrderRepository uocAgreementOrderRepository;

    @Override
    public UocSaleOrderDo createSaleOrder(UocSaleOrderDo saleOrderDo) {
        List<UocOrderAccessory> list;
        List<UocSaleOrderPayConf> saleOrderPayConfList;
        this.validateCreateArg(saleOrderDo);
        saleOrderDo.setSaleOrderNo(this.genRequestCode(saleOrderDo));
        saleOrderDo.setSaleOrderId(IdUtil.nextId());
        saleOrderDo.setCreateTime(new Date());
        saleOrderDo.setSaleOrderState(null);
        List<UocSaleOrderMap> saleOrderMapList = saleOrderDo.getSaleOrderMapList();
        if (ObjectUtil.isNotEmpty(saleOrderMapList)) {
            for (UocSaleOrderMap uocSaleOrderMap : saleOrderMapList) {
                uocSaleOrderMap.setId(IdUtil.nextId());
                uocSaleOrderMap.setSaleOrderId(saleOrderDo.getSaleOrderId());
                uocSaleOrderMap.setCreateOperId(saleOrderDo.getCreateOperId());
                uocSaleOrderMap.setCreateTime(saleOrderDo.getCreateTime());
            }
        }
        if (ObjectUtil.isNotEmpty(saleOrderPayConfList = saleOrderDo.getSaleOrderPayConfList())) {
            for (UocSaleOrderPayConf payConf : saleOrderPayConfList) {
                payConf.setId(IdUtil.nextId());
                payConf.setOrderId(saleOrderDo.getOrderId());
                payConf.setCreateTime(saleOrderDo.getCreateTime());
                payConf.setCreateOperId(saleOrderDo.getCreateOperId());
                payConf.setSaleOrderId(saleOrderDo.getSaleOrderId());
                if (!UocDicConstant.PAY_CONF_USE_TYPE.PUR.equals(payConf.getUserType())) continue;
                saleOrderDo.setPayType(payConf.getPayType() != null ? payConf.getPayType().toString() : null);
            }
        }
        if (ObjectUtil.isNotEmpty(list = saleOrderDo.getSaleOrderAccessoryList())) {
            for (UocOrderAccessory accessory : list) {
                accessory.setId(IdUtil.nextId());
                accessory.setObjId(saleOrderDo.getSaleOrderId());
                accessory.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                accessory.setOrderId(saleOrderDo.getOrderId());
                accessory.setCreateTime(saleOrderDo.getCreateTime());
                accessory.setCreateOperId(saleOrderDo.getCreateOperId());
            }
        }
        this.setSaleItems(saleOrderDo);
        return this.uocSaleOrderRepository.createSaleOrder(saleOrderDo);
    }

    private void validateCreateArg(UocSaleOrderDo saleOrderDo) {
        if (ObjectUtil.isEmpty((Object)saleOrderDo)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void setSaleItems(UocSaleOrderDo saleOrderDo) {
        List<UocSaleOrderItem> saleOrderItems = saleOrderDo.getSaleOrderItems();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            saleOrderItem.setOrderId(saleOrderDo.getOrderId());
            saleOrderItem.setSaleOrderItemId(IdUtil.nextId());
            saleOrderItem.setSaleOrderId(saleOrderDo.getSaleOrderId());
            saleOrderItem.setCreateOperId(saleOrderDo.getCreateOperId());
            saleOrderItem.setCreateTime(saleOrderDo.getCreateTime());
            List<UocSaleItemMap> saleItemMapList = saleOrderItem.getSaleItemMapList();
            if (!ObjectUtil.isNotEmpty(saleItemMapList)) continue;
            for (UocSaleItemMap uocSaleItemMap : saleItemMapList) {
                uocSaleItemMap.setId(IdUtil.nextId());
                uocSaleItemMap.setSaleOrderItemId(saleOrderItem.getOrderItemId());
                uocSaleItemMap.setSaleOrderId(saleOrderDo.getSaleOrderId());
                uocSaleItemMap.setOrderId(saleOrderDo.getOrderId());
                uocSaleItemMap.setCreateTime(saleOrderDo.getCreateTime());
                uocSaleItemMap.setCreateOperId(saleOrderDo.getCreateOperId());
            }
        }
    }

    @Override
    public List<UocSaleOrderItem> getSaleOrderItemList(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        if (null == uocSaleOrderItemQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    @Override
    public List<UocSaleOrderItem> getSaleOrderItemListByItemIds(List<Long> itemIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemIds)) {
            throw new BaseBusinessException("102001", "\u9500\u552e\u5355\u660e\u7ec6id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderItemListByItemIds(itemIds);
    }

    @Override
    public List<UocSaleItemMap> getSaleOrderItemMapList(UocSaleItemMapQryBo uocSaleItemMapQryBo) {
        if (null == uocSaleItemMapQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderItemMapList(uocSaleItemMapQryBo);
    }

    @Override
    public UocSaleOrderDo qrySaleOrder(UocSaleOrderQryBo uocSaleOrderQryBo) {
        if (null == uocSaleOrderQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.qrySaleOrder(uocSaleOrderQryBo);
    }

    @Override
    public UocSaleOrderDo getSaleOrderAccessoryList(UocOrderAccessoryQryBo uocOrderAccessoryQryBo) {
        if (null == uocOrderAccessoryQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderAccessoryList(uocOrderAccessoryQryBo);
    }

    @Override
    public List<UocSaleOrderPayConf> getSaleOrderPayConfList(UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo) {
        return this.uocSaleOrderRepository.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
    }

    @Override
    public List<UocSaleOrderMap> getSaleOrderExpandList(UocSaleOrderMapQryBo uocSaleOrderMapQryBo) {
        if (null == uocSaleOrderMapQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderExpandList(uocSaleOrderMapQryBo);
    }

    @Override
    public UocSaleOrderDo qryListSaleOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        return this.uocSaleOrderRepository.qryListSaleOrderItem(uocSaleOrderItemQryBo);
    }

    @Override
    public void modifySaleOrderMain(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderDo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo);
    }

    @Override
    public UocSaleOrderDo updateSaleStatusAndProCode(UocSaleOrderDo reqBo) {
        this.validateUpdateSaleOrderArg(reqBo);
        UocSaleOrderQryBo qryBo = new UocSaleOrderQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.qrySaleOrder(qryBo);
        if (ObjectUtil.isEmpty((Object)uocSaleOrderDo)) {
            throw new BaseBusinessException("102001", "\u8be5\u9500\u552e\u5355" + reqBo.getSaleOrderId() + "\u4e0d\u5b58\u5728");
        }
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(reqBo.getSaleOrderId());
        uocOrderStateChgLog.setOrderId(reqBo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderStateChgLog.setOldState(uocSaleOrderDo.getSaleOrderState());
        uocOrderStateChgLog.setNewState(reqBo.getSaleOrderState());
        uocOrderStateChgLog.setChgTime(new Date());
        uocOrderStateChgLog.setOperId(reqBo.getUpdateOperId());
        this.uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);
        return this.uocSaleOrderRepository.updateSaleStatusAndProCode(reqBo);
    }

    private void validateUpdateSaleOrderArg(UocSaleOrderDo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocUpdateSaleOrderStateServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUpdateOperId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u66f4\u65b0\u4ebaid\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u8ba2\u5355id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u9500\u552e\u5355id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderState())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u9500\u552e\u5355\u72b6\u6001\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public void updateProcTaskInstToFinished(List<UocOrderTaskInst> uocOrderTaskInstList) {
        this.uocCommonRepository.updateToFinished(uocOrderTaskInstList);
    }

    @Override
    public void saveProcTaskInst(List<UocOrderTaskInst> saveTaskList) {
        Date createTime = new Date();
        if (ObjectUtil.isNotEmpty(saveTaskList)) {
            for (UocOrderTaskInst uocOrderTaskInst : saveTaskList) {
                uocOrderTaskInst.setCreateTime(createTime);
            }
            this.uocCommonRepository.saveProcTaskInst(saveTaskList);
        }
    }

    @Override
    public List<UocSaleOrderDo> qrySaleOrderList(UocSaleOrderDo qryDo) {
        if (null == qryDo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.qrySaleOrderList(qryDo);
    }

    @Override
    public UocOrderProcInst createProInst(UocOrderProcInst inst) {
        inst.setId(IdUtil.nextId());
        inst.setCreateTime(new Date());
        return this.uocCommonRepository.createProInst(inst);
    }

    @Override
    public List<UocOrderProcInst> qryProcInsList(UocOrderProcInst inst) {
        return this.uocCommonRepository.qryProcInsList(inst);
    }

    @Override
    public List<UocOrderTaskInst> qryTaskInstList(UocOrderTaskInst taskInst) {
        return this.uocCommonRepository.qryTaskInstList(taskInst);
    }

    @Override
    public void saveOrderTaskDealList(List<UocOrderTaskDeal> dealList) {
        this.uocCommonRepository.saveOrderTaskDealList(dealList);
    }

    @Override
    public UocSaleOrderDo getSaleOrderMain(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getSaleOrderMain(uocSaleOrderDo);
    }

    @Override
    public List<UocSaleStakeholder> qrySaleOrderStakeholder(UocSaleStakeholderQryBo qryBo) {
        return this.uocSaleOrderRepository.qrySaleOrderStakeholder(qryBo);
    }

    private String genRequestCode(UocSaleOrderDo saleOrderDo) {
        return this.uocCommonRepository.getOrderNoSingle("SALE_ORDER_NO_" + saleOrderDo.getOrderSource());
    }

    @Override
    public void addSaleOrderMap(UocSaleOrderDo uocSaleOrderDo) {
        this.valDo(uocSaleOrderDo);
        this.uocSaleOrderRepository.addShipOrderMap(uocSaleOrderDo);
    }

    @Override
    public void updateBatchValue(UocSaleOrderDo uocSaleOrderDo) {
        this.valDo(uocSaleOrderDo);
        this.uocSaleOrderRepository.updateBatchValue(uocSaleOrderDo);
    }

    @Override
    public void updateInvalid(UocSaleOrderDo uocSaleOrderDo) {
        this.valDo(uocSaleOrderDo);
        this.uocSaleOrderRepository.updateInvalid(uocSaleOrderDo);
    }

    @Override
    public UocOrderAgreement getAgreementOrderBy(UocOrderAgreementQryBo uocOrderAgreementQryBo) {
        if (ObjectUtil.isNull((Object)uocOrderAgreementQryBo)) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocAgreementOrderRepository.getAgreementOrderBy(uocOrderAgreementQryBo);
    }

    @Override
    public List<UocOrderAgreement> getAgreementOrderList(UocOrderAgreementQryBo uocOrderAgreementQryBo) {
        if (ObjectUtil.isNull((Object)uocOrderAgreementQryBo)) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocAgreementOrderRepository.getAgreementOrderList(uocOrderAgreementQryBo);
    }

    @Override
    public UocSaleOrderDo qryTotalFeeAndCount(UocSaleOrderQryBo uocSaleOrderQryBo) {
        if (ObjectUtil.isNull((Object)((Object)uocSaleOrderQryBo))) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.qryTotalFeeAndCount(uocSaleOrderQryBo);
    }

    @Override
    public UocSaleOrderDo getListSaleOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        if (ObjectUtil.isNull((Object)((Object)uocSaleOrderItemQryBo))) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getListSaleOrderItem(uocSaleOrderItemQryBo);
    }

    @Override
    public void modifyBatchItemSendCount(UocSaleOrderDo convertSaleOrderDo) {
        this.valDo(convertSaleOrderDo);
        if (null == convertSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(convertSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        convertSaleOrderDo.getSaleOrderItems().forEach(uocImplOrderItem -> {
            if (null == uocImplOrderItem.getSaleOrderItemId()) {
                throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == uocImplOrderItem.getSendCount()) {
                throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u53d1\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        this.uocSaleOrderRepository.modifyBatchItemSendCount(convertSaleOrderDo);
    }

    @Override
    public UocSaleOrderDo getCollectCountImplOrderItem(UocSaleOrderItemQryBo uocSaleOrderItemQryBo) {
        if (null == uocSaleOrderItemQryBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderItemQryBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderItemQryBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocSaleOrderRepository.getCollectCount(uocSaleOrderItemQryBo);
    }

    @Override
    public void modifyBatchItemInspCount(UocSaleOrderDo uocSaleOrderDo) {
        this.valDo(uocSaleOrderDo);
        if (null == uocSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        uocSaleOrderDo.getSaleOrderItems().forEach(uocSaleOrderItem -> {
            if (null == uocSaleOrderItem.getSaleOrderItemId()) {
                throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == uocSaleOrderItem.getAcceptanceCount()) {
                throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        this.uocSaleOrderRepository.modifyBatchItemInspCount(uocSaleOrderDo);
    }

    @Override
    public void modifySaleOrderStakeholder(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo.getStakeholder()) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u4e09\u65b9\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (uocSaleOrderDo.getStakeholder().getOrderId() == null) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocSaleOrderRepository.modifySaleOrderStakeholder(uocSaleOrderDo);
    }

    @Override
    public void modifySalePrice(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.modifyBatchItemSalePrice(uocSaleOrderDo);
        UocSaleOrderDo uocSaleOrderDo2 = new UocSaleOrderDo();
        uocSaleOrderDo2.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderDo2.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo4 = this.uocSaleOrderRepository.getSaleItemTotalPrice(uocSaleOrderDo2);
        UocSaleOrderDo uocSaleOrderDo3 = new UocSaleOrderDo();
        uocSaleOrderDo3.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderDo3.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        uocSaleOrderDo3.setTotalSaleFee(uocSaleOrderDo4.getTotalSaleFee());
        uocSaleOrderDo3.setUpdateOperId(uocSaleOrderDo.getUpdateOperId());
        uocSaleOrderDo3.setUpdateTime(uocSaleOrderDo.getUpdateTime());
        this.uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo3);
    }

    @Override
    public void modifySaleOrderItemReturningCount(UocSaleOrderItem uocSaleOrderItem) {
        this.valSaleItem(uocSaleOrderItem);
        this.uocSaleOrderRepository.modifySaleOrderItemReturningCount(uocSaleOrderItem);
    }

    @Override
    public void modifyBatchItemChngingCount(UocSaleOrderDo convertImplOrderDo) {
        this.uocSaleOrderRepository.modifyBatchItemChngingCount(convertImplOrderDo);
    }

    @Override
    public void modifyBatchItemChngCountRefuse(UocSaleOrderDo convertSaleOrderDo) {
        if (null == convertSaleOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(convertSaleOrderDo.getOrderIdList())) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(convertSaleOrderDo.getSaleOrderItemsIdList())) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocSaleOrderRepository.modifyBatchItemChngCountRefuse(convertSaleOrderDo);
    }

    @Override
    public void modifyBatchItemReturnCountConfirm(UocSaleOrderDo convertSaleOrderDo) {
        if (null == convertSaleOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(convertSaleOrderDo.getOrderIdList())) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(convertSaleOrderDo.getSaleOrderItemsIdList())) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocSaleOrderRepository.modifyBatchItemReturnCountConfirm(convertSaleOrderDo);
    }

    @Override
    public void modifySaleOrderItemInspCountEqualArrivalCount(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.modifySaleOrderItemInspCountEqualArrivalCount(uocSaleOrderDo);
    }

    private void valSaleItem(UocSaleOrderItem uocSaleOrderItem) {
        if (null == uocSaleOrderItem) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)uocSaleOrderItem.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)uocSaleOrderItem.getSaleOrderItemId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void valDo(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderDo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public void deleteSaleOrder(UocSaleOrderDo saleOrderDo) {
        this.deleteSaleOrderValDo(saleOrderDo);
        this.uocSaleOrderRepository.deleteSaleOrder(saleOrderDo);
    }

    @Override
    public void updateProcInst(UocOrderProcInst uocOrderProcInst) {
        this.uocCommonRepository.updateProInst(uocOrderProcInst);
    }

    @Override
    public void updateTaskInst(UocOrderTaskInst uocOrderTaskInst) {
        this.uocCommonRepository.updateTaskInst(uocOrderTaskInst);
    }

    private void deleteSaleOrderValDo(UocSaleOrderDo uocSaleOrderDo) {
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderDo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocSaleOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public void modifySaleOrderItemAfterServingCount(UocSaleOrderItem uocSaleOrderItem) {
        this.uocSaleOrderRepository.modifySaleOrderItemAfterServingCount(uocSaleOrderItem);
    }

    @Override
    public void modifyInspSuper(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.modifyInspSuper(uocSaleOrderDo);
    }

    @Override
    public void modifyItemRefuseCountConfirm(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.modifyItemRefuseCountConfirm(uocSaleOrderDo);
    }

    @Override
    public void modifyItemArriveCountConfirm(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.modifyItemArriveCountConfirm(uocSaleOrderDo);
    }

    @Override
    public void updateSaleItemWithOutSkuId(UocSaleOrderDo uocSaleOrderDo) {
        this.validateUpdateSaleItemWithOutSkuId(uocSaleOrderDo);
        this.uocSaleOrderRepository.updateItem(uocSaleOrderDo);
    }

    @Override
    public void updateSaleItemArriveAccount(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.updateItemArriveAccount(uocSaleOrderDo);
    }

    @Override
    public void modifyPurchasePrice(UocSaleOrderDo uocSaleOrderDo) {
        this.uocSaleOrderRepository.modifyBatchItemPurchasePrice(uocSaleOrderDo);
        UocSaleOrderDo uocSaleOrderDo2 = new UocSaleOrderDo();
        uocSaleOrderDo2.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderDo2.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo4 = this.uocSaleOrderRepository.getSaleItemTotalPrice(uocSaleOrderDo2);
        UocSaleOrderDo uocSaleOrderDo3 = new UocSaleOrderDo();
        uocSaleOrderDo3.setOrderId(uocSaleOrderDo.getOrderId());
        uocSaleOrderDo3.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        uocSaleOrderDo3.setTotalPurchaseFee(uocSaleOrderDo4.getTotalPurchaseFee());
        uocSaleOrderDo3.setUpdateOperId(uocSaleOrderDo.getUpdateOperId());
        uocSaleOrderDo3.setUpdateTime(uocSaleOrderDo.getUpdateTime());
        this.uocSaleOrderRepository.modifySaleOrderMain(uocSaleOrderDo3);
    }

    private void validateUpdateSaleItemWithOutSkuId(UocSaleOrderDo uocSaleOrderDo) {
        if (uocSaleOrderDo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)uocSaleOrderDo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)uocSaleOrderDo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9500\u552e\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<UocSaleOrderItem> saleOrderItems = uocSaleOrderDo.getSaleOrderItems();
        if (ObjectUtil.isEmpty(saleOrderItems)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[saleOrderItems]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            if (saleOrderItem == null) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[saleOrderItem]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getSaleOrderId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[SaleOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getOrderId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[SaleOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getSkuExtSkuId())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[SkuExtSkuId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getNakedPrice())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[NakedPrice]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)saleOrderItem.getTax())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[Tax]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtil.isEmpty((Object)saleOrderItem.getTaxPrice())) continue;
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[TaxPrice]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public void modifyItemChngCountRefuse(UocSaleOrderDo convertSaleOrderDo) {
        this.uocSaleOrderRepository.modifyItemChngCountRefuse(convertSaleOrderDo);
    }

    @Override
    public void modifyItemChngCountConfirm(UocSaleOrderDo convertSaleOrderDo) {
        this.uocSaleOrderRepository.modifyItemChngCountConfirm(convertSaleOrderDo);
    }
}

