package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocCancelApplySaleOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelApplySaleOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelApplySaleOrderRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocCancelApplySaleOrderServiceImpl
 * 说明:销售单取消申请
 * 时间:2022/2/25 10:57
 * 作者:罗有
 */

@HTServiceImpl
public class UocCancelApplySaleOrderServiceImpl implements UocCancelApplySaleOrderService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @Override
    public UocCancelApplySaleOrderRspBo cancelApplySaleOrder(UocCancelApplySaleOrderReqBo reqBo) {

        //参数校验
        validateArg(reqBo);
        Date now = new Date();
        UocSaleOrderDo uocSaleOrderDo = getUocSaleOrderDo(reqBo);
        UocChngOrderDo uocChngOrderDo = convertChngOrderDo(reqBo, now, uocSaleOrderDo);
        iUocChngOrderModel.createChngOrder(uocChngOrderDo);
        iUocSaleOrderModel.modifySaleOrderMain(convertSaleOrderDo(reqBo, now));
        //保存附件
//        if (ObjectUtil.isNotEmpty(reqBo.getAccessoryAddBoList())) {
//            iUocOrderModel.createOrderAccessory(convertSaleOrderAccessory(reqBo, now));
//        }
        dealMap(reqBo, now);
        UocCancelApplySaleOrderRspBo uocCancelApplySaleOrderRspBo = UocRu.success(UocCancelApplySaleOrderRspBo.class);
        uocCancelApplySaleOrderRspBo.setChngOrderId(uocChngOrderDo.getChngOrderId());
        return uocCancelApplySaleOrderRspBo;
    }

    private UocChngOrderDo convertChngOrderDo(UocCancelApplySaleOrderReqBo reqBo, Date now, UocSaleOrderDo uocSaleOrderDo) {
        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        uocChngOrderDo.setOrderId(reqBo.getOrderId());
        uocChngOrderDo.setChngOrderId(IdUtil.nextId());
        uocChngOrderDo.setChngOrderNo(getChngOrderNo(uocSaleOrderDo));
        uocChngOrderDo.setChngOrderState(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.CHNG_XS_QXSQZ);
        uocChngOrderDo.setCancelReason(reqBo.getCancelReason());
        uocChngOrderDo.setCancelOperId(reqBo.getUserId().toString());
        uocChngOrderDo.setCancelOperName(reqBo.getName());
        uocChngOrderDo.setCancelTime(now);
        uocChngOrderDo.setCreateOperId(reqBo.getUserId().toString());
        uocChngOrderDo.setCreateOperName(reqBo.getName());
        uocChngOrderDo.setCreateOperMobile(reqBo.getCellphone());
        uocChngOrderDo.setCreateTime(now);
        uocChngOrderDo.setBusiType(UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL);
        uocChngOrderDo.setTenantId(reqBo.getTenantId());
        List<UocChngOrderObj> uocChngOrderObjList = new ArrayList<>();
        UocChngOrderObj uocChngOrderObj = new UocChngOrderObj();
        uocChngOrderObj.setOrderId(reqBo.getOrderId());
        uocChngOrderObj.setChngOrderObjId(IdUtil.nextId());
        uocChngOrderObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
        uocChngOrderObj.setChngType(UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL);
        uocChngOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
        uocChngOrderObj.setCreateTime(now);
        uocChngOrderObj.setCreateOperId(reqBo.getUserId().toString());
        uocChngOrderObj.setOtherChngValue(uocSaleOrderDo.getSaleOrderState());
        List<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<>();
        List<UocSaleOrderItem> saleOrderItemList = getSaleOrderItemList(reqBo);
        saleOrderItemList.forEach(uocSaleOrderItem -> {
            UocChngOrderItemObj uocChngOrderItemObj = new UocChngOrderItemObj();
            uocChngOrderItemObj.setSaleOrderItemId(uocSaleOrderItem.getSaleOrderItemId());
            uocChngOrderItemObj.setId(IdUtil.nextId());
            uocChngOrderItemObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
            uocChngOrderItemObj.setChngOrderObjId(uocChngOrderObj.getChngOrderObjId());
            uocChngOrderItemObj.setOrderId(reqBo.getOrderId());
            uocChngOrderItemObj.setCreateTime(now);
            uocChngOrderItemObj.setCreateOperId(reqBo.getUserId().toString());
            uocChngOrderItemObjList.add(uocChngOrderItemObj);
        });
        uocChngOrderObj.setUocChngOrderItemObjList(uocChngOrderItemObjList);
        uocChngOrderObjList.add(uocChngOrderObj);
        uocChngOrderDo.setUocChngOrderObjList(uocChngOrderObjList);
        if (!CollectionUtils.isEmpty(reqBo.getAccessoryAddBoList())) {
            List<UocOrderAccessory> orderAccessoryBoList = UocRu.jsl(reqBo.getAccessoryAddBoList(), UocOrderAccessory.class);
            orderAccessoryBoList.forEach(uocOrderAccessory -> {
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setObjId(uocChngOrderDo.getChngOrderId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setCreateTime(now);
            });
            uocChngOrderDo.setOrderAccessoryBoList(orderAccessoryBoList);
        }
        return uocChngOrderDo;
    }

    private List<UocSaleOrderItem> getSaleOrderItemList(UocCancelApplySaleOrderReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (CollectionUtils.isEmpty(saleOrderItemList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CANCEL_APPLY_ERROR, "查询销售单明细为空");
        }
        return saleOrderItemList;
    }


    private String getChngOrderNo(UocSaleOrderDo uocSaleOrderDo) {
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setBusiType(UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL);
        uocChngOrderQryBo.setOrderSource(uocSaleOrderDo.getOrderSource());
        UocChngOrderDo uocChngOrderDo = iUocChngOrderModel.getChngOrderNo(uocChngOrderQryBo);
        return uocChngOrderDo.getChngOrderNo();
    }

    private UocSaleOrderDo getUocSaleOrderDo(UocCancelApplySaleOrderReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CANCEL_APPLY_ERROR, "查询验收单为空");
        }
        return uocSaleOrderDo;
    }

    private List<UocOrderAccessory> convertSaleOrderAccessory(UocCancelApplySaleOrderReqBo reqBo, Date now) {
        List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getAccessoryAddBoList(), UocOrderAccessory.class);
        uocOrderAccessoryList.forEach(each -> {
            each.setId(IdUtil.nextId());
            each.setObjId(reqBo.getSaleOrderId());
            each.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            each.setOrderId(reqBo.getOrderId());
            each.setCreateTime(now);
            each.setCreateOperId(reqBo.getUserId().toString());
        });
        return uocOrderAccessoryList;
    }

    private UocSaleOrderDo convertSaleOrderDo(UocCancelApplySaleOrderReqBo reqBo, Date now) {
        UocSaleOrderDo uocSaleOrderDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocSaleOrderDo.setCancelOperId(reqBo.getUserId().toString());
        uocSaleOrderDo.setCancelRequestTime(now);
        uocSaleOrderDo.setCancelReason(reqBo.getCancelReason());
        uocSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_QX_QXSQ);
        return uocSaleOrderDo;
    }


    /**
     * 扩展属性处理
     */
    private void dealMap(UocCancelApplySaleOrderReqBo reqBo, Date now) {
        if (!CollectionUtils.isEmpty(reqBo.getExtDeleteList())) {
            UocChngOrderDo delChngOrderDo = new UocChngOrderDo();
            List<UocChngOrderMap> extParallelBoList = new ArrayList<>();
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                UocChngOrderMap uocChngOrderMap = new UocChngOrderMap();
                uocChngOrderMap.setOrderId(reqBo.getOrderId());
                uocChngOrderMap.setChngOrderId(uocBaseExtParallelDeleteBo.getObjId());
                uocChngOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
                uocChngOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                uocChngOrderMap.setUpdateTime(now);
                extParallelBoList.add(uocChngOrderMap);
            });
            delChngOrderDo.setUocChngOrderMapList(extParallelBoList);
            iUocChngOrderModel.updateInvalid(delChngOrderDo);
        }
        if (!CollectionUtils.isEmpty(reqBo.getExtEditList())) {
            UocChngOrderDo add = new UocChngOrderDo();
            UocChngOrderDo modify = new UocChngOrderDo();
            List<UocChngOrderMap> addList = new ArrayList<>();
            List<UocChngOrderMap> modifyList = new ArrayList<>();
            reqBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
                    UocChngOrderMap addShipOrderMap = new UocChngOrderMap();
                    addShipOrderMap.setChngOrderId(uocBaseExtParallelEditBo.getObjId());
                    addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
                    addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    addShipOrderMap.setOrderId(reqBo.getOrderId());
                    addShipOrderMap.setId(IdUtil.nextId());
                    addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
                    addShipOrderMap.setCreateTime(now);
                    addList.add(addShipOrderMap);
                } else {
                    UocChngOrderMap updateShipOrderMap = new UocChngOrderMap();
                    updateShipOrderMap.setChngOrderId(uocBaseExtParallelEditBo.getObjId());
                    updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    updateShipOrderMap.setOrderId(reqBo.getOrderId());
                    updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                    updateShipOrderMap.setUpdateTime(now);
                    modifyList.add(updateShipOrderMap);
                }
            });
            if (!CollectionUtils.isEmpty(addList)) {
                add.setUocChngOrderMapList(addList);
                iUocChngOrderModel.addChngOrderMap(add);
            }
            if (!CollectionUtils.isEmpty(modifyList)) {
                modify.setUocChngOrderMapList(modifyList);
                iUocChngOrderModel.updateBatchValue(modify);
            }
        }
    }

    private void validateArg(UocCancelApplySaleOrderReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCancelApplySaleOrderReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[销售单id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getCancelReason())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[取消原因]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getUserId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[用户ID]不能为空");
        }
        if (!CollectionUtils.isEmpty(reqBo.getExtDeleteList())) {
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性对象ID不能为空");
                }
                if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性编码不能为空");
                }
            });
        }
        if (!CollectionUtils.isEmpty(reqBo.getExtEditList())) {
            reqBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型不能为空");
                }
                if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型仅支持新增和修改");
                }
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，对象ID不能为空");
                    }
                    if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，属性编码不能为空");
                    }
                }
                if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，对象ID不能为空");
                    }
                    if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性编码不能为空");
                    }
                    if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldValue())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性值不能为空");
                    }
                }
            });
        }
    }
}
