/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.service.domainservice.UocProcInsTerminateDomainService;
import com.tydic.dyc.oc.service.domainservice.bo.UocProcInsTerminateDomainReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocProcInsTerminateDomainRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocProcInsTerminateDomainService"})
public class UocProcInsTerminateDomainServiceImpl
implements UocProcInsTerminateDomainService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"dealProcInsTerminate"})
    public UocProcInsTerminateDomainRspBo dealProcInsTerminate(@RequestBody UocProcInsTerminateDomainReqBo reqBo) {
        this.val(reqBo);
        this.updateProcInst(reqBo);
        List<UocOrderTaskInst> uocOrderTaskInsts = this.getUocOrderTaskInsts(reqBo);
        this.updateTaskFinish(reqBo);
        return UocRu.success(UocProcInsTerminateDomainRspBo.class);
    }

    private void updateTaskFinish(UocProcInsTerminateDomainReqBo reqBo) {
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setObjId(reqBo.getObjId());
        uocOrderTaskInst.setObjType(reqBo.getObjType());
        uocOrderTaskInst.setOrderId(reqBo.getOrderId());
        uocOrderTaskInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
        this.iUocSaleOrderModel.updateTaskInst(uocOrderTaskInst);
    }

    private void saveTaskInst(UocProcInsTerminateDomainReqBo reqBo, List<UocOrderTaskInst> uocOrderTaskInsts) {
        ArrayList<UocOrderTaskInst> saveList = new ArrayList<UocOrderTaskInst>();
        UocOrderTaskInst taskBo = new UocOrderTaskInst();
        taskBo.setId(IdUtil.nextId());
        taskBo.setOrderId(reqBo.getOrderId());
        taskBo.setTaskInstId(String.valueOf(IdUtil.nextId()));
        taskBo.setObjId(reqBo.getObjId());
        taskBo.setObjType(reqBo.getObjType());
        taskBo.setProcState(uocOrderTaskInsts.get(0).getProcState() + "-F");
        taskBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
        saveList.add(taskBo);
        this.iUocSaleOrderModel.saveProcTaskInst(saveList);
    }

    private List<UocOrderTaskInst> getUocOrderTaskInsts(UocProcInsTerminateDomainReqBo reqBo) {
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setOrderId(reqBo.getOrderId());
        uocOrderTaskInst.setObjType(reqBo.getObjType());
        uocOrderTaskInst.setObjId(reqBo.getObjId());
        uocOrderTaskInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
        if (CollectionUtils.isEmpty(uocOrderTaskInsts)) {
            throw new BaseBusinessException("101016", "\u67e5\u8be2\u4ee3\u529e\u4efb\u52a1\u4e3a\u7a7a");
        }
        return uocOrderTaskInsts;
    }

    private void updateProcInst(UocProcInsTerminateDomainReqBo reqBo) {
        UocOrderProcInst uocOrderProcInst = new UocOrderProcInst();
        uocOrderProcInst.setOrderId(reqBo.getOrderId());
        uocOrderProcInst.setObjType(reqBo.getObjType());
        uocOrderProcInst.setObjId(reqBo.getObjId());
        uocOrderProcInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
        this.iUocSaleOrderModel.updateProcInst(uocOrderProcInst);
    }

    private void val(UocProcInsTerminateDomainReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getObjId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getObjType()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

