package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.config.UocInitConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocProcInsTerminateUpdateStateDomainServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocProcInsTerminateUpdateStateDomainServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocProcInsTerminateUpdateStateDomainServiceImpl
 * 说明:流程终止更新单据状态
 * 时间:2022-05-30 10:43:16
 * 作者:luoyou
 */

@HTServiceImpl
public class UocProcInsTerminateUpdateStateDomainServiceImpl implements UocProcInsTerminateUpdateStateDomainService {

	@Autowired
	private IUocOrderModel iUocOrderModel;

	@Autowired
	private UocInitConfig uocInitConfig;

	@Autowired
	private IUocShipOrderModel iUocShipOrderModel;

	@Autowired
	private IUocSaleOrderModel iUocSaleOrderModel;

	@Autowired
	private IUocChngOrderModel iUocChngOrderModel;

	private static final String LINE = "-";

	@Override
	public UocProcInsTerminateUpdateStateDomainServiceRspBo dealUpdateStateProcInsTerminate(UocProcInsTerminateUpdateStateDomainServiceReqBo reqBo) {
		val(reqBo);
		List<UocOrderProcInst> uocOrderProcInstList = getUocOrderProcInsts(reqBo);
		if (!CollectionUtils.isEmpty(uocOrderProcInstList)) {
			List<UocOrderTaskInst> uocOrderTaskInsts = getUocOrderTaskInsts(reqBo);
			if (!CollectionUtils.isEmpty(uocOrderTaskInsts)) {
				UocOrderTaskInst uocOrderTaskInst = uocOrderTaskInsts.get(0);
				String state = uocInitConfig.getStateByTachecode(uocOrderTaskInst.getProcState() + UocConstant.FINISH_OTHER_TAG.FINISH, uocOrderTaskInst.getObjType());
				updateState(uocOrderTaskInst, state, reqBo);
			}
		}
		return UocRu.success(UocProcInsTerminateUpdateStateDomainServiceRspBo.class);
	}

	private List<UocOrderProcInst> getUocOrderProcInsts(UocProcInsTerminateUpdateStateDomainServiceReqBo reqBo) {
		UocOrderProcInstQryBo uocOrderProcInstQryBo = new UocOrderProcInstQryBo();
		uocOrderProcInstQryBo.setProcInstId(reqBo.getProcInstId());
		uocOrderProcInstQryBo.setOrderId(reqBo.getOrderId());
		uocOrderProcInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
		uocOrderProcInstQryBo.setObjTypeNoInList(Collections.singletonList(UocDicConstant.OBJ_TYPE.APPROVE));
		return iUocOrderModel.qryOrderProcInstList(uocOrderProcInstQryBo);
	}

	private List<UocOrderTaskInst> getUocOrderTaskInsts(UocProcInsTerminateUpdateStateDomainServiceReqBo reqBo) {
		UocOrderTaskInstQryBo uocOrderTaskInstQryBo = new UocOrderTaskInstQryBo();
		uocOrderTaskInstQryBo.setProcInstId(reqBo.getProcInstId());
		uocOrderTaskInstQryBo.setOrderId(reqBo.getOrderId());
		uocOrderTaskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
		uocOrderTaskInstQryBo.setOrderBy("finish_time desc");
		return iUocOrderModel.qryOrderTaskInstList(uocOrderTaskInstQryBo);
	}

	private void val(UocProcInsTerminateUpdateStateDomainServiceReqBo reqBo) {
		if (null == reqBo) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
		}
		if (StringUtils.isBlank(reqBo.getProcInstId())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参流程实例ID为空");
		}
	}

	private void updateState(UocOrderTaskInst uocOrderTaskInst, String state, UocProcInsTerminateUpdateStateDomainServiceReqBo reqBo) {
		//环节，可能不变更状态，所以需要配置了状态才更新
		if (ObjectUtil.isNotEmpty(state)) {
			String operId = uocOrderTaskInst.getDealOperId();
			if (StringUtils.isBlank(operId)) {
				if (null != reqBo.getUserId()) {
					operId = reqBo.getUserId().toString();
				} else {
					operId = "1";
				}
			}
			if (UocDicConstant.OBJ_TYPE.SHIP.equals(uocOrderTaskInst.getObjType())) {
				//更新销售单状态
				UocShipOrderDo updateShipDo = new UocShipOrderDo();
				updateShipDo.setOrderId(uocOrderTaskInst.getOrderId());
				updateShipDo.setShipOrderId(uocOrderTaskInst.getObjId());
				updateShipDo.setShipOrderState(state);
				updateShipDo.setUpdateTime(new Date());
				updateShipDo.setUpdateOperId(uocOrderTaskInst.getDealOperId());
				iUocShipOrderModel.updateShipStatusAndProCode(updateShipDo);
			}
			if (UocDicConstant.OBJ_TYPE.SALE.equals(uocOrderTaskInst.getObjType())) {
				//更新销售单状态和环节编码
				UocSaleOrderDo updateSaleDo = new UocSaleOrderDo();
				updateSaleDo.setUpdateOperId(uocOrderTaskInst.getDealOperId());
				updateSaleDo.setOrderId(uocOrderTaskInst.getOrderId());
				updateSaleDo.setSaleOrderId(uocOrderTaskInst.getObjId());
				updateSaleDo.setSaleOrderState(state);
				updateSaleDo.setUpdateTime(new Date());
				updateSaleDo.setUpdateOperName(uocOrderTaskInst.getDealOperName());
				iUocSaleOrderModel.updateSaleStatusAndProCode(updateSaleDo);
			}
			if (UocDicConstant.OBJ_TYPE.CHNG.equals(uocOrderTaskInst.getObjType())) {
				//更新销售单状态和环节编码
				UocChngOrderDo updateChngDo = new UocChngOrderDo();
				updateChngDo.setUpdateOperId(uocOrderTaskInst.getDealOperId());
				updateChngDo.setUpdateTime(new Date());
				updateChngDo.setUpdateOperName(uocOrderTaskInst.getDealOperName());
				updateChngDo.setOrderId(uocOrderTaskInst.getOrderId());
				updateChngDo.setChngOrderId(uocOrderTaskInst.getObjId());
				updateChngDo.setChngOrderState(state);
				iUocChngOrderModel.updateShipStatusAndProCode(updateChngDo);
			}
		}
	}
}
