package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderQryBo;
import com.tydic.dyc.oc.model.payorder.sub.UocPayOrder;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryDetailBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 标题:UocQryChngOrderDetailsServiceImpl
 * 说明:变更单详情查询
 * 时间:2022/3/14 21:40
 * 作者:罗有
 */

@HTServiceImpl
public class UocQryChngOrderDetailsServiceImpl implements UocQryChngOrderDetailsService {
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;

    @Override
    public UocQryChngOrderDetailsRspBo getChngOrderDetails(UocQryChngOrderDetailsReqBo reqBo) {
        val(reqBo);
        UocQryChngOrderDetailsRspBo uocQryChngOrderDetailsRspBo = UocRu.success(UocQryChngOrderDetailsRspBo.class);
        UocChngOrderQryBo uocChngOrderQryBo = UocRu.js(reqBo, UocChngOrderQryBo.class);
        UocChngOrderDo chngOrder = iUocChngOrderModel.getChngOrder(uocChngOrderQryBo);
        if (null != chngOrder) {
            UocQryChngOrderDetailsRspInfoBo chngOrderInfo = UocRu.js(chngOrder, UocQryChngOrderDetailsRspInfoBo.class);
            Map<String, Map<String, String>> dicMap = getDic();
            Map<String, String> chngStateMap = dicMap.get(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.P_CODE);
            Map<String, String> saleStateMap = dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE);
            Map<String, String> orderStateMap = dicMap.get(UocDicConstant.ORD_STATE.P_CODE);
            Map<String, String> adjustPriceMap = dicMap.get(UocDicConstant.ADJUST_PRICE.P_CODE);
            Map<String, String> agreementModeMap = dicMap.get(UocDicConstant.AGREEMENT_MODE.P_CODE);
            Map<String, String> tradeModeMap = dicMap.get(UocDicConstant.MODEL_SETTLE.P_CODE);
            Map<String, String> chngTypeMap = dicMap.get(UocStateConstants.ChngOrder.CHNG_TYPE.P_CODE);
            Map<String, String> interTypeMap = dicMap.get(UocDicConstant.INTER_TYPE.P_CODE);
            Map<String, String> shipStateMap = dicMap.get(UocStateConstants.ShipOrder.P_CODE);
            Map<String, String> chngStateContentMap = dicMap.get(UocStateConstants.CHNG_STATES.P_CODE);
            Map<String, String> chngOrderStateMap = dicMap.get(UocStateConstants.ChngOrder.CHNG_ORDER_STATE.P_CODE);
            if (ObjectUtil.equal(chngOrder.getBusiType(), UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL)) {
                chngOrderInfo.setChngOrderStateStr(chngStateMap.get(chngOrderInfo.getChngOrderState()));
            } else {
                chngOrderInfo.setChngOrderStateStr(chngOrderStateMap.get(chngOrderInfo.getChngOrderState()));
            }
            //查询订单主体
            UocOrderDo uocOrderDo = new UocOrderDo();
            uocOrderDo.setOrderId(reqBo.getOrderId());
            uocOrderDo = iUocOrderModel.qryOrderBy(uocOrderDo);
            if (ObjectUtil.isNotNull(uocOrderDo)) {
                chngOrderInfo.setOrderNo(uocOrderDo.getOrderNo());
                chngOrderInfo.setOrderTime(uocOrderDo.getCreateTime());
                chngOrderInfo.setOrderState(uocOrderDo.getOrderState());
                chngOrderInfo.setOrderStateStr(orderStateMap.get(uocOrderDo.getOrderState()));
            }
            UocOrderAccessoryQryBo uocOrderAccessoryQryBo = new UocOrderAccessoryQryBo();
            uocOrderAccessoryQryBo.setOrderId(reqBo.getOrderId());
            uocOrderAccessoryQryBo.setObjId(reqBo.getChngOrderId());
            uocOrderAccessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
            List<UocOrderAccessory> orderAccessoryList = iUocOrderModel.getOrderAccessoryList(uocOrderAccessoryQryBo);
            if (ObjectUtil.isNotEmpty(orderAccessoryList)) {
                List<UocBaseOrderAccessoryTypeDetailBo> orderAccessoryTypeDetailBos = new ArrayList<>();
                ConcurrentMap<Integer, List<UocOrderAccessory>> orderAccessoryMap = orderAccessoryList.stream().collect(Collectors.groupingByConcurrent(UocOrderAccessory::getAttachmentType));
                orderAccessoryMap.keySet().forEach(each -> {
                    UocBaseOrderAccessoryTypeDetailBo typeDetailBo = new UocBaseOrderAccessoryTypeDetailBo();
                    typeDetailBo.setAttachmentType(each);
                    if (ObjectUtil.isNotNull(each)) {
                        typeDetailBo.setAttachmentTypeStr(getDic().get(UocDicConstant.ATTACHMENT_TYPE.P_CODE).get(each.toString()));
                    }
                    typeDetailBo.setAttchList(UocRu.jsl(orderAccessoryMap.get(each), UocBaseOrderAccessoryDetailBo.class));
                    orderAccessoryTypeDetailBos.add(typeDetailBo);
                });
                chngOrderInfo.setChngOrderAccessoryList(orderAccessoryTypeDetailBos);
            }

            UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
            uocChngOrderObjQryBo.setOrderId(reqBo.getOrderId());
            uocChngOrderObjQryBo.setChngOrderId(reqBo.getChngOrderId());
            List<UocChngOrderObj> uocChngOrderObjList = iUocChngOrderModel.getListChngOrderObj(uocChngOrderObjQryBo);
            if (!CollectionUtils.isEmpty(uocChngOrderObjList)) {
                UocChngOrderObj uocChngOrderObj = uocChngOrderObjList.get(0);
                List<Long> shipOrderItemIdList = uocChngOrderObj.getUocChngOrderItemObjList().stream().map(UocChngOrderItemObj::getShipOrderItemId).filter(Objects::nonNull).collect(Collectors.toList());
                if(org.apache.commons.collections.CollectionUtils.isNotEmpty(shipOrderItemIdList)) {
                    chngOrderInfo.setShipOrderItemIdList(shipOrderItemIdList);
                }
                chngOrderInfo.setChngType(uocChngOrderObj.getChngType());
                if (null != chngOrderInfo.getChngType()) {
                    chngOrderInfo.setChngTypeStr(chngTypeMap.get(chngOrderInfo.getChngType().toString()));
                }
                UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
                uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
                uocShipOrderQryBo.setShipOrderId(uocChngOrderObj.getShipOrderId());
                UocShipOrderDo shipOrderOrderDo = iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
                if (ObjectUtil.isNotNull(shipOrderOrderDo)) {
                    chngOrderInfo.setShipOrderNo(shipOrderOrderDo.getShipOrderNo());
                }
                //支付单主体
                UocPayOrderQryBo payQryBo = new UocPayOrderQryBo();
                payQryBo.setOrderId(reqBo.getOrderId());
                List<UocPayOrder> payOrderList = iUocPayOrderModel.getListPayOrder(payQryBo);
                if (ObjectUtil.isNotEmpty(payOrderList)) {
                    chngOrderInfo.setInterType(payOrderList.get(0).getInterType());
                    chngOrderInfo.setPayFee(payOrderList.get(0).getPayFee());
                    if (payOrderList.get(0).getInterType() != null) {
                        chngOrderInfo.setInterTypeStr(interTypeMap.get(payOrderList.get(0).getInterType().toString()));
                    }
                }
                //销售单主体
                UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
                uocSaleOrderQryBo.setSaleOrderId(uocChngOrderObj.getSaleOrderId());
                uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
                UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
                if (null != uocSaleOrderDo) {
                    //三方信息
                    if (null != uocSaleOrderDo.getStakeholder()) {
                        BeanUtils.copyProperties(uocSaleOrderDo.getStakeholder(), chngOrderInfo);
                    }
                    chngOrderInfo.setSaleOrderNo(uocSaleOrderDo.getSaleOrderNo());
                    chngOrderInfo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
                    chngOrderInfo.setSaleOrderState(uocSaleOrderDo.getSaleOrderState());
                    chngOrderInfo.setSaleOrderStateStr(saleStateMap.get(uocSaleOrderDo.getSaleOrderState()));
                    chngOrderInfo.setTotalSaleFee(uocSaleOrderDo.getTotalSaleFee());
                    chngOrderInfo.setTotalTransFee(uocSaleOrderDo.getTotalTransFee());
                    chngOrderInfo.setCommodityFee(uocSaleOrderDo.getTotalSaleFee());
                    //协议订单，需要查询协议信息
                    if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(uocSaleOrderDo.getOrderSource())) {
                        UocOrderAgreementQryBo uocOrderAgreementQryBo = new UocOrderAgreementQryBo();
                        uocOrderAgreementQryBo.setOrderId(reqBo.getOrderId());
                        uocOrderAgreementQryBo.setId(uocSaleOrderDo.getAgrDataId());
                        List<UocOrderAgreement> agreementOrderList = iUocSaleOrderModel.getAgreementOrderList(uocOrderAgreementQryBo);
                        if (ObjectUtil.isNotEmpty(agreementOrderList)) {
                            chngOrderInfo.setChngAgreementInfo(new UocQryChngOrderDetailsRspInfoAgreementDataBo());
                            chngOrderInfo.getChngAgreementInfo().setAgreementCode(agreementOrderList.get(0).getAgreementCode());
                            chngOrderInfo.getChngAgreementInfo().setPlaAgreementCode(agreementOrderList.get(0).getPlaAgreementCode());
                            chngOrderInfo.getChngAgreementInfo().setEntAgreementCode(agreementOrderList.get(0).getEntAgreementCode());
                            chngOrderInfo.getChngAgreementInfo().setProducerName(agreementOrderList.get(0).getProducerName());
                            chngOrderInfo.getChngAgreementInfo().setAgreementName(agreementOrderList.get(0).getAgreementName());
                            chngOrderInfo.getChngAgreementInfo().setAdjustPrice(agreementOrderList.get(0).getAdjustPrice());
                            chngOrderInfo.setModelSettle(agreementOrderList.get(0).getTradeMode());
                            if (null != agreementOrderList.get(0).getTradeMode()) {
                                chngOrderInfo.setModelSettleStr(tradeModeMap.get(agreementOrderList.get(0).getTradeMode().toString()));
                            }
                            if (null != agreementOrderList.get(0).getAdjustPrice()) {
                                chngOrderInfo.getChngAgreementInfo().setAdjustPriceStr(adjustPriceMap.get(agreementOrderList.get(0).getAdjustPrice().toString()));
                            }
                            if (null != agreementOrderList.get(0).getAgreementCode()) {
                                chngOrderInfo.getChngAgreementInfo().setAgreementCodeStr(agreementModeMap.get(agreementOrderList.get(0).getAdjustPrice().toString()));
                            }
                        }
                    }
                    //查询发货单明细
                    UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
                    uocShipOrderItemQryBo.setOrderId(uocChngOrderObj.getOrderId());
                    uocShipOrderItemQryBo.setShipOrderId(uocChngOrderObj.getShipOrderId());
                    UocShipOrderDo listShipOrderItem = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
                    Map<Long, UocShipOrderItem> shipOrderItemMap = new HashMap<>();
                    if (ObjectUtil.isNotEmpty(listShipOrderItem.getShipOrderItemBoList())) {
                        shipOrderItemMap = listShipOrderItem.getShipOrderItemBoList().stream().collect(Collectors.toMap(UocShipOrderItem::getSaleOrderItemId, Function.identity(), (k1, k2) -> k2));
                    }
                    UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
                    uocSaleOrderItemQryBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
                    uocSaleOrderItemQryBo.setOrderId(uocSaleOrderDo.getOrderId());
                    List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
                    if (!CollectionUtils.isEmpty(saleOrderItemList)) {
                        List<UocChngOrderItemObj> uocChngOrderItemObjList = uocChngOrderObj.getUocChngOrderItemObjList();
                        //过滤出对应的变更单数据
                        List<Long> changeSaleOrderItemList = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).filter(Objects::nonNull).collect(Collectors.toList());

                        saleOrderItemList = saleOrderItemList.stream().filter(item -> changeSaleOrderItemList.contains(item.getSaleOrderItemId())).collect(Collectors.toList());
                        chngOrderInfo.setChngOrderItemList(UocRu.jsl(saleOrderItemList, UocQryChngOrderDetailsRspInfoItemBo.class));
                        for (UocQryChngOrderDetailsRspInfoItemBo each : chngOrderInfo.getChngOrderItemList()) {
                            UocChngOrderItemObjQryBo qryBo = new UocChngOrderItemObjQryBo();
                            qryBo.setOrderId(each.getOrderId());
                            qryBo.setChngOrderId(chngOrder.getChngOrderId());
                            qryBo.setSaleOrderItemId(each.getSaleOrderItemId());
                            List<UocChngOrderItemObj> chngItemObjList = iUocChngOrderModel.getListChngOrderItemObj(qryBo);
                            if (ObjectUtil.isNotEmpty(chngItemObjList)) {
                                List<UocChngOrderItemObj> chngFeeNonList = chngItemObjList.stream().filter(item -> item.getChngFee() != null).collect(Collectors.toList());
                                List<UocChngOrderItemObj> chngNumNonList = chngItemObjList.stream().filter(item -> item.getChngNum() != null).collect(Collectors.toList());
                                List<UocChngOrderItemObj> chngTypeNonList = chngItemObjList.stream().filter(chngItem -> null != chngItem.getChngType()).collect(Collectors.toList());
                                each.setChngState(chngItemObjList.get(0).getChngState());
                                Optional.ofNullable(each.getChngState()).ifPresent(x->{
                                    each.setChngStateStr(shipStateMap.get(x));
                                });
                                each.setOtherChngValue(chngItemObjList.get(0).getOtherChngValue());
                                Optional.ofNullable(each.getOtherChngValue()).ifPresent(x->{
                                    each.setOtherChngValueStr(chngStateContentMap.get(x));
                                });
                                if (ObjectUtil.isNotEmpty(chngFeeNonList)) {
                                    each.setChngFee(chngFeeNonList.get(0).getChngFee());
                                }
                                if (ObjectUtil.isNotEmpty(chngNumNonList)) {
                                    each.setChngNum(chngNumNonList.get(0).getChngNum());
                                }
                                if (ObjectUtil.isNotEmpty(chngTypeNonList)) {
                                    Map<Integer, UocChngOrderItemObj> chngOrderItemObjMap = chngTypeNonList.stream().collect(Collectors.toMap(UocChngOrderItemObj::getChngType, Function.identity(), (k1, k2) -> k2));
                                    //调价后销售价
                                    if (null != chngOrderItemObjMap.get(UocStateConstants.ChngOrder.CHNG_TYPE.SALE_PRICE_CHNG)) {
                                        each.setSalePriceRear(chngOrderItemObjMap.get(UocStateConstants.ChngOrder.CHNG_TYPE.SALE_PRICE_CHNG).getChngFee());
                                    }
                                    //调价率
                                    if (null != each.getSalePrice() && null != each.getSalePriceRear()) {
                                        each.setAdjustPriceRate(each.getSalePriceRear().subtract(each.getSalePrice()).abs().divide(each.getSalePrice()));
                                    }
                                    //调价后采购价
                                    if (null != chngOrderItemObjMap.get(UocStateConstants.ChngOrder.CHNG_TYPE.PURCHASE_PRICE_CHNG)) {
                                        each.setPurchasePriceRear(chngOrderItemObjMap.get(UocStateConstants.ChngOrder.CHNG_TYPE.PURCHASE_PRICE_CHNG).getChngFee());
                                    }
                                    //调价后加价率
//                                    if (null != chngOrderItemObjMap.get(UocStateConstants.ChngOrder.CHNG_TYPE.MARKUP_RATE_CHNG)) {
//                                        each.setMarkUpRateRear(Double.parseDouble(chngOrderItemObjMap.get(UocStateConstants.ChngOrder.CHNG_TYPE.MARKUP_RATE_CHNG).getOtherChngValue()));
//                                    }
                                }
                            }
                            if (ObjectUtil.isNotEmpty(shipOrderItemMap) && shipOrderItemMap.containsKey(each.getSaleOrderItemId())) {
                                each.setInspCount(shipOrderItemMap.get(each.getSaleOrderItemId()).getInspCount());
                                each.setPreReturnCount(shipOrderItemMap.get(each.getSaleOrderItemId()).getReturnCount());
                                each.setCurReturnCount(shipOrderItemMap.get(each.getSaleOrderItemId()).getReturnCount());
                            }
                        }
                    }
                }
            }
            uocQryChngOrderDetailsRspBo.setChngOrderInfo(chngOrderInfo);
        }
        return uocQryChngOrderDetailsRspBo;

    }

    private void val(UocQryChngOrderDetailsReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (null == reqBo.getChngOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更单ID为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID为空");
        }
    }


    private Map<String, Map<String, String>> getDic() {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.P_CODE);
        pCodes.add(UocDicConstant.ATTACHMENT_TYPE.P_CODE);
        pCodes.add(UocDicConstant.SALE_ORD_STATE.P_CODE);
        pCodes.add(UocDicConstant.ORD_STATE.P_CODE);
        pCodes.add(UocDicConstant.ADJUST_PRICE.P_CODE);
        pCodes.add(UocDicConstant.AGREEMENT_MODE.P_CODE);
        pCodes.add(UocDicConstant.MODEL_SETTLE.P_CODE);
        pCodes.add(UocStateConstants.ChngOrder.CHNG_TYPE.P_CODE);
        pCodes.add(UocDicConstant.INTER_TYPE.P_CODE);
        pCodes.add(UocStateConstants.CHNG_STATES.P_CODE);
        pCodes.add(UocStateConstants.ShipOrder.P_CODE);
        pCodes.add(UocStateConstants.ChngOrder.CHNG_ORDER_STATE.P_CODE);
        return iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }


}
