package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo;
import com.tydic.dyc.oc.service.order.bo.UocCreatMsgPoolServiceReqBO;
import com.tydic.dyc.oc.service.order.bo.UocCreatMsgPoolServiceRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

@Slf4j
@HTServiceImpl
public class UocCreatMsgPoolServiceImpl implements UocCreatMsgPoolService{
    
    @Autowired
    private IUocOrderModel iUocOrderModel;
    
    @Override
    public UocCreatMsgPoolServiceRspBO creatMsg(UocCreatMsgPoolServiceReqBO reqBO) {
        UocCreatMsgPoolServiceRspBO rspBO = new UocCreatMsgPoolServiceRspBO();
        rspBO.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
    
        if(reqBO == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        reqBO.setId(IdUtil.nextId());
        iUocOrderModel.insertMsgPool(UocRu.js(reqBO, UocDMsgPoolQryBo.class));
        return rspBO;
    }
}
