package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderObjQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderObj;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.audit.sub.UocAuditOrder;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.*;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

/**
 * 标题:IUocEsSyncImplSale
 * 说明:销售单同步
 * 时间:2022/3/1 12:25
 * 作者:田桂银
 */
@Slf4j
@Component
public class UocEsSyncSale implements IUocEsSync {

    public static final List<String> pCodeList = ListUtil.list(false);

    static {
        initialize();
    }

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;

//    @Autowired
//    private IUocImplOrderModel iUocImplOrderModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;

    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;

    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @Autowired
    private static final String LINE = "_";

    @Override
    public String indexName() {
        return uocIndexConfig.getSaleOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        log.info("syncSaleOrderReq,{}", JSON.toJSONString(reqBo));
        IUocEsSyncQryRspBo rspBo = new IUocEsSyncQryRspBo();
        rspBo.setObjId(reqBo.getObjId());
        //查询销售单主体
        UocSaleOrderDo saleOrderSubject = getSaleOrderSubject(reqBo);
        if (Objects.isNull(saleOrderSubject)) {
            return rspBo;
        }
        //获取字典集合
        Map<String, Map<String, String>> dictionaryMap = iUocSysDictionaryModel.getDictionaryMap(pCodeList);
        //查询业务流程实例
        UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = getProcInst(reqBo, false, UocDicConstant.OBJ_TYPE.SALE);
        //查询审批流程实例
        UocGetSaleOrderDetailServiceRspPorcBo auditProcInst = getAuditProcInst(reqBo, UocDicConstant.OBJ_TYPE.SALE);
        //查询审批单
        List<UocAuditOrderDo> auditOrderList = getAuditOrderList(reqBo);
        //查询销售单扩展
        List<UocSaleOrderMap> saleOrderMapList = getSaleOrderMapList(reqBo);
        //查询销售单附件
        List<UocOrderAccessory> saleOrderAccessoryList = getSaleOrderAccessoryList(reqBo);
        //查询销售单支付配置
        List<UocSaleOrderPayConf> saleOrderPayConfList = getSaleOrderPayConfList(reqBo);
        //查询销售单明细
        List<UocSaleOrderItem> saleOrderItemList = getSaleOrderItemList(reqBo);
        //查询销售单明细扩展
        List<UocSaleItemMap> saleOrderItemMapList = getSaleOrderItemMapList(reqBo);
        //订单扩展
        List<UocOrderMap> orderMapList = getOrderMapList(reqBo.getOrderId());
        //评价状态
        List<UocEvaluate> evaluates = getEvaluates(reqBo);
        //下单系统
        UocOrderDo uocOrderDo = getUocOrderDo(reqBo);
        //应付订单
        List<UocOrderShouldPay> shouldPayList = getShouldPayList(reqBo);
        //服务单
        List<UocAfOrderObj> uocAfOrderObjList = getAfOrderObjList(reqBo);
        List<UocAfOrder> uocAfOrderList = getAfOrderDoList(reqBo);
        //变更单
        List<UocChngOrderObj> uocChngOrderObjList = getChngOrderObjList(reqBo);

        Map<Long, List<UocSaleItemMap>> saleItemMaps = new HashMap<>();
        if (ObjectUtil.isNotEmpty(saleOrderItemMapList)) {
            saleItemMaps = saleOrderItemMapList.stream().collect(Collectors.groupingBy(UocSaleItemMap::getSaleOrderItemId));
        }
        //封装出参
        //销售单支付配置
        saleOrderSubject.setSaleOrderPayConfList(saleOrderPayConfList);
        //销售单附件
        saleOrderSubject.setSaleOrderAccessoryList(saleOrderAccessoryList);
        //销售单 ： 注意这里有些字段查不到
        JSONObject saleOrderObj = JSON.parseObject(JSON.toJSONString(saleOrderSubject));
        //转换
        if (null != saleOrderSubject.getOrderSource()) {
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.ORD_SOURCE, saleOrderSubject.getOrderSource().toString());
        }
        if (null != saleOrderSubject.getJdCz()) {
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.JDCZ_FLAG, saleOrderSubject.getJdCz());
        }
        //销售单扩展
        if (ObjectUtil.isNotEmpty(saleOrderMapList)) {
            saleOrderMapList.forEach(each -> saleOrderObj.put(each.getFieldCode(), each.getFieldValue()));
        }
        //销售单三方信息
        if (ObjectUtil.isNotEmpty(saleOrderSubject.getStakeholder())) {
//            saleOrderObj.putAll(BeanMap.create(saleOrderSubject.getStakeholder()));
            saleOrderObj.putAll(BeanUtil.beanToMap(saleOrderSubject.getStakeholder(), false, true));
        }
        //服务单
        dealAfOrderFlag(saleOrderObj, uocAfOrderObjList);
        dealAfOrderFlagDetail(saleOrderObj, uocAfOrderList);
        //变更单
        dealChngOrder(saleOrderObj, uocChngOrderObjList);
        //销售单明细
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            JSONArray saleOrdeItemArray = new JSONArray();
            List<String> skuIdList = new ArrayList<>();
            List<String> skuNameList = new ArrayList<>();
            List<String> commodityIdList = new ArrayList<>();
            List<String> commodityNameList = new ArrayList<>();
            Integer isReturnFlag = UocDicConstant.IS_RETURN_FLAG.NO;
            for (UocSaleOrderItem item : saleOrderItemList) {
                if (null == item.getSaleFee() && null != item.getSalePrice() && null != item.getPurchaseCount()) {
                    item.setSaleFee(item.getSalePrice().multiply(item.getPurchaseCount()));
                }
                JSONObject saleItemObj = JSON.parseObject(JSON.toJSONString(item, SerializerFeature.WriteMapNullValue));
                //销售单明细扩展
                if (ObjectUtil.isNotEmpty(saleItemMaps) && saleItemMaps.containsKey(item.getSaleOrderItemId())) {
                    List<UocSaleItemMap> uocSaleItemMapList = saleItemMaps.get(item.getSaleOrderItemId());
                    if (ObjectUtil.isNotEmpty(uocSaleItemMapList)) {
                        uocSaleItemMapList.forEach(each -> saleItemObj.put(each.getFieldCode(), each.getFieldValue()));
                    }
                }
                saleOrdeItemArray.add(saleItemObj);
                if (ObjectUtil.isNotEmpty(item.getSkuId())) {
                    skuIdList.add(item.getSkuId());
                }
                if (ObjectUtil.isNotEmpty(item.getSkuName())) {
                    skuNameList.add(item.getSkuName());
                }
                if (ObjectUtil.isNotEmpty(item.getCommodityId())) {
                    commodityIdList.add(item.getCommodityId());
                }
                if (ObjectUtil.isNotEmpty(item.getCommodityName())) {
                    commodityNameList.add(item.getCommodityName());
                }
                if (item.getReturnCount().compareTo(BigDecimal.ZERO) > 0) {
                    isReturnFlag = UocDicConstant.IS_RETURN_FLAG.YES;
                }
            }
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.UOC_SALE_ORDER_ITEM, saleOrdeItemArray);
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.IS_RETURN_FLAG, isReturnFlag);
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.SKU_NAME, skuNameList);
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.SKU_ID, skuIdList);
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.COMMODITY_ID, commodityIdList);
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.COMMODITY_NAME, commodityNameList);
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AUDIT_ORDER, auditOrderList);
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.BUSI_PROC_INST, busiProcInst.getProcInstId());
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AUDIT_PROC_INST, auditProcInst.getProcInstId());
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AUDIT_PROC_DEF_ID, auditProcInst.getProcDefId());
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.BUSI_TASK_INST, busiProcInst.getTaskList());
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AUDIT_TASK_INST, auditProcInst.getTaskList());
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.BUSI_PROC_STATE, ObjectUtil.isNotEmpty(busiProcInst.getTaskList()) ?
                    busiProcInst.getTaskList().stream().map(UocGetSaleOrderDetailServiceRspTaskBo::getProcState).collect(Collectors.toList()) : new ArrayList<>());
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AUDIT_PROC_STATE, ObjectUtil.isNotEmpty(auditProcInst.getTaskList()) ?
                    auditProcInst.getTaskList().stream().map(UocGetSaleOrderDetailServiceRspTaskBo::getProcState).collect(Collectors.toList()) : new ArrayList<>());
        }
        //订单扩展
        if (ObjectUtil.isNotEmpty(orderMapList)) {
            orderMapList.forEach(each -> saleOrderObj.put(each.getFieldCode(), each.getFieldValue()));
        }
        //外部电商信息
        if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(saleOrderSubject.getOrderSource())) {
            List<UocOrderQueryIndex> orderQueryIndexList = getOrderQueryIndexList(reqBo);
            List<UocDMsgPoolQryBo> dMsgList = getDMsgList(reqBo);
            if (ObjectUtil.isNotEmpty(orderQueryIndexList)) {
                saleOrderObj.put(UocConstant.ES_MAIN_OTHER.OUT_ORD_ID, orderQueryIndexList.get(0).getOutObjId());
            }
            if (ObjectUtil.isNotEmpty(dMsgList)) {
                saleOrderObj.put(UocConstant.ES_MAIN_OTHER.VENDOR_ORD_TYPE, dMsgList.get(0).getOrderType());
                if (null != dMsgList.get(0).getOrderType()) {
                    saleOrderObj.put(UocConstant.ES_MAIN_OTHER.VENDOR_ORD_TYPE_STR, dictionaryMap.get(UocDicConstant.VENDOR_ORD_TYPE.P_CODE).get(dMsgList.get(0).getOrderType().toString()));
                }
            }
        }
        //下单系统
        if (null != uocOrderDo) {
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.ORD_SYSTEM, uocOrderDo.getOrderSystem());
        }
        //订单评价状态
        if (ObjectUtil.isNotEmpty(evaluates)) {
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.EVALUATE_STATE, evaluates.get(0).getEvaluateState());
        } else {
            // 如果没有默认未评价
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.EVALUATE_STATE, UocDicConstant.EVA_ACT.NOT_RATED);
        }
        //拉横协议信息
        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderSubject.getOrderSource())) {
            //查询协议信息
            List<UocOrderAgreement> agreementOrderList = getAgreementOrderList(saleOrderSubject);
            //协议信息
            if (ObjectUtil.isNotEmpty(agreementOrderList)) {
                putAgreementInfo(agreementOrderList, saleOrderObj);
            }
        }
        //订单应付信息
        putShouldPayInfo(saleOrderObj, shouldPayList, dictionaryMap);
        putShipInfo(saleOrderObj, reqBo);
        putInspInfo(saleOrderObj, reqBo);
        putDoneTask(saleOrderObj, reqBo);
        putEnableStateChngFlag(saleOrderObj, reqBo);


//        putImplInfo(saleOrderObj, reqBo);
        rspBo.setJsonObj(saleOrderObj);
        //放置状态
        putState(busiProcInst, saleOrderSubject.getOrderSource(), saleOrderSubject.getSaleOrderState(), rspBo, dictionaryMap);
        //翻译
        translateProperties(rspBo, dictionaryMap);
        log.info("销售单es参数:{}", JSON.toJSONString(rspBo));
        return rspBo;
    }

    private void putEnableStateChngFlag(JSONObject saleOrderObj, IUocEsSyncQryReqBo reqBo) {
        List<UocShipOrderDo> shipOrderList = getShipOrderList(reqBo);
        if (CollectionUtil.isNotEmpty(shipOrderList)) {
            Boolean flag = false;
            for (UocShipOrderDo uocShipOrderDo : shipOrderList) {
                UocAfOrderObjQryBo uocAfOrderObjQryBo = new UocAfOrderObjQryBo();
                uocAfOrderObjQryBo.setOrderId(uocShipOrderDo.getOrderId());
                uocAfOrderObjQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
                List<UocAfOrderObj> afOrderObjList = iUocAfOrderModel.getAfOrderObjList(uocAfOrderObjQryBo);
                if (CollectionUtil.isNotEmpty(afOrderObjList)) {
                    UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
                    uocAfOrderQryBo.setOrderId(uocShipOrderDo.getOrderId());
                    uocAfOrderQryBo.setAfOrderId(afOrderObjList.get(0).getAfOrderId());
                    UocAfOrder afOrderById = iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
                    Integer servState = afOrderById.getServState();
                    if (!UocDicConstant.SERVICE_STATE.CANCEL.equals(servState)) {
                        flag = flag || false;
                    } else {
                        flag = flag || true;
                        break;
                    }
                } else {
                    flag = flag || true;
                    break;
                }
            }
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.ENABLE_STAT_CHNG, flag);
        }
    }

    private void dealAfOrderFlagDetail(JSONObject saleOrderObj, List<UocAfOrder> uocAfOrderList) {
        if (CollectionUtil.isNotEmpty(uocAfOrderList)) {
            List<UocAfOrder> uocAfOrdersDone = uocAfOrderList.stream().filter(x -> UocDicConstant.SERVICE_STATE.REMARK_COMPLATE.equals(x.getServState()) || UocDicConstant.SERVICE_STATE.COMPLATE.equals(x.getServState())).collect(Collectors.toList());
            List<UocAfOrder> uocAfOrdersing = uocAfOrderList.stream().filter(x -> !UocDicConstant.SERVICE_STATE.REMARK_COMPLATE.equals(x.getServState()) && !UocDicConstant.SERVICE_STATE.COMPLATE.equals(x.getServState()) && !UocDicConstant.SERVICE_STATE.CANCEL.equals(x.getServState())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(uocAfOrdersDone)) {
                saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AFTERORDERFLAG, UocConstant.SALEORDER_SYN_AFTERORDER.DONE);
                return;
            }
            if (CollectionUtil.isNotEmpty(uocAfOrdersing)) {
                saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AFTERORDERFLAG, UocConstant.SALEORDER_SYN_AFTERORDER.ING);
                return;
            }
        }
    }

    private void dealChngOrder(JSONObject saleOrderObj, List<UocChngOrderObj> uocChngOrderObjList) {
        if (CollectionUtils.isEmpty(uocChngOrderObjList)) {
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.CHANGE_FLAG, false);
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.CANCEL_APPLY_FLAG, false);
        } else {
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.CHANGE_FLAG, true);
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.CHNG_ORDER_ID, uocChngOrderObjList.stream().map(e -> String.valueOf(e.getChngOrderId())).collect(Collectors.toList()));
            Map<Integer, List<UocChngOrderObj>> chngOrderObjMap = uocChngOrderObjList.stream().collect(Collectors.groupingBy(UocChngOrderObj::getChngType));
            if (CollectionUtils.isEmpty(chngOrderObjMap.get(UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL))) {
                saleOrderObj.put(UocConstant.ES_MAIN_OTHER.CANCEL_APPLY_FLAG, false);
            } else {
                saleOrderObj.put(UocConstant.ES_MAIN_OTHER.CANCEL_APPLY_FLAG, true);
            }
        }
    }

    private void dealAfOrderFlag(JSONObject saleOrderObj, List<UocAfOrderObj> uocAfOrderObjList) {
        if (CollectionUtils.isEmpty(uocAfOrderObjList)) {
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AFTER_FLAG, false);
        } else {
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AFTER_FLAG, true);
//            List<String> afOrderIds = uocAfOrderObjList.stream().map(e-> String.valueOf(e.getAfOrderId())).collect(Collectors.toList());
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AF_ORD_ID, uocAfOrderObjList.stream().map(e -> String.valueOf(e.getAfOrderId())).collect(Collectors.toList()));
        }

    }

    /**
     * 变更单对象信息
     */
    private List<UocChngOrderObj> getChngOrderObjList(IUocEsSyncQryReqBo reqBo) {
        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setOrderId(reqBo.getOrderId());
        uocChngOrderObjQryBo.setSaleOrderId(reqBo.getObjId());
        return iUocChngOrderModel.getChngOrderObjList(uocChngOrderObjQryBo);
    }

    /**
     * 售后服务对象信息
     */
    private List<UocAfOrderObj> getAfOrderObjList(IUocEsSyncQryReqBo reqBo) {
        UocAfOrderObjQryBo uocAfOrderObjQryBo = new UocAfOrderObjQryBo();
        uocAfOrderObjQryBo.setOrderId(reqBo.getOrderId());
        uocAfOrderObjQryBo.setSaleOrderId(reqBo.getObjId());
        return iUocAfOrderModel.getAfOrderObjList(uocAfOrderObjQryBo);
    }

    /**
     * 售后服务对象信息
     */
    private List<UocAfOrder> getAfOrderDoList(IUocEsSyncQryReqBo reqBo) {
        UocAfOrderQryBo uocAfOrderObjQryBo = new UocAfOrderQryBo();
        uocAfOrderObjQryBo.setOrderId(reqBo.getOrderId());
        uocAfOrderObjQryBo.setSaleOrderId(reqBo.getObjId());
        return iUocAfOrderModel.getAfOrderList(uocAfOrderObjQryBo);
    }

    private void putDoneTask(JSONObject saleOrderObj, IUocEsSyncQryReqBo reqBo) {
        //查询已办任务
        List<String> doneTask = getDoneTask(reqBo);
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.DONE_TASK_TACHE_CODE, doneTask);
    }

    private void putState(UocGetSaleOrderDetailServiceRspPorcBo busiProcInst, Integer orderSource, String saleOrderState, IUocEsSyncQryRspBo rspBo, Map<String, Map<String, String>> dictionaryMap) {
        List<String> stateList = new ArrayList<>();
        if (StringUtils.isNotBlank(saleOrderState) && StringUtils.isNotBlank(busiProcInst.getProcState())) {
            if (UocStateConstants.SaleOrder.XS_FH_FHWC.equals(saleOrderState) || UocStateConstants.SaleOrder.XS_FH_FHZ.equals(saleOrderState)) {
                stateList.add(busiProcInst.getProcState() + LINE + UocStateConstants.SaleOrder.XS_FH_FHZ);
                stateList.add(busiProcInst.getProcState() + LINE + UocStateConstants.SaleOrder.XS_FH_FHWC);
            } else if (UocStateConstants.SaleOrder.XS_FH_DFH.equals(saleOrderState) && UocStateConstants.SaleTachCode.TC3_DFH.equals(busiProcInst.getProcState())) {
                stateList.add(UocStateConstants.SaleTachCode.TC1_DFH);
                stateList.add(UocStateConstants.SaleTachCode.TC2_DFH);
                stateList.add(UocStateConstants.SaleTachCode.TC3_DFH + LINE + UocStateConstants.SaleOrder.XS_FH_DFH);
            } else {
                stateList.add(busiProcInst.getProcState() + LINE + saleOrderState);
            }
        } else if (StringUtils.isNotBlank(saleOrderState)) {
            stateList.add(saleOrderState);
        } else if (StringUtils.isNotBlank(busiProcInst.getProcState())) {
            if (UocStateConstants.SaleTachCode.TC1_DFH.equals(busiProcInst.getProcState())
                    || UocStateConstants.SaleTachCode.TC2_DFH.equals(busiProcInst.getProcState())) {
                stateList.add(UocStateConstants.SaleTachCode.TC1_DFH);
                stateList.add(UocStateConstants.SaleTachCode.TC2_DFH);
                stateList.add(UocStateConstants.SaleTachCode.TC3_DFH + LINE + UocStateConstants.SaleOrder.XS_FH_DFH);
            } else {
                stateList.add(busiProcInst.getProcState());
            }
        }
        //订单阶段
        Integer orderStage = UocDicConstant.ORDER_STAPE.IN_PROGRESS;
        if (!CollectionUtils.isEmpty(stateList)) {
            if (stateList.contains(UocStateConstants.SaleOrder.XS_YS_YS) || stateList.contains(UocStateConstants.SaleOrder.XS_YS_BFYS)) {
                orderStage = UocDicConstant.ORDER_STAPE.TRADE_SUCCESS;
            } else if (stateList.contains(UocStateConstants.SaleOrder.XS_QX_QX) || stateList.contains(UocStateConstants.SaleOrder.XS_XD_SB)
                    || stateList.contains(UocStateConstants.SaleOrder.XS_SP_BH)) {
                orderStage = UocDicConstant.ORDER_STAPE.TRADE_CLOSE;
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_NOAGREE)) && UocConstant.SkuSource.SELF.equals(orderSource)) {
                rspBo.getJsonObj().put(UocConstant.ES_MAIN_OTHER.SALE_ORD_STATE_STR, dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_NOAGREE).get(stateList.get(0)));

            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_ECOM)) && UocConstant.SkuSource.ELC.equals(orderSource)) {
                rspBo.getJsonObj().put(UocConstant.ES_MAIN_OTHER.SALE_ORD_STATE_STR, dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_ECOM).get(stateList.get(0)));
                //此时uocOrdSale表中sale_order_state为空，手动赋值
                //审批中
//                if (stateList.get(0).equals("E0002"))
//                    rspBo.getJsonObj().put(UocConstant.ES_MAIN_OTHER.SALE_ORD_STATE, UocStateConstants.SaleOrder.XS_SP_SPZ);
//                //待发货
//                if (stateList.get(0).equals("E0005") || stateList.get(0).equals("E0006") || stateList.get(0).equals("E0009_XS_FH_DFH"))
//                    rspBo.getJsonObj().put(UocConstant.ES_MAIN_OTHER.SALE_ORD_STATE, UocStateConstants.SaleOrder.XS_FH_DFH);
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_AGREE)) && UocConstant.SkuSource.AGR.equals(orderSource)) {
                rspBo.getJsonObj().put(UocConstant.ES_MAIN_OTHER.SALE_ORD_STATE_STR, dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_AGREE).get(stateList.get(0)));
            }
        } else {
            rspBo.getJsonObj().put(UocConstant.ES_MAIN_OTHER.SALE_ORD_STATE_STR, "");
        }
        rspBo.getJsonObj().put(UocConstant.ES_MAIN_OTHER.SALE_ORD_TACHE_STATE, stateList);
        rspBo.getJsonObj().put(UocConstant.ES_MAIN_OTHER.ORD_STAGE, orderStage);
    }

    private List<UocDMsgPoolQryBo> getDMsgList(IUocEsSyncQryReqBo reqBo) {
        UocDMsgPoolQryBo dMsgPoolQryBo = new UocDMsgPoolQryBo();
        dMsgPoolQryBo.setOrderId(reqBo.getOrderId());
        dMsgPoolQryBo.setObjId(reqBo.getObjId());
        dMsgPoolQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        return iUocOrderModel.getMsgList(dMsgPoolQryBo);
    }

    private List<UocOrderQueryIndex> getOrderQueryIndexList(IUocEsSyncQryReqBo reqBo) {
        UocOrderQueryIndexQryBo queryIndexQryBo = new UocOrderQueryIndexQryBo();
        queryIndexQryBo.setOrderId(reqBo.getOrderId());
        queryIndexQryBo.setObjId(reqBo.getObjId());
        queryIndexQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        return iUocOrderModel.qryOrderQueryIndexList(queryIndexQryBo);
    }

    private void putShouldPayInfo(JSONObject saleOrderObj, List<UocOrderShouldPay> shouldPayList, Map<String, Map<String, String>> dictionaryMap) {
        if (ObjectUtil.isNotEmpty(shouldPayList)) {
            JSONArray shouldPayArray = new JSONArray();
            for (UocOrderShouldPay shouldPay : shouldPayList) {
                JSONObject shouldPayObj = new JSONObject();
                shouldPayObj.put(UocConstant.ES_MAIN_OTHER.FSC_SHOULD_PAY_ID, shouldPay.getFscShouldPayId());
                shouldPayObj.put(UocConstant.ES_MAIN_OTHER.SHOULD_PAY_AMOUNT, shouldPay.getShouldPayAmount());
                shouldPayObj.put(UocConstant.ES_MAIN_OTHER.PAID_AMOUNT, shouldPay.getPaidAmount());
                shouldPayObj.put(UocConstant.ES_MAIN_OTHER.SHOULD_PAY_TYPE, shouldPay.getShouldPayType());
                shouldPayObj.put(UocConstant.ES_MAIN_OTHER.PAYER_ID, shouldPay.getPayerId());
                shouldPayObj.put(UocConstant.ES_MAIN_OTHER.PAYEE_ID, shouldPay.getPayeeId());
                shouldPayObj.put(UocConstant.ES_MAIN_OTHER.SHOULD_PAY_CREATE_TIME, shouldPay.getCreateTime());
                if (null != shouldPay.getShouldPayType()) {
                    shouldPayObj.put(UocConstant.ES_MAIN_OTHER.SHOULD_PAY_TYPE_STR, dictionaryMap.get(UocDicConstant.SHOULD_PAY_TYPE.P_CODE).get(String.valueOf(shouldPay.getShouldPayType())));
                }
                shouldPayArray.add(shouldPayObj);
            }
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.ORD_SHOULD_PAY_LIST, shouldPayArray);
        }
    }

    /**
     * 查询订单应付列表
     *
     * @param reqBo
     * @return List<UocOrderShouldPay>
     */
    private List<UocOrderShouldPay> getShouldPayList(IUocEsSyncQryReqBo reqBo) {
        UocOrderShouldPay shouldPay = new UocOrderShouldPay();
        shouldPay.setObjectId(reqBo.getObjId());
        shouldPay.setOrderId(reqBo.getOrderId());
        shouldPay.setObjectType(UocDicConstant.OBJ_TYPE.SALE);
        shouldPay.setIsPayCompleted(UocDicConstant.FINISH_FLAG.UN_FINISHED);
        return iUocPayOrderModel.getListOrderShouldPay(shouldPay);
    }


    /**
     * 查询订单主体
     *
     * @param reqBo
     * @return UocOrderDo
     */
    private UocOrderDo getUocOrderDo(IUocEsSyncQryReqBo reqBo) {
        UocOrderDo qryBo = new UocOrderDo();
        qryBo.setOrderId(reqBo.getOrderId());
        return iUocOrderModel.qryOrderBy(qryBo);
    }

    /**
     * 查询订单评价列表
     *
     * @param reqBo
     * @return List<UocEvaluate>
     */
    private List<UocEvaluate> getEvaluates(IUocEsSyncQryReqBo reqBo) {
        UocEvaluateQryBo uocEvaluateQryBo = new UocEvaluateQryBo();
        uocEvaluateQryBo.setOrderId(reqBo.getOrderId());
        uocEvaluateQryBo.setObjId(reqBo.getObjId());
        uocEvaluateQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        return iUocOrderModel.qryOrderEvaluateList(uocEvaluateQryBo);
    }

    /**
     * 拉横协议信息
     *
     * @param agreementOrderList
     * @param saleOrderObj
     */
    private void putAgreementInfo(List<UocOrderAgreement> agreementOrderList, JSONObject saleOrderObj) {
        UocOrderAgreement agreement = agreementOrderList.get(0);
        //协议模式
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AGR_CODE, agreement.getAgreementCode());
        //平台协议编号
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.PLA_AGR_CODE, agreement.getPlaAgreementCode());
        //协议名称
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AGR_NAME, agreement.getAgreementName());
    }

    /**
     * 协议单列表查询
     *
     * @param saleOrderSubject
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderAgreement></>
     */
    private List<UocOrderAgreement> getAgreementOrderList(UocSaleOrderDo saleOrderSubject) {
        UocOrderAgreementQryBo uocOrderAgreementQryBo = new UocOrderAgreementQryBo();
        uocOrderAgreementQryBo.setOrderId(saleOrderSubject.getOrderId());
        uocOrderAgreementQryBo.setId(saleOrderSubject.getAgrDataId());
        return iUocSaleOrderModel.getAgreementOrderList(uocOrderAgreementQryBo);
    }

    /**
     * 初始化pCode集合
     */
    private static void initialize() {
        /*销售单主体*/
        //销售单状态字典
        pCodeList.add(UocDicConstant.SALE_ORD_STATE.P_CODE);
        pCodeList.add(UocDicConstant.SALE_ORD_STATE.P_CODE_AGREE);
        pCodeList.add(UocDicConstant.SALE_ORD_STATE.P_CODE_NOAGREE);
        pCodeList.add(UocDicConstant.SALE_ORD_STATE.P_CODE_ECOM);
        //订单来源字典
        pCodeList.add(UocDicConstant.ORDER_SOURCE.P_CODE);
        //付款方式字典
        pCodeList.add(UocDicConstant.PAY_TYPE.P_CODE);
        //支付状态字典
        pCodeList.add(UocDicConstant.PAY_STATE.P_CODE);
        //竣工标志字典
        pCodeList.add(UocDicConstant.FINISH_FLAG.P_CODE);
        //撤单标志字典
        pCodeList.add(UocDicConstant.CANCEL_FLAG.P_CODE);
        //结算模式字典
        pCodeList.add(UocDicConstant.MODEL_SETTLE.P_CODE);
        //采购类别字典
        pCodeList.add(UocDicConstant.PURCHASE_TYPE.P_CODE);
        //采购模式字典
        pCodeList.add(UocDicConstant.PURCHASE_MODE.P_CODE);
        /*销售单明细信息*/
        //明细类型字典
        pCodeList.add(UocDicConstant.ITEM_TYPE.P_CODE);
        /*协议信息*/
        //协议模式
        pCodeList.add(UocDicConstant.AGREEMENT_MODE.P_CODE);
        //订单阶段
        pCodeList.add(UocDicConstant.ORDER_STAPE.P_CODE);
        //有无退货
        pCodeList.add(UocDicConstant.IS_RETURN_FLAG.P_CODE);
        //评价状态
        pCodeList.add(UocDicConstant.EVA_ACT.P_CODE);
        //应付类型
        pCodeList.add(UocDicConstant.SHOULD_PAY_TYPE.P_CODE);
        //供应商订单类型
        pCodeList.add(UocDicConstant.VENDOR_ORD_TYPE.P_CODE);
    }

    /**
     * 翻译出参数据
     *
     * @param rspBo
     */
    private void translateProperties(IUocEsSyncQryRspBo rspBo, Map<String, Map<String, String>> dictionaryMap) {
        //出参对象
        JSONObject jsonObj = rspBo.getJsonObj();
        if (ObjectUtil.isNotEmpty(dictionaryMap)) {
            /*销售单主体*/
            //销售单状态翻译
//            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE)) && ObjectUtil.isNotEmpty(jsonObj.get(UocConstant.ES_MAIN_OTHER.SALE_ORD_STATE))) {
//                String saleOrdStateCode = jsonObj.getString(UocConstant.ES_MAIN_OTHER.SALE_ORD_STATE);
//                jsonObj.put(UocConstant.ES_MAIN_OTHER.SALE_ORD_STATE_STR, dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE).get(saleOrdStateCode));
//            }
            //订单来源翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.ORDER_SOURCE.P_CODE)) && ObjectUtil.isNotEmpty(jsonObj.get(UocConstant.ES_MAIN_OTHER.ORD_SOURCE))) {
                String ordSourceCode = jsonObj.getString(UocConstant.ES_MAIN_OTHER.ORD_SOURCE);
                jsonObj.put(UocConstant.ES_MAIN_OTHER.ORD_SOURCE_STR, dictionaryMap.get(UocDicConstant.ORDER_SOURCE.P_CODE).get(ordSourceCode));
            }
            //支付状态翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PAY_STATE.P_CODE)) && ObjectUtil.isNotEmpty(jsonObj.get(UocConstant.ES_MAIN_OTHER.PAY_STATE))) {
                String payStateCode = jsonObj.getString(UocConstant.ES_MAIN_OTHER.PAY_STATE);
                jsonObj.put(UocConstant.ES_MAIN_OTHER.PAY_STATE_STR, dictionaryMap.get(UocDicConstant.PAY_STATE.P_CODE).get(payStateCode));
            }
            //竣工标志翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.FINISH_FLAG.P_CODE)) && ObjectUtil.isNotEmpty(jsonObj.get(UocConstant.ES_MAIN_OTHER.FINISH_FLAG))) {
                String finishFlagCode = jsonObj.getString(UocConstant.ES_MAIN_OTHER.FINISH_FLAG);
                jsonObj.put(UocConstant.ES_MAIN_OTHER.FINISH_FLAG_STR, dictionaryMap.get(UocDicConstant.FINISH_FLAG.P_CODE).get(finishFlagCode));
            }
            //撤单标志翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.CANCEL_FLAG.P_CODE)) && ObjectUtil.isNotEmpty(jsonObj.get(UocConstant.ES_MAIN_OTHER.CANCEL_FLAG))) {
                String cancelFlagCode = jsonObj.getString(UocConstant.ES_MAIN_OTHER.CANCEL_FLAG);
                jsonObj.put(UocConstant.ES_MAIN_OTHER.CANCEL_FLAG_STR, dictionaryMap.get(UocDicConstant.CANCEL_FLAG.P_CODE).get(cancelFlagCode));
            }
            //结算模式翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.MODEL_SETTLE.P_CODE)) && ObjectUtil.isNotEmpty(jsonObj.get(UocConstant.ES_MAIN_OTHER.MODEL_SETTLE))) {
                String modelSettleCode = jsonObj.getString(UocConstant.ES_MAIN_OTHER.MODEL_SETTLE);
                jsonObj.put(UocConstant.ES_MAIN_OTHER.MODEL_SETTLE_STR, dictionaryMap.get(UocDicConstant.MODEL_SETTLE.P_CODE).get(modelSettleCode));
            }
            //采购类别翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PURCHASE_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(jsonObj.get(UocConstant.ES_MAIN_OTHER.PURCHASE_TYPE))) {
                String purchaseTypeCode = jsonObj.getString(UocConstant.ES_MAIN_OTHER.PURCHASE_TYPE);
                jsonObj.put(UocConstant.ES_MAIN_OTHER.PURCHASE_TYPE_STR, dictionaryMap.get(UocDicConstant.PURCHASE_TYPE.P_CODE).get(purchaseTypeCode));
            }
            //采购模式翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PURCHASE_MODE.P_CODE)) && ObjectUtil.isNotEmpty(jsonObj.get(UocConstant.ES_MAIN_OTHER.PURCHASE_MODE))) {
                String purchaseModeCode = jsonObj.getString(UocConstant.ES_MAIN_OTHER.PURCHASE_MODE);
                jsonObj.put(UocConstant.ES_MAIN_OTHER.PURCHASE_MODE_STR, dictionaryMap.get(UocDicConstant.PURCHASE_MODE.P_CODE).get(purchaseModeCode));
            }
            /*支付信息*/
            //支付方式翻译
            List<UocSaleOrderPayConf> payConfList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(jsonObj.get(UocConstant.ES_MAIN_OTHER.ORD_PAY_CONFIG))) {
                payConfList = UocRu.jsl(jsonObj.get(UocConstant.ES_MAIN_OTHER.ORD_PAY_CONFIG), UocSaleOrderPayConf.class);
                if (ObjectUtil.isNotEmpty(payConfList)) {
                    payConfList.forEach(each -> {
                        if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PAY_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(each.getPayType())) {
                            each.setPayTypeStr(dictionaryMap.get(UocDicConstant.PAY_TYPE.P_CODE).get(each.getPayType().toString()));
                        }
                    });
                }
            }
            jsonObj.put(UocConstant.ES_MAIN_OTHER.ORD_PAY_CONFIG, JSON.parseArray(JSON.toJSONString(payConfList)));
            /*销售单明细*/
            if (ObjectUtil.isNotEmpty(jsonObj.get(UocConstant.ES_MAIN_OTHER.UOC_SALE_ORDER_ITEM))) {
                List<UocSaleOrderItem> saleOrderItems = UocRu.jsl(jsonObj.get(UocConstant.ES_MAIN_OTHER.UOC_SALE_ORDER_ITEM), UocSaleOrderItem.class);
                if (ObjectUtil.isNotEmpty(saleOrderItems)) {
                    saleOrderItems.forEach(each -> {
                        //明细类型翻译
                        if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.ITEM_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(each.getItemType())) {
                            each.setItemTypeStr(dictionaryMap.get(UocDicConstant.ITEM_TYPE.P_CODE).get(each.getItemType().toString()));
                        }
                    });
                    jsonObj.put(UocConstant.ES_MAIN_OTHER.UOC_SALE_ORDER_ITEM, JSON.parseArray(JSON.toJSONString(saleOrderItems)));
                    //增加供应商id
//                    jsonObj.put(UocConstant.ES_MAIN_OTHER.SUPPLIER_ID,saleOrderItems.get(0).getSupplierId());
                }
            }
            /*发货单*/
            //到货登记翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PURCHASE_TYPE.P_CODE)) && ObjectUtil.isNotNull(jsonObj.get(UocConstant.ES_MAIN_OTHER.IS_ARRIVAL_REGIST))) {
                boolean isArrivalRegist = jsonObj.getBooleanValue(UocConstant.ES_MAIN_OTHER.IS_ARRIVAL_REGIST);
                jsonObj.put(UocConstant.ES_MAIN_OTHER.IS_ARRIVAL_REGIST_STR, isArrivalRegist ? "是" : "否");
            }
            //协议模式翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.AGREEMENT_MODE.P_CODE)) && ObjectUtil.isNotNull(jsonObj.get(UocConstant.ES_MAIN_OTHER.AGR_CODE))) {
                String agreementCode = jsonObj.getString(UocConstant.ES_MAIN_OTHER.AGR_CODE);
                jsonObj.put(UocConstant.ES_MAIN_OTHER.AGR_CODE_STR, dictionaryMap.get(UocDicConstant.AGREEMENT_MODE.P_CODE).get(agreementCode));
            }
            //评价状态翻译
            if (null != dictionaryMap.get(UocDicConstant.EVA_ACT.P_CODE) && null != jsonObj.get(UocConstant.ES_MAIN_OTHER.EVALUATE_STATE)) {
                jsonObj.put(UocConstant.ES_MAIN_OTHER.EVALUATE_STATE_STR, dictionaryMap.get(UocDicConstant.EVA_ACT.P_CODE).get(jsonObj.getString(UocConstant.ES_MAIN_OTHER.EVALUATE_STATE)));
            }
            //有无退货翻译
            if (null != dictionaryMap.get(UocDicConstant.IS_RETURN_FLAG.P_CODE) && null != jsonObj.get(UocConstant.ES_MAIN_OTHER.IS_RETURN_FLAG)) {
                jsonObj.put(UocConstant.ES_MAIN_OTHER.IS_RETURN_FLAG_STR, dictionaryMap.get(UocDicConstant.IS_RETURN_FLAG.P_CODE).get(jsonObj.getString(UocConstant.ES_MAIN_OTHER.IS_RETURN_FLAG)));
            }
            //订单阶段翻译
            if (null != dictionaryMap.get(UocDicConstant.ORDER_STAPE.P_CODE) && null != jsonObj.get(UocConstant.ES_MAIN_OTHER.ORD_STAGE)) {
                jsonObj.put(UocConstant.ES_MAIN_OTHER.ORD_STAGE_STR, dictionaryMap.get(UocDicConstant.ORDER_STAPE.P_CODE).get(jsonObj.getString(UocConstant.ES_MAIN_OTHER.ORD_STAGE)));
            }
        }
    }

    /**
     * 查询流程任务实例
     *
     * @param reqBo
     * @param isAudit
     * @return UocGetSaleOrderDetailServiceRspPorcBo
     */
    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(IUocEsSyncQryReqBo reqBo, Boolean isAudit, Integer objType) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        if (isAudit) {
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        } else {
            procInstQryBo.setObjId(reqBo.getObjId());
            procInstQryBo.setObjType(objType);
        }
        procInstQryBo.setOrderId(reqBo.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            List<Integer> finishTagList = new ArrayList<>();
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
//            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
            taskInstQryBo.setFinishTagList(finishTagList);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                });

                //为了联调，先取第一个环节编码和任务id
                procInst.setProcState(uocOrderTaskInsts.get(0).getProcState());
                procInst.setTaskId(uocOrderTaskInsts.get(0).getTaskInstId());
            }

            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }


    /**
     * 查询流程任务实例
     *
     * @param reqBo
     * @param objType
     * @return UocGetSaleOrderDetailServiceRspPorcBo
     */
    private UocGetSaleOrderDetailServiceRspPorcBo getAuditProcInst(IUocEsSyncQryReqBo reqBo, Integer objType) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        //查询销售单对应的审批单id
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        uocApprovalObjQryBo.setObjId(reqBo.getObjId() + "");
        uocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (CollectionUtil.isNotEmpty(uocApprovalObjs)) {
            List<Long> auditOrderIds = uocApprovalObjs.stream().map(UocApprovalObj::getAuditOrderId).collect(Collectors.toList());
            //查询审批单对应的任务
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setOrderId(reqBo.getOrderId());
            taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            taskInstQryBo.setObjIdList(auditOrderIds);
            //taskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocApprovalObjQryBo uocApprovalObjQryBo1 = new UocApprovalObjQryBo();
                    uocApprovalObjQryBo1.setAuditOrderId(each.getObjId());
                    List<UocApprovalObj> uocApprovalObjs1 = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo1);
                    Integer objBusiType = uocApprovalObjs1.get(0).getObjBusiType();
                    each.setObjBusiType(objBusiType);
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    if (CollectionUtil.isNotEmpty(uocOrderTaskDeals)) {
                        UocOrderTaskDeal uocOrderTaskDeal = uocOrderTaskDeals.get(0);
                        String dealId = uocOrderTaskDeal.getDealId();
                        String dealName = uocOrderTaskDeal.getDealName();
                        each.setDealId(dealId);
                        each.setDealName(dealName);
                    }
                    String auditDealResultQryKey = each.getDealId()+"_"+each.getObjBusiType();
                    if(each.getDealResult()!=null){
                        auditDealResultQryKey = auditDealResultQryKey+"_"+each.getDealResult();
                    }
                    each.setAuditDealResultQryKey(auditDealResultQryKey);
                    each.setTaskDealBo(CollectionUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                });
                procInst.setTaskList(taskBoList);
            }

        }
        return procInst;
    }

    private List<String> getDoneTask(IUocEsSyncQryReqBo reqBo) {
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setObjId(reqBo.getObjId());
        taskInstQryBo.setOrderId(reqBo.getOrderId());
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        List<Integer> finishTagList = new ArrayList<>();
        finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
        taskInstQryBo.setFinishTagList(finishTagList);
        List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if (CollectionUtils.isEmpty(uocOrderTaskInsts)) {
            return new ArrayList<>();
        }
        return uocOrderTaskInsts.stream().map(UocOrderTaskInst::getProcState).collect(Collectors.toList());
    }

//    private void putImplInfo(JSONObject saleOrderObj, IUocEsSyncQryReqBo reqBo) {
//        List<UocImplOrderDo> implOrderList = getImplOrderList(reqBo);
//        List<String> implOrderIdList = new ArrayList<>();
//        List<String> implOrderNoList = new ArrayList<>();
//        implOrderList.forEach(uocImplOrderDo -> {
//            if (null != uocImplOrderDo.getImplOrderId()) {
//                implOrderIdList.add(uocImplOrderDo.getImplOrderId().toString());
//            }
//            implOrderNoList.add(uocImplOrderDo.getImplOrderNo());
//        });
//        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.IMPL_ORDER_IDS, implOrderIdList);
//        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.IMPL_ORDER_ID, ObjectUtil.isNotEmpty(implOrderIdList) ? implOrderIdList.get(0) : "");
//        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.IMPL_ORDER_NO, implOrderNoList);
//    }

    private void putInspInfo(JSONObject saleOrderObj, IUocEsSyncQryReqBo reqBo) {
        List<UocInspOrderDo> inspOrderList = getInspOrderList(reqBo);
        List<String> inspOrderIdList = new ArrayList<>();
        List<String> inspOrderNoList = new ArrayList<>();
        inspOrderList.forEach(uocInspOrderDo -> {
            if (null != uocInspOrderDo.getInspOrderId()) {
                inspOrderIdList.add(uocInspOrderDo.getInspOrderId().toString());
            }
            inspOrderNoList.add(uocInspOrderDo.getInspOrderNo());
        });
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.INSP_ORDER_ID, inspOrderIdList);
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.INSP_ORDER_NO, inspOrderNoList);
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.INSP_ORDER_ID_QRY, StringUtils.join(inspOrderIdList, "|"));
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.INSP_ORDER_NO_QRY, StringUtils.join(inspOrderNoList, "|"));
    }

    private void putShipInfo(JSONObject saleOrderObj, IUocEsSyncQryReqBo reqBo) {
        List<UocShipOrderDo> shipOrderList = getShipOrderList(reqBo);
        if (!CollectionUtils.isEmpty(shipOrderList)) {
            List<String> shipOrderIdList = new ArrayList<>();
            List<String> shipOrderNoList = new ArrayList<>();
            List<String> shipOrderStateList = new ArrayList<>();
            shipOrderList.forEach(uocShipOrderDo -> {
                if (null != uocShipOrderDo.getShipOrderId()) {
                    shipOrderIdList.add(uocShipOrderDo.getShipOrderId().toString());
                }
                shipOrderNoList.add(uocShipOrderDo.getShipOrderNo());
                shipOrderStateList.add(uocShipOrderDo.getShipOrderState());
            });
            //是否可以做到货登记
            boolean isArrivalRegist = false;
            for (UocShipOrderDo uocShipOrderDo : shipOrderList) {
                if (UocStateConstants.ShipOrder.FH_FH_FH.equals(uocShipOrderDo.getShipOrderState())) {
                    isArrivalRegist = true;
                    break;
                }
            }
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.SHIP_ORDER_ID, shipOrderIdList);
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.SHIP_ORDER_NO, shipOrderNoList);
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.SHIP_ORDER_ID_QRY, StringUtils.join(shipOrderIdList, "|"));
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.SHIP_ORDER_NO_QRY, StringUtils.join(shipOrderNoList, "|"));
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.IS_ARRIVAL_REGIST, isArrivalRegist);
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.SHIP_ORDER_STATE, shipOrderStateList);
            List<UocOrderTaskInst> taskInst = getTaskInst(reqBo.getOrderId(), shipOrderIdList.stream().mapToLong(Long::parseLong).boxed().collect(Collectors.toList()));
            List<String> procStateList = new ArrayList<>();
            if (!CollectionUtils.isEmpty(taskInst)) {
                procStateList = taskInst.stream().map(UocOrderTaskInst::getProcState).collect(Collectors.toList());
            }
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.SHIP_ORDER_TACHE_CODE, procStateList);
        }
        List<UocShipOrderItem> shipOrderItemList = getListShipOrderItem(reqBo);
        if (ObjectUtil.isNotEmpty(shipOrderItemList)) {
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.SHIP_SEND_COUNT, shipOrderItemList.get(0).getSendCount());
            saleOrderObj.put(UocConstant.ES_MAIN_OTHER.SHIP_REFUSE_COUNT, shipOrderItemList.get(0).getRefuseCount());
        }
    }


    /**
     * 查询审批单
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.audit.sub.UocAuditOrder>
     */
    private List<UocAuditOrderDo> getAuditOrderList(IUocEsSyncQryReqBo reqBo) {
        UocApprovalObjQryBo obj = new UocApprovalObjQryBo();
        obj.setOrderId(reqBo.getOrderId());
        obj.setObjId(reqBo.getObjId().toString());
        obj.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(obj);
        if (CollectionUtils.isEmpty(uocApprovalObjs)) {
            return new ArrayList<>();
        }
        List<Long> auditOrderIdList = new ArrayList<>();
        uocApprovalObjs.forEach(uocApprovalObj -> auditOrderIdList.add(uocApprovalObj.getAuditOrderId()));
        List<UocAuditOrderDo> uocAuditOrderDoList = new ArrayList<>();
        UocAuditOrderQryBo auditOrderQryBo = new UocAuditOrderQryBo();
        auditOrderQryBo.setOrderId(reqBo.getOrderId());
        auditOrderQryBo.setAuditOrderIdList(auditOrderIdList);
        List<UocAuditOrder> uocAuditOrders = iUocAuditOrderModel.qryAuditOrderList(auditOrderQryBo);
        if (ObjectUtil.isNotEmpty(uocAuditOrders)) {
            uocAuditOrders.forEach(uocAuditOrder -> {
                // 查询流程实例
                UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
                procInstQryBo.setObjId(uocAuditOrder.getAuditOrderId());
                procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
                procInstQryBo.setOrderId(reqBo.getOrderId());
                List<UocOrderProcInst> uocOrderProcInsts = iUocOrderModel.qryOrderProcInstList(procInstQryBo);
                uocAuditOrder.setProcInstId(uocOrderProcInsts.get(0).getProcInstId());
            });
            uocAuditOrderDoList = UocRu.jsl(uocAuditOrders, UocAuditOrderDo.class);
            Map<Long, List<UocApprovalObj>> approvalObjMap = uocApprovalObjs.stream().collect(Collectors.groupingByConcurrent(UocApprovalObj::getAuditOrderId));
            uocAuditOrderDoList.forEach(each -> {
                each.setApprovalObjs(approvalObjMap.get(each.getAuditOrderId()));
            });
        }
        return uocAuditOrderDoList;
    }

    /**
     * 查询销售单主体
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     */
    private UocSaleOrderDo getSaleOrderSubject(IUocEsSyncQryReqBo reqBo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBo.getObjId());
        return iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    /**
     * 查询销售单扩展
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap
     */
    private List<UocSaleOrderMap> getSaleOrderMapList(IUocEsSyncQryReqBo reqBo) {
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = new UocSaleOrderMapQryBo();
        uocSaleOrderMapQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderMapQryBo.setSaleOrderId(reqBo.getObjId());
        return iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
    }

    /**
     * 查询销售单附件
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderAccessory
     */
    private List<UocOrderAccessory> getSaleOrderAccessoryList(IUocEsSyncQryReqBo reqBo) {
        UocOrderAccessoryQryBo uocOrderAccessoryQryBo = UocRu.js(reqBo, UocOrderAccessoryQryBo.class);
        uocOrderAccessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        return iUocSaleOrderModel.getSaleOrderAccessoryList(uocOrderAccessoryQryBo).getSaleOrderAccessoryList();
    }

    /**
     * 查询销售单支付配置
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf
     */
    private List<UocSaleOrderPayConf> getSaleOrderPayConfList(IUocEsSyncQryReqBo reqBo) {
        UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
        uocSaleOrderPayConfQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderPayConfQryBo.setSaleOrderId(reqBo.getObjId());
        return iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
    }

    /**
     * 查询销售单明细
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem
     */
    private List<UocSaleOrderItem> getSaleOrderItemList(IUocEsSyncQryReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getObjId());
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        return iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    /**
     * 查询销售单明细扩展
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap
     */
    private List<UocSaleItemMap> getSaleOrderItemMapList(IUocEsSyncQryReqBo reqBo) {
        UocSaleItemMapQryBo uocSaleItemMapQryBo = new UocSaleItemMapQryBo();
        uocSaleItemMapQryBo.setSaleOrderId(reqBo.getObjId());
        uocSaleItemMapQryBo.setOrderId(reqBo.getOrderId());
        return iUocSaleOrderModel.getSaleOrderItemMapList(uocSaleItemMapQryBo);
    }

    /**
     * 查询发货单列表
     *
     * @param reqBo
     * @return
     */
    private List<UocShipOrderDo> getShipOrderList(IUocEsSyncQryReqBo reqBo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getObjId());
        return iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
    }

    /**
     * 查询发货单明细列表
     *
     * @param reqBo
     * @return
     */
    private List<UocShipOrderItem> getListShipOrderItem(IUocEsSyncQryReqBo reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getObjId());
        UocShipOrderDo uocShipOrderDo = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        return uocShipOrderDo.getShipOrderItemBoList();
    }

    /**
     * 查询发货单列表
     *
     * @param reqBo
     * @return
     */
    private List<UocInspOrderDo> getInspOrderList(IUocEsSyncQryReqBo reqBo) {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setOrderId(reqBo.getOrderId());
        uocInspOrderQryBo.setSaleOrderId(reqBo.getObjId());
        return iUocInspOrderModel.getListInspOrder(uocInspOrderQryBo);
    }

    /**
     * 查询执行单
     */
//    private List<UocImplOrderDo> getImplOrderList(IUocEsSyncQryReqBo reqBo) {
//        UocImplOrderQryBo uocImplOrderQryBo = new UocImplOrderQryBo();
//        uocImplOrderQryBo.setSaleOrderId(reqBo.getObjId());
//        uocImplOrderQryBo.setOrderId(reqBo.getOrderId());
//        return iUocImplOrderModel.getListImplOrder(uocImplOrderQryBo);
//    }
    private List<UocOrderTaskInst> getTaskInst(Long orderId, List<Long> objIdList) {
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setObjIdList(objIdList);
        taskInstQryBo.setOrderId(orderId);
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        List<Integer> finishTagList = new ArrayList<>();
        finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
        taskInstQryBo.setFinishTagList(finishTagList);
        return iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
    }

    private List<UocOrderMap> getOrderMapList(Long orderId) {
        UocOrderMapQryBo uocOrderMapQryBo = new UocOrderMapQryBo();
        uocOrderMapQryBo.setOrderId(orderId);
        return iUocOrderModel.qryOrderMapList(uocOrderMapQryBo);
    }
}


