package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocMoneyUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@HTServiceImpl
@Slf4j
public class UocMsgSplitOrderServiceImpl implements UocMsgSplitOrderService {
    
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    
    @Autowired
    private IUocOrderModel iUocOrderModel;
    
    
    @Override
    public UocMsgSplitOrderRspBo splitOrder(UocMsgSplitOrderReqBo reqBo) {
        //查询销售订单信息
        UocSaleOrderDo uocSaleOrderDo = qrySale(reqBo);
        if(null == uocSaleOrderDo){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR,"订单拆单通知业务失败：未查询到销售订单信息!");
        }
        int count = 0;
        for(UocChildSaleOrderBO childSaleOrderRspBO :reqBo.getExtOrderInfoBO().getChildSaleOrderList()){
            UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO = new UocCreateOrdByOrdSplitBO();
            uocCreateOrdByOrdSplitBO.setUocChildSaleOrderBO(childSaleOrderRspBO);
            uocCreateOrdByOrdSplitBO.setOrderId(uocSaleOrderDo.getOrderId());
            uocCreateOrdByOrdSplitBO.setSaleId(uocSaleOrderDo.getSaleOrderId());
            uocCreateOrdByOrdSplitBO.setCount(count);
            
            splitCoreOrder(uocCreateOrdByOrdSplitBO);
        
        }
        return null;
    }
    
    /*
     * @Author lsl
     * @Description //TODO 查询销售订单信息
     * @Date 16:36 2022/4/12
     * @Param [reqBo]
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     */
    public UocSaleOrderDo qrySale(UocMsgSplitOrderReqBo reqBo){
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        return iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }
    /*
     * @Author lsl
     * @Description //TODO 拆单核心服务
     * @Date 11:29 2022/4/13
     * @Param [orderId, saleOrderId, childSaleOrderRspBO, count]
     * @return void
     */
    public void splitCoreOrder(UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO){
        //新订单ID
        Long newOrderId = IdUtil.nextId();
        
        //根据外部子订单创建订单信息
        createOrderByChildOrder(newOrderId, uocCreateOrdByOrdSplitBO);
        
    }
    /*
     * @Author lsl
     * @Description //TODO
     * @Date 11:33 2022/4/13
     * @Param [newOrderId, childSaleOrderRspBO]
     * @return void
     */
    public void createOrderByChildOrder(Long newOrderId, UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO){
        //外部子订单信息
        UocChildSaleOrderBO childSaleOrderRspBO = uocCreateOrdByOrdSplitBO.getUocChildSaleOrderBO();
        Long totalFee = 0L;
        Long baseFreight = null;
        Long freight = null;
        try {
            totalFee = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getOrderPrice());
            baseFreight = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getBaseFreight());
            if (baseFreight == null) {
                baseFreight = 0L;
            }
            freight = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getFreight());
            if (freight == null) {
                freight = 0L;
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("通过拆单创建子订单时异常：转换订单费用错误!");
        }
        
        UocOrderDo uocOrderDo = new UocOrderDo();
        //构建订单及订单明细表
        buildOrderAndItemParam(newOrderId,uocOrderDo, uocCreateOrdByOrdSplitBO);
        
        //构建发票信息
        buildInvoiceParam(newOrderId,uocOrderDo, uocCreateOrdByOrdSplitBO.getOrderId());
        
        //订单三方信息表
/*        UocOrderStakeholderQryBo qryStakeHolderBo = new UocOrderStakeholderQryBo();
        qryStakeHolderBo.setOrderId(dycUocCreateOrdByOrdSplitBO.getOrderId());
        List<UocOrderStakeholderQryBo> stakeholderQryBos = iUocOrderModel.qryStakeholderList(qryStakeHolderBo);
        if(ObjectUtil.isNotEmpty(stakeholderQryBos)){
            UocOrderStakeholderQryBo uocOrderStakeholderQryBo = stakeholderQryBos.get(0);
            uocOrderStakeholderQryBo.setStakeholderId(IdUtil.nextId());
            uocOrderStakeholderQryBo.setOrderId(newOrderId);
        }*/
        
        //构建附件信息
        buildAccessort(newOrderId,uocOrderDo, uocCreateOrdByOrdSplitBO.getOrderId());
        
        //构建订单物流联系人信息表
        buildLogisticsRelaParam(newOrderId,uocOrderDo, uocCreateOrdByOrdSplitBO.getOrderId());
        
        //构建订单扩展表
        buildOrderMapExtParam(newOrderId,uocOrderDo, uocCreateOrdByOrdSplitBO.getOrderId());
        
        iUocOrderModel.createOrder(uocOrderDo);
        //构建销售及销售明细表
        UocSaleOrderDo saleOrderQryDo = new UocSaleOrderDo();
        buildSaleAndItemParam(newOrderId,saleOrderQryDo, uocCreateOrdByOrdSplitBO);
        
    
        //支构建付配置表
        buildPayConfig(newOrderId,saleOrderQryDo, uocCreateOrdByOrdSplitBO.getOrderId());
        
        iUocSaleOrderModel.createSaleOrder(saleOrderQryDo);
        
    }
    /*
     * @Author lsl
     * @Description //TODO 构建订单及订单明细参数
     * @Date 17:12 2022/4/13
     * @Param []
     * @return
     */
    public void  buildOrderAndItemParam(Long newOrderId, UocOrderDo uocOrderDo, UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO){
       Long totalFee = 0L;
       try {
           totalFee = UocMoneyUtil.bigDecimal2Long(uocCreateOrdByOrdSplitBO.getUocChildSaleOrderBO().getOrderPrice());
           
       } catch (Exception e) {
           e.printStackTrace();
           log.error("通过拆单创建子订单时异常：转换订单费用错误!");
       }
       //订单表
       uocOrderDo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
       uocOrderDo = iUocOrderModel.qryOrderBy(uocOrderDo);
       uocOrderDo.setOrderId(newOrderId);
       uocOrderDo.setOrderNo(String.valueOf(newOrderId));
//       uocOrderDo.setOrderState(UocStateConstants.SaleOrder.XS_CJ_CJ);
       try {
           uocOrderDo.setTotalSaleFee(MoneyUtils.Long2BigDecimal(totalFee));
           uocOrderDo.setTotalPurchaseFee(MoneyUtils.Long2BigDecimal(totalFee));
       } catch (Exception e) {
           e.printStackTrace();
           log.error("通过拆单创建子订单时异常：转换订单费用错误!");
       }
       //订单明细表
       List<UocOrderSkuBO> exSkuList = uocCreateOrdByOrdSplitBO.getUocChildSaleOrderBO().getSku(); //外部单品列表
       UocOrderItemQryBo uocOrderItemQryBo = new UocOrderItemQryBo();
       uocOrderItemQryBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
       List<UocOrderItem> orderItemList = iUocOrderModel.qryOrderItemList(uocOrderItemQryBo);
       for(UocOrderItem orderItem: orderItemList){
           Long ordItemId = IdUtil.nextId();
           for (UocOrderSkuBO extSkuBo: exSkuList){
               if(orderItem.getExtSkuId().equals(extSkuBo.getSkuId())){
                   orderItem.setPurchaseCount(new BigDecimal(extSkuBo.getNum()));
               }
           }
           orderItem.setOrderId(newOrderId);
           orderItem.setOrderItemId(ordItemId);
       }
       uocOrderDo.setOrderItems(orderItemList);
    }
    /*
     * @Author lsl
     * @Description //TODO 构建发票信息
     * @Date 17:18 2022/4/13
     * @Param []
     * @return void
     */
    public void buildInvoiceParam(Long newOrderId,UocOrderDo uocOrderDo,Long orderId){
        UocOrdInvoiceQryBo qryBo = new UocOrdInvoiceQryBo();
        qryBo.setOrderId(orderId);
        UocOrdInvoice uocOrdInvoice = iUocOrderModel.qryOrderInvoice(qryBo);
        if(null != uocOrdInvoice){
            uocOrdInvoice.setId(IdUtil.nextId());
            uocOrdInvoice.setOrderId(newOrderId);
            uocOrderDo.setUocOrdInvoice(uocOrdInvoice);
        }
    }
    /*
     * @Author lsl
     * @Description //TODO 构建附件信息
     * @Date 17:21 2022/4/13
     * @Param
     * @return
     */
    public void buildAccessort(Long newOrderId,UocOrderDo uocOrderDo,Long orderId){
        UocOrderAccessoryQryBo accessoryQryBo = new UocOrderAccessoryQryBo();
        accessoryQryBo.setOrderId(orderId);
        List<UocOrderAccessory> accessoryList = iUocOrderModel.getOrderAccessoryList(accessoryQryBo);
        if(ObjectUtil.isNotEmpty(accessoryList)){
            List<UocOrderAccessory> accessories =new ArrayList<>();
            for (UocOrderAccessory accessory : accessoryList) {
                accessory.setOrderId(newOrderId);
                accessory.setId(IdUtil.nextId());
                //时间
                accessory.setCreateTime(new Date());
                if (accessory.getObjType().equals(1)) {
                    accessory.setObjId(null);
                }
                accessories.add(accessory);
            }
            uocOrderDo.setAccessoryList(accessories);
        }
    }
    
    /*
     * @Author lsl
     * @Description //TODO 构建地址联系人参数
     * @Date 17:24 2022/4/13
     * @Param
     * @return
     */
    public void buildLogisticsRelaParam(Long newOrderId,UocOrderDo uocOrderDo,Long orderId){
        UocOrdLogisticsRelaQryBo logisticsRelaQryBo = new UocOrdLogisticsRelaQryBo();
        logisticsRelaQryBo.setOrderId(orderId);
        UocOrdLogisticsRela uocOrdLogisticsRela = iUocOrderModel.qryOrderLogisticsRela(logisticsRelaQryBo);
        if(null != uocOrdLogisticsRela){
            uocOrdLogisticsRela.setContactId(IdUtil.nextId());
            uocOrdLogisticsRela.setOrderId(newOrderId);
        }
        uocOrderDo.setReceiverAddress(uocOrdLogisticsRela);
    }
    /*
     * @Author lsl
     * @Description //TODO 构建订单扩展参数
     * @Date 17:27 2022/4/13
     * @Param
     * @return
     */
    public void buildOrderMapExtParam(Long newOrderId,UocOrderDo uocOrderDo,Long orderId){
        UocOrderMapQryBo orderMapQryBo = new UocOrderMapQryBo();
        orderMapQryBo.setOrderId(orderId);
        List<UocOrderMap> uocOrderMaps =  iUocOrderModel.qryOrderMapList(orderMapQryBo);
        if(ObjectUtil.isNotEmpty(uocOrderMaps)){
            List<UocOrderMap> poList = new ArrayList<>();
            for (UocOrderMap orderMap: uocOrderMaps){
                orderMap.setId(IdUtil.nextId());
                orderMap.setOrderId(newOrderId);
                poList.add(orderMap);
            }
            uocOrderDo.setOrderExt(poList);
        }
    }
    /*
     * @Author lsl
     * @Description //TODO 构建销售及销售明细表
     * @Date 17:30 2022/4/13
     * @Param
     * @return
     */
    public void buildSaleAndItemParam(Long newOrderId, UocSaleOrderDo saleOrderQryDo, UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO){
        UocChildSaleOrderBO childSaleOrderRspBO = uocCreateOrdByOrdSplitBO.getUocChildSaleOrderBO();
        Long totalFee = 0L;
        Long baseFreight = null;
        Long freight = null;
        try {
            totalFee = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getOrderPrice());
            baseFreight = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getBaseFreight());
            if (baseFreight == null) {
                baseFreight = 0L;
            }
            freight = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getFreight());
            if (freight == null) {
                freight = 0L;
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("通过拆单创建子订单时异常：转换订单费用错误!");
        }
        
        UocSaleOrderQryBo uocSaleOrderBo = new UocSaleOrderQryBo();
        uocSaleOrderBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        saleOrderQryDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderBo);
        saleOrderQryDo.setOrderId(newOrderId);
        saleOrderQryDo.setSaleOrderId(IdUtil.nextId());
        saleOrderQryDo.setSaleOrderNo("");
    
        try {
            saleOrderQryDo.setTotalSaleFee(MoneyUtils.Long2BigDecimal(totalFee));
            saleOrderQryDo.setTotalPurchaseFee(MoneyUtils.Long2BigDecimal(totalFee));
            saleOrderQryDo.setTotalTransFee(MoneyUtils.Long2BigDecimal(baseFreight));
            saleOrderQryDo.setTotalTransFee(MoneyUtils.Long2BigDecimal(baseFreight + freight));
        } catch (Exception e) {
            e.printStackTrace();
            log.error("通过拆单创建子订单时异常：转换订单费用错误!");
        }
//        saleOrderQryDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_CJ_CJ);
    
        //销售单明细表
        List<UocOrderSkuBO> exSkuList = childSaleOrderRspBO.getSku(); //外部单品列表
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        List<UocSaleOrderItem> saleItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        for(UocSaleOrderItem saleOrderItem: saleItemList){
            Long saleOrderItemId = IdUtil.nextId();
            for (UocOrderSkuBO extSkuBo: exSkuList){
                if(saleOrderItem.getSkuExtSkuId().equals(extSkuBo.getSkuId())){
                    saleOrderItem.setPurchaseCount(new BigDecimal(extSkuBo.getNum()));
                }
            }
            saleOrderItem.setOrderId(newOrderId);
            saleOrderItem.setSaleOrderItemId(saleOrderItemId);
        }
        saleOrderQryDo.setSaleOrderItems(saleItemList);
    }
    /*
     * @Author lsl
     * @Description //TODO 构建支付配置表
     * @Date 17:35 2022/4/13
     * @Param
     * @return
     */
    public void buildPayConfig(Long newOrderId,UocSaleOrderDo saleOrderQryDo,Long orderId){
        UocSaleOrderPayConfQryBo payConfQryBo = new UocSaleOrderPayConfQryBo();
        payConfQryBo.setOrderId(orderId);
        List<UocSaleOrderPayConf> payConfList = iUocSaleOrderModel.getSaleOrderPayConfList(payConfQryBo);
        if (ObjectUtil.isEmpty(payConfList)) {
            return;
        }
        UocSaleOrderPayConf uocSaleOrderPayConf = payConfList.get(0);
        uocSaleOrderPayConf.setId(IdUtil.nextId());
        uocSaleOrderPayConf.setOrderId(newOrderId);
        if (ObjectUtil.isNotEmpty(uocSaleOrderPayConf.getPrePayFee())) {
            BigDecimal preFee = saleOrderQryDo.getTotalSaleFee().divide(saleOrderQryDo.getTotalSaleFee(), 2, BigDecimal.ROUND_UP).
                    multiply(uocSaleOrderPayConf.getPrePayFee()).setScale(2, BigDecimal.ROUND_UP);
            preFee = preFee.multiply(new BigDecimal(10000));
            uocSaleOrderPayConf.setPrePayFee(preFee);
        }
        saleOrderQryDo.getSaleOrderPayConfList().add(uocSaleOrderPayConf);
    }
}
