/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderMap;
import com.tydic.dyc.oc.service.domainservice.UocShipOrderArrivaConfirmOrRefuseService;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderArrivaConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderArrivaConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocShipOrderArrivaConfirmOrRefuseService"})
public class UocShipOrderArrivaConfirmOrRefuseServiceImpl
implements UocShipOrderArrivaConfirmOrRefuseService {
    private static final Integer OP_FLAG_CONFIRM = 1;
    private static final Integer OP_FLAG_REFUSE = 2;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    private static final String OP_FLAG_YES = "1";
    private static final String OP_FLAG_NO = "0";

    @PostMapping(value={"dealArriva"})
    public UocShipOrderArrivaConfirmOrRefuseRspBo dealArriva(@RequestBody UocShipOrderArrivaConfirmOrRefuseReqBo reqBo) {
        this.validateArg(reqBo);
        List<UocShipOrderItem> uocShipOrderItemList = this.getListShipOrderItem(reqBo);
        Date now = new Date();
        UocShipOrderDo uocShipOrderDo = this.convertShipOrderDo(reqBo, now);
        if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
            this.dealConfirm(uocShipOrderDo, uocShipOrderItemList);
        }
        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            this.dealRefuse(uocShipOrderDo, uocShipOrderItemList);
        }
        this.dealMap(reqBo, now);
        UocShipOrderArrivaConfirmOrRefuseRspBo uocShipOrderArrivaConfirmOrRefuseRspBo = UocRu.success(UocShipOrderArrivaConfirmOrRefuseRspBo.class);
        boolean allRefuseFlag = this.modifySaleOrderState(reqBo, now);
        uocShipOrderArrivaConfirmOrRefuseRspBo.setAllRefuseFlag(Boolean.valueOf(allRefuseFlag));
        uocShipOrderArrivaConfirmOrRefuseRspBo.setOpFlag(allRefuseFlag ? OP_FLAG_YES : OP_FLAG_NO);
        UocCommonDo uocCommonDo = new UocCommonDo();
        ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(reqBo.getTaskId());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
        return uocShipOrderArrivaConfirmOrRefuseRspBo;
    }

    private void dealMap(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo, Date now) {
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtDeleteList())) {
            UocShipOrderDo delShipOrderDo = new UocShipOrderDo();
            ArrayList<UocShipOrderMap> extParallelBoList = new ArrayList<UocShipOrderMap>();
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                UocShipOrderMap uocShipOrderMap = new UocShipOrderMap();
                uocShipOrderMap.setShipOrderId(uocBaseExtParallelDeleteBo.getObjId());
                uocShipOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
                uocShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                uocShipOrderMap.setUpdateTime(now);
                extParallelBoList.add(uocShipOrderMap);
            });
            delShipOrderDo.setExtParallelBoList(extParallelBoList);
            delShipOrderDo.setUpdateOperId(reqBo.getUserId().toString());
            delShipOrderDo.setUpdateTime(now);
            delShipOrderDo.setOrderId(reqBo.getOrderId());
            this.iUocShipOrderModel.updateInvalid(delShipOrderDo);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtEditList())) {
            UocShipOrderDo add = new UocShipOrderDo();
            UocShipOrderDo modify = new UocShipOrderDo();
            ArrayList<UocShipOrderMap> addList = new ArrayList<UocShipOrderMap>();
            ArrayList<UocShipOrderMap> modifyList = new ArrayList<UocShipOrderMap>();
            reqBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
                    UocShipOrderMap addShipOrderMap = new UocShipOrderMap();
                    addShipOrderMap.setShipOrderId(uocBaseExtParallelEditBo.getObjId());
                    addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
                    addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    addShipOrderMap.setOrderId(reqBo.getOrderId());
                    addShipOrderMap.setSaleOrderId(reqBo.getSaleOrderId());
                    addShipOrderMap.setId(IdUtil.nextId());
                    addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
                    addShipOrderMap.setCreateTime(now);
                    addList.add(addShipOrderMap);
                } else {
                    UocShipOrderMap updateShipOrderMap = new UocShipOrderMap();
                    updateShipOrderMap.setShipOrderId(uocBaseExtParallelEditBo.getObjId());
                    updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    modifyList.add(updateShipOrderMap);
                }
            });
            if (!CollectionUtils.isEmpty(addList)) {
                add.setExtParallelBoList(addList);
                this.iUocShipOrderModel.addShipOrderMap(add);
            }
            if (!CollectionUtils.isEmpty(modifyList)) {
                modify.setExtParallelBoList(modifyList);
                modify.setOrderId(reqBo.getOrderId());
                modify.setUpdateOperId(reqBo.getUserId().toString());
                modify.setUpdateTime(now);
                this.iUocShipOrderModel.updateBatchValue(modify);
            }
        }
    }

    private List<UocShipOrderItem> getListShipOrderItem(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderIdList(reqBo.getShipOrderIdList());
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocShipOrderDo shipOrderDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        if (CollectionUtils.isEmpty(shipOrderDo.getShipOrderItemBoList())) {
            throw new BaseBusinessException("101003", "\u83b7\u53d6\u53d1\u8d27\u660e\u7ec6\u4e3a\u7a7a");
        }
        return shipOrderDo.getShipOrderItemBoList();
    }

    private UocShipOrderDo convertShipOrderDo(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo, Date now) {
        UocShipOrderDo uocShipOrderDo = UocRu.js(reqBo, UocShipOrderDo.class);
        uocShipOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocShipOrderDo.setUpdateTime(now);
        this.setAccessory(reqBo, now, uocShipOrderDo);
        this.setMap(reqBo, now, uocShipOrderDo);
        return uocShipOrderDo;
    }

    private void setMap(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo, Date now, UocShipOrderDo uocShipOrderDo) {
    }

    private void dealConfirm(UocShipOrderDo uocShipOrderDo, List<UocShipOrderItem> uocShipOrderItemList) {
        uocShipOrderItemList.forEach(uocShipOrderItem -> {
            if (uocShipOrderItem.getRefuseCount().compareTo(BigDecimal.ZERO) > 0) {
                throw new BaseBusinessException("101003", "\u5df2\u62d2\u6536\u53d1\u8d27\u5355\u4e0d\u80fd\u505a\u5230\u8d27\u786e\u8ba4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
            if (uocShipOrderItem.getArriveCount().compareTo(BigDecimal.ZERO) > 0) {
                throw new BaseBusinessException("101003", "\u5b58\u5728\u5df2\u786e\u8ba4\u5230\u8d27\u53d1\u8d27\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
        });
        uocShipOrderDo.setShipOrderState("FH_FH_YDH");
        this.iUocShipOrderModel.arrivaConfirm(uocShipOrderDo);
    }

    private void dealRefuse(UocShipOrderDo uocShipOrderDo, List<UocShipOrderItem> uocShipOrderItemList) {
        uocShipOrderItemList.forEach(uocShipOrderItem -> {
            if (uocShipOrderItem.getRefuseCount().compareTo(BigDecimal.ZERO) > 0) {
                throw new BaseBusinessException("101003", "\u5b58\u5728\u5df2\u62d2\u6536\u53d1\u8d27\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
            if (uocShipOrderItem.getArriveCount().compareTo(BigDecimal.ZERO) > 0) {
                throw new BaseBusinessException("101003", "\u5df2\u786e\u8ba4\u5230\u8d27\u53d1\u8d27\u5355\u4e0d\u80fd\u505a\u62d2\u6536\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            }
        });
        this.iUocShipOrderModel.arrivaRefuse(uocShipOrderDo);
    }

    private void setAccessory(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo, Date now, UocShipOrderDo uocShipOrderDo) {
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            ArrayList<UocOrderAccessory> orderAccessoryBoList = new ArrayList<UocOrderAccessory>();
            reqBo.getOrderAccessoryBoList().forEach(orderAccessoryAddBo -> {
                UocOrderAccessory uocOrderAccessory = UocRu.js(orderAccessoryAddBo, UocOrderAccessory.class);
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setObjId(reqBo.getSaleOrderId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                uocOrderAccessory.setCreateTime(now);
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setId(IdUtil.nextId());
                orderAccessoryBoList.add(uocOrderAccessory);
            });
            uocShipOrderDo.setOrderAccessoryBoList(orderAccessoryBoList);
        }
    }

    private boolean modifySaleOrderState(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo, Date now) {
        boolean refuseAll = false;
        String state = null;
        if (!StringUtils.isBlank(state)) {
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setSaleOrderState(state);
            uocSaleOrderDo.setOrderId(reqBo.getOrderId());
            uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
            uocSaleOrderDo.setUpdateTime(now);
            uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
            this.iUocSaleOrderModel.updateSaleStatusAndProCode(uocSaleOrderDo);
        }
        return refuseAll;
    }

    private void validateArg(UocShipOrderArrivaConfirmOrRefuseReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getShipOrderIdList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u5355ID\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOpFlag()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) && !OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            throw new BaseBusinessException("100001", "\u64cd\u4f5c\u4ec5\u652f\u6301\u5230\u8d27\u786e\u8ba4\u6216\u62d2\u6536");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7528\u6237ID\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtDeleteList())) {
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                    throw new BaseBusinessException("100001", "\u8981\u5220\u9664\u7684\u6269\u5c55\u5c5e\u6027\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                    throw new BaseBusinessException("100001", "\u8981\u5220\u9664\u7684\u6269\u5c55\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtEditList())) {
            reqBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
                    throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u7f16\u8f91\u64cd\u4f5c\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u7f16\u8f91\u64cd\u4f5c\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4ec5\u652f\u6301\u65b0\u589e\u548c\u4fee\u6539");
                }
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
                if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldValue())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
            });
        }
    }
}

