package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocConfAudit;
import com.tydic.dyc.oc.service.order.bo.UocDeleteAuditConfReqBo;
import com.tydic.dyc.oc.service.order.bo.UocDeleteAuditConfRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * 标题:UocDeleteAuditConfServiceImpl
 * 说明:审批配置删除
 * 时间:2022-05-20 10:16:39
 * 作者:luoyou
 */

@HTServiceImpl
public class UocDeleteAuditConfServiceImpl implements UocDeleteAuditConfService {

	@Autowired
	private IUocOrderModel iUocOrderModel;

	@Override
	public UocDeleteAuditConfRspBo delAuditConf(UocDeleteAuditConfReqBo reqBo) {
		val(reqBo);
		UocConfAudit uocConfAudit = UocRu.js(reqBo, UocConfAudit.class);
		//删除条件判断不带orgId和OrgName
		uocConfAudit.setOrgId(null);
		uocConfAudit.setOrgName(null);
		iUocOrderModel.deleteAuditConf(uocConfAudit);
		return UocRu.success(UocDeleteAuditConfRspBo.class);
	}

	private void val(UocDeleteAuditConfReqBo reqBo) {
		if (null == reqBo) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
		}
		if (null == reqBo.getId()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参ID不能为空");
		}
	}
}
