package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderItemQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderConfirmOrRefuseReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCreateRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 * 标题：类名称:UocAfterOrderConfirmOrRefuseServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/7 20:30
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
public class UocAfterOrderConfirmOrRefuseServiceImpl implements UocAfterOrderConfirmOrRefuseService{
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocShipOrderModel shipOrderModel;

    private static final Integer OP_FLAG_CONFIRM = 1;

    private static final Integer OP_FLAG_REFUSE = 0;

    @Override
    public UocAfterOrderConfirmOrRefuseRspBo dealAfterOrder(UocAfterOrderConfirmOrRefuseReqBo reqBo) {
        //参数校验
        validateArg(reqBo);
        UocAfterOrderConfirmOrRefuseRspBo rspBo = UocRu.success(UocAfterOrderConfirmOrRefuseRspBo.class);
        //售后单信息，如果拒绝 销售单售后在途数量 减去相应数量
        List<UocAfOrderDo> afOrderDos = buildUpdateBatchAfParam(reqBo);
        iUocAfOrderModel.updateBatchAfOrderMain(afOrderDos);
        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            updateAfingCount(reqBo);
        }
        buidRspBo(reqBo,rspBo);
        return rspBo;
    }

    private void buidRspBo(UocAfterOrderConfirmOrRefuseReqBo reqBo, UocAfterOrderConfirmOrRefuseRspBo rspBo) {
        List<Integer> pickWareTypes = new ArrayList<>();
        for (UocAfterOrderConfirmOrRefuseReqItemBo uocAfterOrderConfirmOrRefuseReqItemBo : reqBo.getAfOrderList()) {
            UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
            uocAfOrderQryBo.setAfOrderId(uocAfterOrderConfirmOrRefuseReqItemBo.getAfOrderId());
            UocAfOrder afOrderInfo = iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
            pickWareTypes.add(afOrderInfo.getPickwareType());
        }
        rspBo.setPickwareType(pickWareTypes);
    }

    private void updateAfingCount(UocAfterOrderConfirmOrRefuseReqBo reqBo) {
        List<UocAfterOrderConfirmOrRefuseReqItemBo> afOrderList = reqBo.getAfOrderList();
        for (UocAfterOrderConfirmOrRefuseReqItemBo uocAfterOrderConfirmOrRefuseReqItemBo : afOrderList) {
            UocAfOrderItemQryBo uocAfOrderQryBo = new UocAfOrderItemQryBo();
            uocAfOrderQryBo.setAfOrderId(uocAfterOrderConfirmOrRefuseReqItemBo.getAfOrderId());
            uocAfOrderQryBo.setOrderId(uocAfterOrderConfirmOrRefuseReqItemBo.getOrderId());
            List<UocAfOrderItem> afOrderItemList = iUocAfOrderModel.getAfOrderItemList(uocAfOrderQryBo);
            for (UocAfOrderItem uocAfOrderItem : afOrderItemList) {
                Long orderItemId = uocAfOrderItem.getSaleItemId();
                BigDecimal returnCount = uocAfOrderItem.getReturnCount();
                Long shipItemId = uocAfOrderItem.getShipItemId();
                UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setOrderId(uocAfOrderItem.getOrderId());
                uocShipOrderItem.setShipOrderItemId(shipItemId);
                uocShipOrderItem.setAfterServingCount(returnCount.negate());
                uocShipOrderItem.setUpdateTime(new Date());
                uocShipOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
                shipOrderModel.modifyShipOrderItemAfterServingCount(uocShipOrderItem);
                UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
                uocSaleOrderItem.setOrderId(uocAfOrderItem.getOrderId());
                uocSaleOrderItem.setSaleOrderItemId(orderItemId);
                uocSaleOrderItem.setAfterServingCount(returnCount.negate());
                uocSaleOrderItem.setUpdateTime(new Date());
                uocSaleOrderItem.setUpdateOperId(Optional.ofNullable(reqBo.getUserId()).toString());
                iUocSaleOrderModel.modifySaleOrderItemAfterServingCount(uocSaleOrderItem);
            }
        }
    }

    private List<UocAfOrderDo> buildUpdateBatchAfParam(UocAfterOrderConfirmOrRefuseReqBo reqBo) {
        List<UocAfOrderDo> afOrderDos = new ArrayList<>();

        if (ObjectUtil.isNotEmpty(reqBo.getReturnReason())) {
            for (UocAfterOrderConfirmOrRefuseReqItemBo uocAfterOrderConfirmOrRefuseReqItemBo : reqBo.getAfOrderList()) {
                UocAfOrderDo uocAfOrderDo = new UocAfOrderDo();
                uocAfOrderDo.setAfOrderId(uocAfterOrderConfirmOrRefuseReqItemBo.getAfOrderId());
                uocAfOrderDo.setOrderId(uocAfterOrderConfirmOrRefuseReqItemBo.getOrderId());
                uocAfOrderDo.setReturnReason(reqBo.getReturnReason());
                uocAfOrderDo.setUpdateTime(new Date());
                uocAfOrderDo.setServState(reqBo.getOpFlag().equals(1)? UocDicConstant.SERVICE_STATE.APPROVAL_PASS:UocDicConstant.SERVICE_STATE.APPROVAL_NOT_PASS);
                afOrderDos.add(uocAfOrderDo);
            }
        }
        return afOrderDos;
    }

    private void validateArg(UocAfterOrderConfirmOrRefuseReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (null == reqBo.getOpFlag()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参操作类型为空");
        }
        if (CollectionUtil.isEmpty(reqBo.getAfOrderList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参售后单据为空");
        }
        for (UocAfterOrderConfirmOrRefuseReqItemBo uocAfterOrderConfirmOrRefuseReqItemBo : reqBo.getAfOrderList()) {
            if (null == uocAfterOrderConfirmOrRefuseReqItemBo.getOrderId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID为空");
            }
            if (null == uocAfterOrderConfirmOrRefuseReqItemBo.getAfOrderId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参售后单ID为空");
            }
        }
    }
}
