package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.service.order.bo.UocCancelOrderBo;
import com.tydic.dyc.oc.service.order.bo.UocCancelOrderServiceReqBo;
import com.tydic.dyc.oc.service.order.bo.UocCancelOrderServiceReqCancelBo;
import com.tydic.dyc.oc.service.order.bo.UocCancelOrderServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@HTServiceImpl
public class UocCancelOrderServiceImpl implements UocCancelOrderService{

    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Override
    public UocCancelOrderServiceRspBo cancelOrder(UocCancelOrderServiceReqBo reqBo) {
        val(reqBo);
        UocCancelOrderServiceRspBo uocCancelOrderServiceRspBo = UocRu.success(UocCancelOrderServiceRspBo.class);
        for (UocCancelOrderServiceReqCancelBo uocCancelOrderServiceReqCancelBo : reqBo.getCancelList()) {
            UocOrderDo uocOrderDo = new UocOrderDo();
            uocOrderDo.setOrderId(uocCancelOrderServiceReqCancelBo.getOrderId());
            uocOrderDo.setCancelReason(uocCancelOrderServiceReqCancelBo.getCancelReason());
            uocOrderDo.setOrderState(UocStateConstants.Order.ZD_SP_QX);
            iUocOrderModel.updateOrderState(uocOrderDo);
        }
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderIdList(reqBo.getCancelList().stream().map(UocCancelOrderServiceReqCancelBo::getOrderId).collect(Collectors.toList()));
        List<UocSaleOrderDo> saleOrderList = iUocSaleOrderModel.getSaleOrderList(uocSaleOrderQryBo);
        List<UocCancelOrderBo> uocCancelOrderBos = UocRu.jsl(saleOrderList, UocCancelOrderBo.class);
        uocCancelOrderServiceRspBo.setUocCancelOrderBoList(uocCancelOrderBos);
        UocOrderProcInstQryBo uocOrderProcInstQryBo = new UocOrderProcInstQryBo();
        uocOrderProcInstQryBo.setObjIdList(uocCancelOrderBos.stream().map(UocCancelOrderBo::getSaleOrderId).collect(Collectors.toList()));
        uocOrderProcInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        List<UocOrderProcInst> uocOrderProcInsts = iUocOrderModel.qryOrderProcInstList(uocOrderProcInstQryBo);
        if(!CollectionUtils.isEmpty(uocOrderProcInsts)){
            Map<Long, UocOrderProcInst> uocOrderProcInstMap = uocOrderProcInsts.stream().collect(Collectors.toMap(UocOrderProcInst::getObjId, o -> o));
            for (UocCancelOrderBo uocCancelOrderBo : uocCancelOrderBos) {
                UocOrderProcInst uocOrderProcInst = uocOrderProcInstMap.get(uocCancelOrderBo.getSaleOrderId());
                if(null != uocOrderProcInst) {
                    uocCancelOrderBo.setProcInstId(uocOrderProcInst.getProcInstId());
                }
            }
        }
        return uocCancelOrderServiceRspBo;
    }

    private void val(UocCancelOrderServiceReqBo reqBo) {
        if(null == reqBo){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if(CollectionUtils.isEmpty(reqBo.getCancelList())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单信息不能为空");
        }
        for (UocCancelOrderServiceReqCancelBo uocCancelOrderServiceReqCancelBo : reqBo.getCancelList()) {
            if(null == uocCancelOrderServiceReqCancelBo){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
            }
            if(null == uocCancelOrderServiceReqCancelBo.getOrderId()){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单id不能为空");
            }
        }
    }
}
