package com.tydic.dyc.oc.service.common;

import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.service.common.bo.UocOrderTaskInstBo;
import com.tydic.dyc.oc.service.common.bo.UocQryTaskInstReqBo;
import com.tydic.dyc.oc.service.common.bo.UocQryTaskInstRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题:UocQryTaskInstServiceImpl
 * 说明:TODO
 * 时间:2022/6/17 11:05
 * 作者:代愿愿
 */
@HTServiceImpl
public class UocQryTaskInstServiceImpl implements UocQryTaskInstService {
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Override
    public UocQryTaskInstRspBo qryTaskInst(UocQryTaskInstReqBo reqBo) {
        UocOrderTaskInst uocOrderTaskInst = new  UocOrderTaskInst();
        uocOrderTaskInst.setOrderId(reqBo.getOrderId());
        uocOrderTaskInst.setObjId(reqBo.getObjId());
        uocOrderTaskInst.setObjType(reqBo.getObjType());
        List<UocOrderTaskInst>  uocOrderTaskInsts = iUocCommonModel.qryTaskInst(uocOrderTaskInst);
        List<UocOrderTaskInstBo> taskInst = UocRu.jsl(uocOrderTaskInsts,UocOrderTaskInstBo.class);
        UocQryTaskInstRspBo rspBO = new UocQryTaskInstRspBo();
        rspBO.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        rspBO.setTaskInst(taskInst);
        return rspBO;
    }
}
