package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderSupplierConfirmReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderSupplierConfirmRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：类名称:UocAfterOrderSupplierConfirmServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/5/13 15:20
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
public class UocAfterOrderSupplierConfirmServiceImpl implements UocAfterOrderSupplierConfirmService{
    @Autowired
    private IUocAfOrderModel afOrderModel;

    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Override
    public UocAfterOrderSupplierConfirmRspBo dealAfterOrderSupplierConfirm(UocAfterOrderSupplierConfirmReqBo reqBo) {
        UocAfterOrderSupplierConfirmRspBo rspBo = new UocAfterOrderSupplierConfirmRspBo();
        //参数校验
        validateArg(reqBo);
        afOrderModel.confirmAfOrderState(reqBo, reqBo.getConfirmflag(),rspBo);

        // 提交任务
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(reqBo.getTaskId());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(11111l);
        uocCommonDo.setOrderId(reqBo.getOrderId());
        iUocCommonModel.dealTask(uocCommonDo);

        return rspBo;
    }

    private void validateArg(UocAfterOrderSupplierConfirmReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocAfterOrderSupplierConfirmReqBo]不能为空");
        }
    }

}
