package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelDetailBo;
import com.tydic.dyc.oc.service.saleorder.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Objects;

/**
 * 标题:UocSaleOrderSingleQryServiceImpl
 * 说明:
 * 时间:2022/2/25 10:29
 * 作者:田坤林
 */
@HTServiceImpl
public class UocSaleOrderSingleQryServiceImpl implements UocSaleOrderSingleQryService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocSaleOrderSingleQryServiceRspBo qrySaleOrder(UocSaleOrderSingleQryServiceReqBo reqBo) {
        //入参校验
        validateParam(reqBo);
        UocSaleOrderSingleQryServiceRspBo rspBo = UocRu.success(UocSaleOrderSingleQryServiceRspBo.class);
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(UocRu.js(reqBo, UocSaleOrderQryBo.class));
        if (Objects.isNull(uocSaleOrderDo)) {
            return rspBo;
        }
        UocSaleOrderSingleQryServiceRspDetailBo rspDetailBo = UocRu.js(uocSaleOrderDo, UocSaleOrderSingleQryServiceRspDetailBo.class);
        List<UocSaleOrderMap> saleOrderExpandList = iUocSaleOrderModel.getSaleOrderExpandList(UocRu.js(reqBo, UocSaleOrderMapQryBo.class));
        if (ObjectUtil.isNotEmpty(saleOrderExpandList)) {
            rspDetailBo.setSaleOrderExtList(UocRu.jsl(saleOrderExpandList, UocBaseExtParallelDetailBo.class));
        }
        rspBo.setSaleOrderBo(rspDetailBo);
        return rspBo;
    }

    private void validateParam(UocSaleOrderSingleQryServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参不能为空");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单ID不能为空");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单ID不能为空");
        }
    }
}


