/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderItemQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocAfterOrderCancelService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCancelReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCancelRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocAfterOrderCancelService"})
public class UocAfterOrderCancelServiceImpl
implements UocAfterOrderCancelService {
    @Autowired
    private IUocAfOrderModel afOrderModel;
    @Autowired
    private IUocInspOrderModel inspOrderModel;
    @Autowired
    private IUocSaleOrderModel saleOrderModel;
    @Autowired
    private IUocOrderModel orderModel;
    @Autowired
    private IUocShipOrderModel shipOrderModel;

    @PostMapping(value={"cancelAfterOrder"})
    public UocAfterOrderCancelRspBo cancelAfterOrder(@RequestBody UocAfterOrderCancelReqBo reqBo) {
        UocAfterOrderCancelRspBo rspBo = UocRu.success(UocAfterOrderCancelRspBo.class);
        this.validateArg(reqBo);
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setOrderId(reqBo.getOrderId());
        uocAfOrderQryBo.setAfOrderId(reqBo.getAfOrderId());
        UocAfOrder uocAfOrder = this.afOrderModel.getAfOrderById(uocAfOrderQryBo);
        if (ObjectUtil.isEmpty((Object)uocAfOrder)) {
            throw new BaseBusinessException("100001", "\u67e5\u8be2\u552e\u540e\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        Integer servType = uocAfOrder.getServType();
        Integer servState = uocAfOrder.getServState();
        if (!UocDicConstant.SERVICE_STATE.SUMIT_APPLICATION.equals(servState)) {
            throw new BaseBusinessException("100001", "\u552e\u540e\u5355\u4e0d\u53ef\u53d6\u6d88");
        }
        UocAfOrderDo uocAfOrderDo = new UocAfOrderDo();
        uocAfOrderDo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderDo.setOrderId(reqBo.getOrderId());
        uocAfOrderDo.setServState(UocDicConstant.SERVICE_STATE.CANCEL);
        uocAfOrderDo.setPayState(UocDicConstant.PAY_AFTER_STATE.CANCELED);
        uocAfOrderDo.setUpdateTime(new Date());
        uocAfOrderDo.setCancelTime(new Date());
        uocAfOrderDo.setCancelOperId(String.valueOf(reqBo.getUserId()));
        uocAfOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        this.afOrderModel.modifyAfOrderState(uocAfOrderDo);
        List<UocAfOrderItem> afOrderItemList = this.afOrderModel.getAfOrderItemList(UocRu.js(reqBo, UocAfOrderItemQryBo.class));
        if (UocDicConstant.SERVICE_STATE.REMARK_COMPLATE.equals(servState) && UocConstant.AFTERORDER_SERVTYPE.RETURN.equals(servType)) {
            this.updateItemAndShipReturnCount(afOrderItemList, reqBo, rspBo);
        } else {
            this.updateItemAndShipAfterServringCount(afOrderItemList, reqBo, rspBo);
        }
        UocOrderStakeholderQryBo uocOrderStakeholderQryBo = new UocOrderStakeholderQryBo();
        uocOrderStakeholderQryBo.setOrderId(reqBo.getOrderId());
        List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBos = this.orderModel.qryStakeholderList(uocOrderStakeholderQryBo);
        String supId = uocOrderStakeholderQryBos.get(0).getSupId();
        UocAfOrderItem uocAfOrderItem = afOrderItemList.get(0);
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(uocAfOrderItem.getOrderId());
        uocShipOrderItemQryBo.setShipOrderItemId(uocAfOrderItem.getShipItemId());
        List<UocShipOrderItem> shipOrderItemList = this.shipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);
        rspBo.setSaleOrderId(uocAfOrder.getSaleOrderId());
        rspBo.setShipOrderId(shipOrderItemList.get(0).getShipOrderId());
        rspBo.setExtAfId(uocAfOrder.getExtAfId());
        rspBo.setSupId(supId);
        return rspBo;
    }

    private void updateItemAndShipAfterServringCount(List<UocAfOrderItem> afOrderItemList, UocAfterOrderCancelReqBo reqBo, UocAfterOrderCancelRspBo rspBo) {
        for (UocAfOrderItem uocAfOrderItem : afOrderItemList) {
            Long inspItemId = uocAfOrderItem.getInspItemId();
            Long orderItemId = uocAfOrderItem.getSaleItemId();
            Long orderId = uocAfOrderItem.getOrderId();
            Long shipItemId = uocAfOrderItem.getShipItemId();
            BigDecimal returnCount = uocAfOrderItem.getReturnCount();
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setOrderId(orderId);
            uocSaleOrderItem.setSaleOrderItemId(orderItemId);
            uocSaleOrderItem.setAfterServingCount(returnCount.negate());
            uocSaleOrderItem.setUpdateTime(new Date());
            uocSaleOrderItem.setUpdateOperId(ObjectUtil.isEmpty((Object)reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
            this.saleOrderModel.modifySaleOrderItemAfterServingCount(uocSaleOrderItem);
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            uocShipOrderItem.setOrderId(orderId);
            uocShipOrderItem.setShipOrderItemId(shipItemId);
            uocShipOrderItem.setAfterServingCount(returnCount.negate());
            uocShipOrderItem.setUpdateTime(new Date());
            uocShipOrderItem.setUpdateOperId(ObjectUtil.isEmpty((Object)reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
            this.shipOrderModel.modifyShipOrderItemAfterServingCount(uocShipOrderItem);
        }
    }

    private void updateItemAndShipReturnCount(List<UocAfOrderItem> uocAfOrderItemList, UocAfterOrderCancelReqBo reqBo, UocAfterOrderCancelRspBo rspBo) {
        for (UocAfOrderItem uocAfOrderItem : uocAfOrderItemList) {
            Long inspItemId = uocAfOrderItem.getInspItemId();
            Long orderItemId = uocAfOrderItem.getSaleItemId();
            Long orderId = uocAfOrderItem.getOrderId();
            Long shipItemId = uocAfOrderItem.getShipItemId();
            BigDecimal returnCount = uocAfOrderItem.getReturnCount();
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setOrderId(orderId);
            uocSaleOrderItem.setSaleOrderItemId(orderItemId);
            uocSaleOrderItem.setReturnCount(returnCount.negate());
            uocSaleOrderItem.setUpdateTime(new Date());
            uocSaleOrderItem.setUpdateOperId(ObjectUtil.isEmpty((Object)reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
            this.saleOrderModel.modifySaleOrderItemReturningCount(uocSaleOrderItem);
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            uocShipOrderItem.setOrderId(orderId);
            uocShipOrderItem.setShipOrderItemId(shipItemId);
            uocShipOrderItem.setReturnCount(returnCount.negate());
            uocShipOrderItem.setUpdateTime(new Date());
            uocShipOrderItem.setUpdateOperId(ObjectUtil.isEmpty((Object)reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
            this.shipOrderModel.modifyShipOrderItemReturningCount(uocShipOrderItem);
        }
    }

    private void validateArg(UocAfterOrderCancelReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocAfterOrderCancelReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getAfOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u552e\u540e\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

