/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.impl.UocAfOrderModelImpl;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderObjQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.service.domainservice.UocAfterOrderFinishConfirmService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderFinishConfirmReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderFinishConfirmRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocAfterOrderFinishConfirmService"})
public class UocAfterOrderFinishConfirmServiceImpl
implements UocAfterOrderFinishConfirmService {
    @Autowired
    private IUocAfOrderModel afOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private UocAfOrderModelImpl uocAfOrderModel;

    @PostMapping(value={"finishConfirmAfterOrder"})
    public UocAfterOrderFinishConfirmRspBo finishConfirmAfterOrder(@RequestBody UocAfterOrderFinishConfirmReqBo reqBo) {
        this.val(reqBo);
        UocAfOrderDo uocAfOrderDo = new UocAfOrderDo();
        uocAfOrderDo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderDo.setOrderId(reqBo.getOrderId());
        uocAfOrderDo.setServState(UocDicConstant.SERVICE_STATE.COMPLATE);
        if (null != reqBo.getFlag() && reqBo.getFlag() == 1) {
            uocAfOrderDo.setServState(UocDicConstant.SERVICE_STATE.REMARK_COMPLATE);
        }
        uocAfOrderDo.setFinishTime(new Date());
        this.afOrderModel.modifyAfOrderState(uocAfOrderDo);
        if (null != reqBo.getFlag() && reqBo.getFlag() == 1) {
            this.updateAfteringCount(reqBo);
        }
        UocCommonDo uocCommonDo = new UocCommonDo();
        ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(reqBo.getTaskId());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(11111L);
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
        UocAfterOrderFinishConfirmRspBo rspBo = UocRu.success(UocAfterOrderFinishConfirmRspBo.class);
        this.resolveSyncRsp(reqBo, rspBo);
        return rspBo;
    }

    private void val(UocAfterOrderFinishConfirmReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getAfOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u552e\u540e\u5355ID\u4e3a\u7a7a");
        }
    }

    private void updateAfteringCount(UocAfterOrderFinishConfirmReqBo reqBo) {
        this.uocAfOrderModel.modifyAfterOrderCount(reqBo);
    }

    private void resolveSyncRsp(UocAfterOrderFinishConfirmReqBo reqBo, UocAfterOrderFinishConfirmRspBo rspBo) {
        UocAfOrderQryBo qryBo = new UocAfOrderQryBo();
        qryBo.setAfOrderId(reqBo.getAfOrderId());
        UocAfOrder afOrder = this.uocAfOrderModel.getAfOrderById(qryBo);
        if (afOrder == null) {
            return;
        }
        UocAfOrderObjQryBo qryObj = new UocAfOrderObjQryBo();
        qryObj.setAfOrderId(reqBo.getAfOrderId());
        qryObj.setSaleOrderId(afOrder.getSaleOrderId());
        List<UocAfOrderObj> afOrderObjList = this.uocAfOrderModel.getAfOrderObjList(qryObj);
        if (CollectionUtils.isEmpty(afOrderObjList)) {
            return;
        }
        List collect = afOrderObjList.stream().map(UocAfOrderObj::getShipOrderId).distinct().collect(Collectors.toList());
        rspBo.setSaleOrderId(afOrder.getSaleOrderId());
        rspBo.setShipOrderIdList(collect);
    }
}

