/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class EventConsumerOrderCommit
implements EventConsumer {
    private static final Logger log = LoggerFactory.getLogger(EventConsumerOrderCommit.class);
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocAfOrderModel uocAfOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerOrderCommit->{}", (Object)JSON.toJSONString(map));
        ArrayList<IUocEsSyncQryEventReqBo> retList = new ArrayList<IUocEsSyncQryEventReqBo>();
        Long orderId = UocRu.parseLong(map.get("orderId"));
        Long sysTenantId = UocRu.parseLong(map.get("sysTenantId"));
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> nextTaskInfos = UocRu.jsl(map.get("nextTaskInfos"), UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo.class);
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> completeTaskInfos = UocRu.jsl(map.get("completeTaskInfos"), UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo.class);
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo updateTaskCandidate = UocRu.js(map.get("updateTaskCandidate"), UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo.class);
        if (updateTaskCandidate != null && StringUtils.hasText((String)updateTaskCandidate.getTaskId())) {
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo bo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            bo.setTaskId(updateTaskCandidate.getTaskId());
            nextTaskInfos.add(bo);
        }
        nextTaskInfos.addAll(completeTaskInfos);
        nextTaskInfos.forEach(taskBo -> {
            Integer objType = taskBo.getBusiObjType();
            Long objId = taskBo.getBusiObjId();
            if (ObjectUtil.isEmpty((Object)objType)) {
                UocOrderTaskInstQryBo uocOrderTaskInstQryBo = new UocOrderTaskInstQryBo();
                uocOrderTaskInstQryBo.setTaskInstId(taskBo.getTaskId());
                uocOrderTaskInstQryBo.setSysTenantId(sysTenantId);
                List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(uocOrderTaskInstQryBo);
                UocOrderTaskInst uocOrderTaskInst = uocOrderTaskInsts.get(0);
                objType = uocOrderTaskInst.getObjType();
                objId = uocOrderTaskInst.getObjId();
            }
            if (UocDicConstant.OBJ_TYPE.APPROVE.equals(objType)) {
                UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
                uocApprovalObjQryBo.setOrderId(orderId);
                uocApprovalObjQryBo.setAuditOrderId(objId);
                uocApprovalObjQryBo.setSysTenantId(sysTenantId);
                List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
                if (CollectionUtil.isNotEmpty(uocApprovalObjs)) {
                    UocApprovalObj uocApprovalObj = uocApprovalObjs.get(0);
                    objType = uocApprovalObj.getObjType();
                    objId = Long.valueOf(uocApprovalObj.getObjId());
                }
            }
            if (UocDicConstant.OBJ_TYPE.ORDER.equals(objType)) {
                this.addSyncParam(retList, orderId, objId, this.uocIndexConfig.getOrderIndex(), sysTenantId);
            }
            if (UocDicConstant.OBJ_TYPE.SALE.equals(objType)) {
                this.addSyncParam(retList, orderId, objId, this.uocIndexConfig.getSaleOrderIndex(), sysTenantId);
            }
            if (UocDicConstant.OBJ_TYPE.SHIP.equals(objType)) {
                UocShipOrderDo shipOrderDo = this.getShipOrderDo(orderId, objId, sysTenantId);
                if (null != shipOrderDo) {
                    this.addSyncParam(retList, orderId, shipOrderDo.getSaleOrderId(), this.uocIndexConfig.getSaleOrderIndex(), sysTenantId);
                }
                this.addSyncParam(retList, orderId, objId, this.uocIndexConfig.getShipOrderIndex(), sysTenantId);
            }
            if (UocDicConstant.OBJ_TYPE.INSPECTION.equals(objType)) {
                UocInspOrderDo inspOrderMain = this.getInspOrderDo(orderId, objId, sysTenantId);
                if (null != inspOrderMain) {
                    this.addSyncParam(retList, orderId, inspOrderMain.getSaleOrderId(), this.uocIndexConfig.getSaleOrderIndex(), sysTenantId);
                    if (!CollectionUtils.isEmpty(inspOrderMain.getUocShipInspRelList())) {
                        inspOrderMain.getUocShipInspRelList().forEach(uocShipInspRel -> {
                            if (null != uocShipInspRel.getShipOrderId()) {
                                this.addSyncParam(retList, orderId, uocShipInspRel.getShipOrderId(), this.uocIndexConfig.getShipOrderIndex(), sysTenantId);
                            }
                        });
                    }
                }
                this.addSyncParam(retList, orderId, objId, this.uocIndexConfig.getInspOrderIndex(), sysTenantId);
            }
            if (UocDicConstant.OBJ_TYPE.AFTER.equals(objType)) {
                this.addSyncParam(retList, orderId, objId, this.uocIndexConfig.getAfOrderIndex(), sysTenantId);
                UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
                uocAfOrderQryBo.setOrderId(orderId);
                uocAfOrderQryBo.setAfOrderId(objId);
                uocAfOrderQryBo.setSysTenantId(sysTenantId);
                UocAfOrder afOrderById = this.uocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
                Long saleOrderId = afOrderById.getSaleOrderId();
                this.addSyncParam(retList, orderId, saleOrderId, this.uocIndexConfig.getSaleOrderIndex(), sysTenantId);
            }
            if (UocDicConstant.OBJ_TYPE.CHNG.equals(objType)) {
                this.addSyncParam(retList, orderId, objId, this.uocIndexConfig.getChngOrderIndex(), sysTenantId);
            }
        });
        log.info("\u5355\u636e\u63d0\u4ea4\u51fa\u53c2:{}", (Object)JSON.toJSONString(retList));
        return retList;
    }

    private UocShipOrderDo getShipOrderDo(Long orderId, Long objId, Long sysTenantId) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(orderId);
        uocShipOrderQryBo.setShipOrderId(objId);
        uocShipOrderQryBo.setSysTenantId(sysTenantId);
        return this.iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
    }

    private void addSyncParam(List<IUocEsSyncQryEventReqBo> retList, Long orderId, Long objId, String indexName, Long sysTenantId) {
        IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
        syncQryReqBo.setObjId(objId);
        syncQryReqBo.setOrderId(orderId);
        syncQryReqBo.setSysTenantId(sysTenantId);
        this.addEvent(retList, syncQryReqBo, indexName);
    }

    private UocInspOrderDo getInspOrderDo(Long orderId, Long objId, Long sysTenantId) {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setOrderId(orderId);
        uocInspOrderQryBo.setInspOrderId(objId);
        uocInspOrderQryBo.setSysTenantId(sysTenantId);
        return this.iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
    }

    private void addEvent(List<IUocEsSyncQryEventReqBo> retList, IUocEsSyncQryReqBo syncQryReqBo, String index) {
        ArrayList<IUocEsSyncQryReqBo> esSyncQryReqBoList = new ArrayList<IUocEsSyncQryReqBo>();
        esSyncQryReqBoList.add(syncQryReqBo);
        IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
        eventReqBo.setIndexName(index);
        eventReqBo.setDataList(esSyncQryReqBoList);
        retList.add(eventReqBo);
    }

    @Override
    public String getEvent() {
        return "UOCE_ORDER_COMMIT";
    }
}

