package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocEventConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 标题:EventConsumerCommonSyncSale
 * 说明:单据提交时解析参数
 * 时间:2022/3/10 20:10
 * 作者:罗有
 */
@Slf4j
@Component
public class EventConsumerOrderCommit implements EventConsumer {
    @Autowired
    private UocIndexConfig uocIndexConfig;

//    @Autowired
//    private IUocImplOrderModel iUocImplOrderModel;

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;


    @Autowired
    private IUocAfOrderModel uocAfOrderModel;

    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;



    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerOrderCommit->{}", JSON.toJSONString(map));

        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        Long orderId = UocRu.parseLong(map.get("orderId"));
        Long sysTenantId = UocRu.parseLong(map.get("sysTenantId"));
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> nextTaskInfos = UocRu.jsl(map.get("nextTaskInfos"),UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo.class);
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> completeTaskInfos = UocRu.jsl(map.get("completeTaskInfos"),UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo.class);
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo updateTaskCandidate = UocRu.js(map.get("updateTaskCandidate"),UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo.class);
        if(updateTaskCandidate!=null && StringUtils.hasText(updateTaskCandidate.getTaskId())){
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo bo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            bo.setTaskId(updateTaskCandidate.getTaskId());
            nextTaskInfos.add(bo);
        }
        nextTaskInfos.addAll(completeTaskInfos);
        nextTaskInfos.forEach(taskBo->{
            Integer objType = taskBo.getBusiObjType();
            Long objId = taskBo.getBusiObjId();
            if (ObjectUtil.isEmpty(objType)) {
                UocOrderTaskInstQryBo uocOrderTaskInstQryBo = new UocOrderTaskInstQryBo();
                uocOrderTaskInstQryBo.setTaskInstId(taskBo.getTaskId());
                uocOrderTaskInstQryBo.setSysTenantId(sysTenantId);
                List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(uocOrderTaskInstQryBo);
                UocOrderTaskInst uocOrderTaskInst = uocOrderTaskInsts.get(0);
                objType = uocOrderTaskInst.getObjType();
                objId = uocOrderTaskInst.getObjId();
            }

            if (UocDicConstant.OBJ_TYPE.APPROVE.equals(objType)) {
                UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
                uocApprovalObjQryBo.setOrderId(orderId);
                uocApprovalObjQryBo.setAuditOrderId(objId);
                uocApprovalObjQryBo.setSysTenantId(sysTenantId);
                List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
                if (CollectionUtil.isNotEmpty(uocApprovalObjs)) {
                    UocApprovalObj uocApprovalObj = uocApprovalObjs.get(0);
                    objType = uocApprovalObj.getObjType();
                    objId = Long.valueOf(uocApprovalObj.getObjId());
                }
            }
            if (UocDicConstant.OBJ_TYPE.ORDER.equals(objType)) {
                addSyncParam(retList, orderId, objId, uocIndexConfig.getOrderIndex(),sysTenantId);
            }
            if (UocDicConstant.OBJ_TYPE.SALE.equals(objType)) {
                addSyncParam(retList, orderId, objId, uocIndexConfig.getSaleOrderIndex(),sysTenantId);
            }
            if (UocDicConstant.OBJ_TYPE.SHIP.equals(objType)) {
                UocShipOrderDo shipOrderDo = getShipOrderDo(orderId, objId,sysTenantId);
                if (null != shipOrderDo) {
                    addSyncParam(retList, orderId, shipOrderDo.getSaleOrderId(), uocIndexConfig.getSaleOrderIndex(),sysTenantId);
                }
                addSyncParam(retList, orderId, objId, uocIndexConfig.getShipOrderIndex(),sysTenantId);
            }
            if (UocDicConstant.OBJ_TYPE.INSPECTION.equals(objType)) {
                UocInspOrderDo inspOrderMain = getInspOrderDo(orderId, objId,sysTenantId);
                if (null != inspOrderMain) {
                    addSyncParam(retList, orderId, inspOrderMain.getSaleOrderId(), uocIndexConfig.getSaleOrderIndex(),sysTenantId);

                    if (!CollectionUtils.isEmpty(inspOrderMain.getUocShipInspRelList())) {
                        inspOrderMain.getUocShipInspRelList().forEach(uocShipInspRel -> {
                            if (null != uocShipInspRel.getShipOrderId()) {
                                addSyncParam(retList, orderId, uocShipInspRel.getShipOrderId(), uocIndexConfig.getShipOrderIndex(),sysTenantId);
                            }
                        });
                    }
                }
                addSyncParam(retList, orderId, objId, uocIndexConfig.getInspOrderIndex(),sysTenantId);
            }

            if (UocDicConstant.OBJ_TYPE.AFTER.equals(objType)) {
                addSyncParam(retList, orderId, objId, uocIndexConfig.getAfOrderIndex(),sysTenantId);
                //销售单
                UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
                uocAfOrderQryBo.setOrderId(orderId);
                uocAfOrderQryBo.setAfOrderId(objId);
                uocAfOrderQryBo.setSysTenantId(sysTenantId);
                UocAfOrder afOrderById = uocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
                Long saleOrderId = afOrderById.getSaleOrderId();
                addSyncParam(retList, orderId, saleOrderId, uocIndexConfig.getSaleOrderIndex(),sysTenantId);
            }

            if (UocDicConstant.OBJ_TYPE.CHNG.equals(objType)) {
                //异常变更
                addSyncParam(retList, orderId, objId, uocIndexConfig.getChngOrderIndex(),sysTenantId);
            }
        });


        log.info("单据提交出参:{}", JSON.toJSONString(retList));
        return retList;
    }

//    private UocImplOrderDo getImplOrderDo(Long orderId, Long objId) {
//        UocImplOrderQryBo uocImplOrderQryBo = new UocImplOrderQryBo();
//        uocImplOrderQryBo.setOrderId(orderId);
//        uocImplOrderQryBo.setImplOrderId(objId);
//        return iUocImplOrderModel.getImplOrderMain(uocImplOrderQryBo);
//    }

    private UocShipOrderDo getShipOrderDo(Long orderId, Long objId, Long sysTenantId) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(orderId);
        uocShipOrderQryBo.setShipOrderId(objId);
        uocShipOrderQryBo.setSysTenantId(sysTenantId);
        return iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
    }

    private void addSyncParam(List<IUocEsSyncQryEventReqBo> retList, Long orderId, Long objId, String indexName,Long sysTenantId) {
        IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
        syncQryReqBo.setObjId(objId);
        syncQryReqBo.setOrderId(orderId);
        syncQryReqBo.setSysTenantId(sysTenantId);
        addEvent(retList, syncQryReqBo, indexName);
    }

    private UocInspOrderDo getInspOrderDo(Long orderId, Long objId, Long sysTenantId) {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setOrderId(orderId);
        uocInspOrderQryBo.setInspOrderId(objId);
        uocInspOrderQryBo.setSysTenantId(sysTenantId);
        return iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
    }

    private void addEvent(List<IUocEsSyncQryEventReqBo> retList, IUocEsSyncQryReqBo syncQryReqBo, String index) {
        List<IUocEsSyncQryReqBo> esSyncQryReqBoList = new ArrayList<>();
        esSyncQryReqBoList.add(syncQryReqBo);
        IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
        eventReqBo.setIndexName(index);
        eventReqBo.setDataList(esSyncQryReqBoList);
        retList.add(eventReqBo);
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOCE_ORDER_COMMIT_SYNC;
    }
}


