package com.tydic.dyc.oc.components.event.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocEventConstant;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 标题:EventConsumerShipArrivaConfirmOrRefuse
 * 说明:发货单 到货确认/拒收
 * 时间:2022/3/10 20:10
 * 作者:罗有
 */
@Component
@Slf4j

public class EventConsumerShipArrivaConfirmOrRefuse implements EventConsumer {
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerShipArrivaConfirmOrRefuse->{}", JSON.toJSONString(map));

        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        Long orderId = UocRu.parseLong(map.get("orderId"));
        Long saleOrderId = UocRu.parseLong(map.get("saleOrderId"));
//        Long implOrderId = UocRu.parseLong(map.get("implOrderId"));4
        Long sysTenantId = UocRu.parseLong(map.get("sysTenantId"));
        Object shipOrderIdObj = map.get("shipOrderIdList");
        List<Long> shipOrderIdList = UocRu.castList(shipOrderIdObj, Long.class);
        List<IUocEsSyncQryReqBo> shipList = new ArrayList<>();
        shipOrderIdList.forEach(shipOrderId -> {
            IUocEsSyncQryReqBo shipSyncQryReqBo = new IUocEsSyncQryReqBo();
            shipSyncQryReqBo.setOrderId(orderId);
            shipSyncQryReqBo.setObjId(shipOrderId);
            shipSyncQryReqBo.setSysTenantId(sysTenantId);
            shipList.add(shipSyncQryReqBo);
        });
        IUocEsSyncQryEventReqBo shipEventReqBo = new IUocEsSyncQryEventReqBo();
        shipEventReqBo.setIndexName(uocIndexConfig.getShipOrderIndex());
        shipEventReqBo.setDataList(shipList);
        retList.add(shipEventReqBo);

//        List<IUocEsSyncQryReqBo> implList = new ArrayList<>();
//        IUocEsSyncQryReqBo implSyncQryReqBo = new IUocEsSyncQryReqBo();
//        implSyncQryReqBo.setOrderId(orderId);
//        implSyncQryReqBo.setObjId(implOrderId);
//        implList.add(implSyncQryReqBo);
//        IUocEsSyncQryEventReqBo implEventReqBo = new IUocEsSyncQryEventReqBo();
//        implEventReqBo.setIndexName(uocIndexConfig.getImplOrderIndex());
//        implEventReqBo.setDataList(implList);
//        retList.add(implEventReqBo);

        List<IUocEsSyncQryReqBo> saleList = new ArrayList<>();
        IUocEsSyncQryReqBo saleSyncQryReqBo = new IUocEsSyncQryReqBo();
        saleSyncQryReqBo.setOrderId(orderId);
        saleSyncQryReqBo.setObjId(saleOrderId);
        saleSyncQryReqBo.setSysTenantId(sysTenantId);
        saleList.add(saleSyncQryReqBo);
        IUocEsSyncQryEventReqBo saleEventReqBo = new IUocEsSyncQryEventReqBo();
        saleEventReqBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleEventReqBo.setDataList(saleList);
        retList.add(saleEventReqBo);

        return retList;
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOCE_SHIP_ARRIVA_CONFIRM_OR_REFUSE;
    }


}


