package com.tydic.dyc.oc.components.event.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocEventConstant;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题：EventConsumerSyncInspTransaction
 * 说明：验收单同步事件
 * 时间：2022/4/7 10:02
 *
 * @author 文乐
 */
@Component
@Slf4j

public class EventConsumerSyncInspTransaction implements EventConsumer {

    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerSyncInspTransaction->{}", JSON.toJSONString(map));

        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        Long orderId = Long.valueOf((String) map.get("orderId"));
        Long sysTenantId = UocRu.parseLong(map.get("sysTenantId"));
        JSONObject supSignInfo = (JSONObject) map.get("jsonObj");
        Long inspOrderId = Long.valueOf((String) map.get("inspOrderId"));

        List<IUocEsSyncQryReqBo> inspList = new ArrayList<>();
        IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
        syncQryReqBo.setOrderId(orderId);
        syncQryReqBo.setObjId(inspOrderId);
        syncQryReqBo.setSysTenantId(sysTenantId);
        syncQryReqBo.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        syncQryReqBo.setJsonObj(supSignInfo);
        inspList.add(syncQryReqBo);

        IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
        eventReqBo.setIndexName(uocIndexConfig.getTransactionIndex());
        eventReqBo.setDataList(inspList);
        retList.add(eventReqBo);

        return retList;
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOC_INSP_TRANSACTION_SYNC;
    }
}
