package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocConfInspectionUse;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;
import com.tydic.dyc.oc.service.order.bo.UocConfInspectionUseRspBo;
import com.tydic.dyc.oc.service.order.bo.UocQryInspectionConfigUseListReqBo;
import com.tydic.dyc.oc.service.order.bo.UocQryInspectionConfigUseListRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题:UocQryInspectionConfigListServiceImpl
 * 说明:TODO
 * 时间:2022/4/8 17:13
 * 作者:代愿愿
 * 作者:代愿愿
 */
@HTServiceImpl
public class UocQryInspectionConfigUseListServiceImpl implements UocQryInspectionConfigUseListService {
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Override
    public UocQryInspectionConfigUseListRspBo qryInspectionConfigUseList(UocQryInspectionConfigUseListReqBo reqBo) {
        UocConfInspectionUse uocConfInspectionUse = UocRu.js(reqBo,UocConfInspectionUse.class);
        List<UocConfInspectionUse>  uocConfInspectionUses = iUocOrderModel.qryInspectionConfigUseList(uocConfInspectionUse);
        UocQryInspectionConfigUseListRspBo rspBo =  UocRu.success(UocQryInspectionConfigUseListRspBo.class);
        if(!CollectionUtils.isEmpty(uocConfInspectionUses)) {
            List<UocConfInspectionUseRspBo> rows = UocRu.jsl(uocConfInspectionUses, UocConfInspectionUseRspBo.class);
            // 转义
            List<String> pCodeList = new ArrayList<>();
            pCodeList.add(UocConstant.INSPECTION_BUSI_TYPE);
            pCodeList.add(UocConstant.INSPECTION_TYPE);
            UocSysDictionaryQryBo qryBo = new UocSysDictionaryQryBo();
            qryBo.setPCodes(pCodeList);
            qryBo.setSysTenantId(reqBo.getSysTenantId());
            Map<String, Map<String, String>> dictionaryMap = iUocSysDictionaryModel.getDictionaryMap(qryBo);
            Map<String, String> inspBusiType = dictionaryMap.get(UocConstant.INSPECTION_BUSI_TYPE);
            Map<String, String> inspType = dictionaryMap.get(UocConstant.INSPECTION_TYPE);
            rows.forEach(uocConfInspectionUseRspBo -> {
                uocConfInspectionUseRspBo.setBusiTypeName(inspBusiType.get(uocConfInspectionUseRspBo.getBusiType().toString()));
                uocConfInspectionUseRspBo.setInspectionTypeName(inspType.get(uocConfInspectionUseRspBo.getInspectionType().toString()));
            });
            rspBo.setRows(rows);
        }
        return rspBo;
    }
}
