package com.tydic.dyc.oc.service.shiporder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.shiporder.bo.UocShipOrderArrivaRegistReqBo;
import com.tydic.dyc.oc.service.shiporder.bo.UocShipOrderArrivaRegistRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 描述: 〈领域服务-发货单到货登记 实现〉
 * @author : yuhao
 * @date : 2022/8/1 11:05
 */
@HTServiceImpl
public class UocShipOrderArrivaRegistServiceImpl implements UocShipOrderArrivaRegistService {

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Override
    public UocShipOrderArrivaRegistRspBo dealShipOrderArrivaRegist(UocShipOrderArrivaRegistReqBo reqBo) {
        //参数校验
        this.verifyParam(reqBo);
        //更新发货单信息
        this.updateShipOrderInfos(reqBo);
        //提交发货单任务
        this.submitShipOrderTask(reqBo);

        UocShipOrderArrivaRegistRspBo rspBo = new UocShipOrderArrivaRegistRspBo();
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        rspBo.setSysTenantId(reqBo.getSysTenantId());
        return rspBo;
    }

    /**
     * 提交发货单任务
     * @param reqBo
     */
    private void submitShipOrderTask(UocShipOrderArrivaRegistReqBo reqBo){
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskInfos = new ArrayList<>();
        reqBo.getTaskIds().forEach(taskId->{
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(taskId);
            taskInfos.add(taskBo);
        });
        uocCommonDo.setCompleteTaskInfos(taskInfos);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }

    /**
     * 更新发货单信息
     * @param reqBo
     * @return
     */
    private void updateShipOrderInfos(UocShipOrderArrivaRegistReqBo reqBo) {
        UocShipOrderDo updateUocShipOrderDo = JSONObject.parseObject(JSON.toJSONString(reqBo),UocShipOrderDo.class);
        //设置更新时间
        updateUocShipOrderDo.setUpdateTime(new Date());
        //设置更新人id
        updateUocShipOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        //设置到货登记附件
        if(!CollectionUtils.isEmpty(reqBo.getOrderAccessoryList())){
            List<UocOrderAccessory> orderAccessoryBoList = new ArrayList<>();
            for(Long shipOrderId:reqBo.getShipOrderIdList()){
                for(UocBaseOrderAccessoryAddBo uocBaseOrderAccessoryAddBo:reqBo.getOrderAccessoryList()){
                    UocOrderAccessory uocOrderAccessory = JSONObject.parseObject(JSON.toJSONString(uocBaseOrderAccessoryAddBo),UocOrderAccessory.class);
                    //设置订单id
                    uocOrderAccessory.setOrderId(reqBo.getOrderId());
                    //设置单据类型
                    uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
                    //设置创建时间
                    uocOrderAccessory.setCreateTime(new Date());
                    //设置创建人
                    uocOrderAccessory.setCreateOperId(String.valueOf(reqBo.getUserId()));
                    //设置附件类型
                    uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.ARRIVAL_REGIST);
                    //设置附件id
                    uocOrderAccessory.setId(IdUtil.nextId());
                    //单据id
                    uocOrderAccessory.setObjId(shipOrderId);
                    orderAccessoryBoList.add(uocOrderAccessory);
                }
            }
            updateUocShipOrderDo.setOrderAccessoryBoList(orderAccessoryBoList);
        }
        updateUocShipOrderDo.setShipOrderState(UocStateConstants.ShipOrder.FH_FH_DQR);

        this.iUocShipOrderModel.modifyShipOrderMain(updateUocShipOrderDo);
    }


    /**
     * 参数校验
     * @param reqBo
     */
    private void verifyParam(UocShipOrderArrivaRegistReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }
        if (CollectionUtils.isEmpty(reqBo.getShipOrderIdList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参发货单ID数组不能为空");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID为空");
        }
        if (CollectionUtils.isEmpty(reqBo.getTaskIds())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参发货单任务ID数组不能为空");
        }
    }
}
