package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalLogQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalLog;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.audit.sub.UocAuditOrder;
import com.tydic.dyc.oc.repository.UocAuditOrderRepository;
import com.tydic.dyc.oc.repository.dao.UocApprovalLogMapper;
import com.tydic.dyc.oc.repository.dao.UocApprovalObjMapper;
import com.tydic.dyc.oc.repository.dao.UocAuditOrderMapper;
import com.tydic.dyc.oc.repository.po.UocApprovalLogPo;
import com.tydic.dyc.oc.repository.po.UocApprovalObjPo;
import com.tydic.dyc.oc.repository.po.UocAuditOrderPo;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocAuditOrderRepositoryImpl
 * 说明:
 * 时间:2022/3/10 17:27
 * 作者:田桂银
 */
@Service
public class UocAuditOrderRepositoryImpl implements UocAuditOrderRepository {


    @Autowired
    private UocAuditOrderMapper uocAuditOrderMapper;

    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;

    @Autowired
    private UocApprovalLogMapper uocApprovalLogMapper;


    @Override
    public UocAuditOrderDo saveAudit(UocAuditOrderDo orderDo) {
        UocAuditOrderPo auditPo = UocRu.js(orderDo, UocAuditOrderPo.class);
        uocAuditOrderMapper.insert(auditPo);

        List<UocApprovalObjPo> poList = new ArrayList<>();
        List<UocApprovalObj> approvalObjs = orderDo.getApprovalObjs();
        for (UocApprovalObj approvalObj : approvalObjs) {
            UocApprovalObjPo po = UocRu.js(approvalObj, UocApprovalObjPo.class);
            po.setAuditOrderId(orderDo.getAuditOrderId());
            po.setSysTenantId(orderDo.getSysTenantId());
            po.setSysTenantName(orderDo.getSysTenantName());
            poList.add(po);
        }
        uocApprovalObjMapper.insertBatch(poList);
        if (null != orderDo.getApprovalLog()) {
            UocApprovalLogPo js = UocRu.js(orderDo.getApprovalLog(), UocApprovalLogPo.class);
            js.setSysTenantId(orderDo.getSysTenantId());
            js.setSysTenantName(orderDo.getSysTenantName());
            uocApprovalLogMapper.insert(js);
        }
        return orderDo;
    }

    @Override
    public UocAuditOrderDo updateApprove(UocAuditOrderDo updateDo) {
        UocAuditOrderPo set = UocRu.js(updateDo, UocAuditOrderPo.class);
        UocAuditOrderPo where = new UocAuditOrderPo();
        where.setOrderId(updateDo.getOrderId());
        where.setAuditOrderId(updateDo.getAuditOrderId());
        where.setSysTenantId(updateDo.getSysTenantId());
        uocAuditOrderMapper.updateBy(set, where);
        if (null != updateDo.getApprovalLog()) {
            uocApprovalLogMapper.insert(UocRu.js(updateDo.getApprovalLog(), UocApprovalLogPo.class));
        }
        return updateDo;
    }

    @Override
    public List<UocApprovalObj> qryApprovealObj(UocApprovalObjQryBo obj) {
        List<UocApprovalObjPo> list = uocApprovalObjMapper.getList(UocRu.js(obj, UocApprovalObjPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocApprovalObj.class) : new ArrayList<>();
    }

    @Override
    public List<UocAuditOrder> qryAuditOrderList(UocAuditOrderQryBo qryBo) {
        List<UocAuditOrderPo> list = uocAuditOrderMapper.getList(UocRu.js(qryBo, UocAuditOrderPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAuditOrder.class) : new ArrayList<>();
    }

    @Override
    public void saveAuditLog(UocAuditOrderDo orderDo) {
        if (null != orderDo && null != orderDo.getApprovalLog()) {
            uocApprovalLogMapper.insert(UocRu.js(orderDo.getApprovalLog(), UocApprovalLogPo.class));
        }
    }

    @Override
    public UocAuditOrderDo qryApprovalLog(UocApprovalLogQryBo uocApprovalLogQryBo) {
        UocApprovalLogPo uocApprovalLogPo = new UocApprovalLogPo();
        uocApprovalLogPo.setAuditOrderId(uocApprovalLogQryBo.getAuditOrderId());
        uocApprovalLogPo.setSysTenantId(uocApprovalLogQryBo.getSysTenantId());
        List<UocApprovalLogPo> uocApprovalLogPos = uocApprovalLogMapper.getList(uocApprovalLogPo);
        UocAuditOrderDo uocAuditOrderDo = new UocAuditOrderDo();
        List<UocApprovalLog> uocApprovalLogs = UocRu.jsl(uocApprovalLogPos, UocApprovalLog.class);
        uocAuditOrderDo.setUocApprovalLogList(uocApprovalLogs);
        return uocAuditOrderDo;
    }

    @Override
    public UocAuditOrderDo qryAuditOrder(UocAuditOrderQryBo qryBo) {
        UocAuditOrderPo modelBy = uocAuditOrderMapper.getModelBy(UocRu.js(qryBo, UocAuditOrderPo.class));
        return UocRu.js(modelBy, UocAuditOrderDo.class);
    }
}


