package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocConfTabTachePo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:UocConfTabTacheMapper
 * 说明:页面每个sheet页对应需要查询的环节
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface UocConfTabTacheMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocConfTabTachePo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocConfTabTachePo uocConfTabTachePo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocConfTabTachePo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocConfTabTachePo uocConfTabTachePo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocConfTabTachePo set, @Param("where") UocConfTabTachePo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocConfTabTachePo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocConfTabTachePo uocConfTabTachePo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocConfTabTachePo 参数对象
	 * @return UocConfTabTachePo 结果对象
	 */
	UocConfTabTachePo getModelBy(UocConfTabTachePo uocConfTabTachePo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocConfTabTachePo 参数对象
	 * @return List<UocConfTabTachePo> 结果对象
	 */
	List<UocConfTabTachePo> getList(UocConfTabTachePo uocConfTabTachePo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocConfTabTachePo 参数对象
	 * @param page 分页参数
	 * @return List<UocConfTabTachePo> 结果对象
	 */
	List<UocConfTabTachePo> getListPage(UocConfTabTachePo uocConfTabTachePo, Page<UocConfTabTachePo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocConfTabTachePo> list);

}
