package com.tydic.dyc.oc.repository.po;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocPayOrderPo
 * 说明:支付单
 * 时间:2022-02-23 20:57
 * 作者:罗有
 **/
@Data
public class UocPayOrderPo implements Serializable {
	private static final long serialVersionUID =  1257955838485415336L;

	@DocField(value = "支付单id")
	private Long payOrderId;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "支付名称")
	private String payName;

	@DocField(value = "支付类型            1 线上支付    2 线下支付")
	private Integer payMod;

	@DocField(value = "支付方式             1 微信             2 支付宝             3 企业支付")
	private Integer payType;

	@DocField(value = "支付优先级")
	private String payLevel;

	@DocField(value = "外部支付流水")
	private String outPayOrderNo;

	@DocField(value = "退款/扣款标志             0 扣款             1 退款")
	private Integer interType;

	@DocField(value = "应付金额")
	private BigDecimal totalFee;

	@DocField(value = "应付金额占比")
	private BigDecimal totalFeeSup;

	@DocField(value = "减免金额")
	private BigDecimal reduceFee;

	@DocField(value = "红包金额")
	private BigDecimal redEnvelopeFee;

	@DocField(value = "活动金额")
	private BigDecimal actFee;

	@DocField(value = "实付金额")
	private BigDecimal payFee;

	@DocField(value = "违约金比例")
	private BigDecimal penaltyRatio;

	@DocField(value = "已付金额")
	private BigDecimal paidFee;

	@DocField(value = "支付金额类型")
	private Integer payFeeType;

	@DocField(value = "支付状态")
	private String payState;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "付款方ID")
	private String payerId;

	@DocField(value = "付款方名称")
	private String payerName;

	@DocField(value = "收款方ID")
	private String payeeId;

	@DocField(value = "收款方名称")
	private String payeeName;

	@DocField(value = "合同编号")
	private String contractNo;

	@DocField(value = "合同ID")
	private String contractId;

	@DocField(value = "租户ID")
	private String tenantId;

	@DocField(value = "支付工号")
	private String payOperId;

	@DocField(value = "支付时间")
	private Date payTime;

	@DocField(value = "支付时间 开始")
	private Date payTimeStart;

	@DocField(value = "支付时间 结束")
	private Date payTimeEnd;

	@DocField(value = "竣工标志             1 竣工             0 在途")
	private Integer finishFlag;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建时间 开始")
	private Date createTimeStart;

	@DocField(value = "创建时间 结束")
	private Date createTimeEnd;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新时间 开始")
	private Date updateTimeStart;

	@DocField(value = "更新时间 结束")
	private Date updateTimeEnd;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "撤单时间")
	private Date cancelTime;

	@DocField(value = "撤单时间 开始")
	private Date cancelTimeStart;

	@DocField(value = "撤单时间 结束")
	private Date cancelTimeEnd;

	@DocField(value = "撤单工号")
	private String cancelOperId;

	@DocField(value = "撤单原因")
	private String cancelReason;

	@DocField(value = "撤单标志:1 已撤单             0 未撤单")
	private Integer cancelFlag;

	@DocField(value = "竣工时间")
	private Date finishTime;

	@DocField(value = "竣工时间 开始")
	private Date finishTimeStart;

	@DocField(value = "竣工时间 结束")
	private Date finishTimeEnd;

	@DocField(value = "逾期时间")
	private Date expTime;

	@DocField(value = "逾期时间 开始")
	private Date expTimeStart;

	@DocField(value = "逾期时间 结束")
	private Date expTimeEnd;

	@DocField(value = "扩展字段1")
	private String extField1;

	@DocField(value = "扩展字段2")
	private String extField2;

	@DocField(value = "扩展字段3")
	private String extField3;

	@DocField(value = "扩展字段4")
	private String extField4;

	@DocField(value = "扩展字段5")
	private String extField5;

	@DocField(value = "删除标志1已删除")
	private Integer delTag;

		@DocField(value = "排序")
	private String orderBy;

	@DocField(value = "租户id")
	private Long sysTenantId;

	@DocField(value = "租户名称")
	private String sysTenantName;

}
