package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.repository.po.SysDicDictionaryPo;
import com.tydic.dyc.oc.repository.po.UocOrderPo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题:SysDicDictionaryMapper
 * 说明:字典表
 * 时间:2022-02-23 21:04
 * 作者:罗有
 **/
@Mapper
@Repository
public interface SysDicDictionaryMapper {

	/**
	 * 插入单条数据
	 *
	 * @param sysDicDictionaryPo 参数对象
	 * @return int 影响数量
	 */
	int insert(SysDicDictionaryPo sysDicDictionaryPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param sysDicDictionaryPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(SysDicDictionaryPo sysDicDictionaryPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") SysDicDictionaryPo set, @Param("where") SysDicDictionaryPo where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param sysDicDictionaryPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(SysDicDictionaryPo sysDicDictionaryPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param sysDicDictionaryPo 参数对象
	 * @return SysDicDictionaryPo 结果对象
	 */
	SysDicDictionaryPo getModelBy(SysDicDictionaryPo sysDicDictionaryPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param sysDicDictionaryPo 参数对象
	 * @return List<SysDicDictionaryPo> 结果对象
	 */
	List<SysDicDictionaryPo> getList(SysDicDictionaryPo sysDicDictionaryPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param sysDicDictionaryPo 参数对象
	 * @param page 分页参数
	 * @return List<SysDicDictionaryPo> 结果对象
	 */
	List<SysDicDictionaryPo> getListPage(SysDicDictionaryPo sysDicDictionaryPo, Page<SysDicDictionaryPo> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<SysDicDictionaryPo> list);

	/**
	 * 获取最大排序值
	 *
	 * @param sysDicDictionaryPo 字典对象
	 * @return Integer
	 */
	Integer getMaxOrderId(SysDicDictionaryPo sysDicDictionaryPo);

	/**
	 * deleteBy根据Model删除数据
	 * 注: 根据Model拼接条件执行删除操作.
	 *@param sysDicDictionaryPo
	 * @return int
	 */
	int deleteBy(SysDicDictionaryPo sysDicDictionaryPo);

	/**
	 * 模糊查询 descrip
	 *
	 * @param sysDicDictionaryPo 参数对象
	 * @return SysDicDictionaryPo 结果对象
	 */
	List<SysDicDictionaryPo> getModelAmbiguousBy(SysDicDictionaryPo sysDicDictionaryPo);



}
