package com.tydic.dyc.oc.repository.po;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocImplOrderItemPo
 * 说明:执行单明细
 * 时间:2022-03-09 14:13
 * 作者:罗有
 **/
@Data
public class UocImplOrderItemPo implements Serializable {
	private static final long serialVersionUID = 472046558853290479L;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "销售单id")
	private Long saleOrderId;

	@DocField(value = "执行明细id")
	private Long implOrderItemId;

	@DocField(value = "销售明细id")
	private Long saleOrderItemId;


	@DocField(value = "明细状态")
	private String implItemState;

	@DocField(value = "明细类型             1 商品sku             2 物资             3 项目")
	private Integer itemType;

	@DocField(value = "单品ID")
	private String skuId;

	@DocField(value = "供应商ID")
	private String supplierId;

	@DocField(value = "店铺ID")
	private String supplierShopId;

	@DocField(value = "协议编号")
	private String agreementNo;

	@DocField(value = "协议明细编号")
	private String agreementItemNo;

	@DocField(value = "计量单位")
	private String unitName;

	@DocField(value = "结算计量单位")
	private String settleUnit;

	@DocField(value = "采购金额")
	private BigDecimal purchasePrice;

	@DocField(value = "采购金额")
	private BigDecimal salePrice;

	@DocField(value = "销售金额")
	private BigDecimal saleFee;

	@DocField(value = "采购金额")
	private BigDecimal purchaseFee;

	@DocField(value = "应付金额")
	private BigDecimal payFee;

	@DocField(value = "采购数量")
	private BigDecimal purchaseCount;

	@DocField(value = "发货数量")
	private BigDecimal sendCount;

	@DocField(value = "到货数量")
	private BigDecimal arriveCount;

	@DocField(value = "拒收数量")
	private BigDecimal refuseCount;

	@DocField(value = "验收数量")
	private BigDecimal acceptanceCount;

	@DocField(value = "退货数量")
	private BigDecimal returnCount;

	@DocField(value = "异常变更在途数量，表示异常供应商确认之前的记录数量")
	private BigDecimal chngingCount;

	@DocField(value = "售后在途数量")
	private BigDecimal afterServingCount;

	@DocField(value = "运费")
	private BigDecimal transFee;

	@DocField(value = "积分优惠金额")
	private BigDecimal integralDisFee;

	@DocField(value = "活动优惠金额")
	private BigDecimal actDisFee;

	@DocField(value = "其它优惠金额")
	private BigDecimal otherDisFee;

	@DocField(value = "实付金额")
	private BigDecimal usedFee;

	@DocField(value = "实付积分")
	private BigDecimal usedIntegral;

	@DocField(value = "币种")
	private String currencyType;

	@DocField(value = "税金")
	private String taxPrice;

	@DocField(value = "税率")
	private String tax;

	@DocField(value = "税务编码")
	private String taxId;

	@DocField(value = "超验百分比，下单时保存（协议、无协议）")
	private Integer inspectionExcessPercent;

	@DocField(value = "扩展字段")
	private String extField1;

	@DocField(value = "扩展字段")
	private String extField2;

	@DocField(value = "扩展字段")
	private String extField3;

	@DocField(value = "扩展字段")
	private String extField4;

	@DocField(value = "扩展字段")
	private String extField5;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建时间 开始")
	private Date createTimeStart;

	@DocField(value = "创建时间 结束")
	private Date createTimeEnd;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新时间 开始")
	private Date updateTimeStart;

	@DocField(value = "更新时间 结束")
	private Date updateTimeEnd;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "删除标志1已删除")
	private Integer delTag;

		@DocField(value = "排序")
	private String orderBy;

	@DocField(value = "租户id")
	private Long sysTenantId;

	@DocField(value = "租户名称")
	private String sysTenantName;

	@DocField(value = "执行单明细IDList")
	private List<Long> implOrderItemIdList;

	@DocField(value = "订单IDList")
	private List<Long> orderIdList;

}
