/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.tydic.payment.pay.ability.AliH5PayAbilityService;
import com.tydic.payment.pay.ability.bo.AliH5PayAbilityReqBO;
import com.tydic.payment.pay.ability.bo.AliH5PayAbilityRspBO;
import com.tydic.payment.pay.bo.PayParaInfoAttrBo;
import com.tydic.payment.pay.busi.AliH5PayBusiService;
import com.tydic.payment.pay.busi.PayOrderBusiService;
import com.tydic.payment.pay.busi.QueryCashierInfoPayParaAttrService;
import com.tydic.payment.pay.busi.bo.AliH5PayBusiReqBO;
import com.tydic.payment.pay.busi.bo.AliH5PayBusiRspBO;
import com.tydic.payment.pay.busi.bo.PayOrderRspBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrReqBo;
import com.tydic.payment.pay.busi.bo.QueryCashierInfoPayParaAttrRspBo;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.exception.BusinessException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.ability.AliH5PayAbilityService"})
public class AliH5PayAbilityServiceImpl
implements AliH5PayAbilityService {
    @Autowired
    private PayPropertiesVo payPropertiesVo;
    @Autowired
    private PayOrderBusiService payOrderBusiService;
    @Autowired
    private QueryCashierInfoPayParaAttrService queryCashierInfoPayParaAttrService;
    @Autowired
    private AliH5PayBusiService aliH5PayBusiService;

    @PostMapping(value={"aliH5Pay"})
    public AliH5PayAbilityRspBO aliH5Pay(@RequestBody AliH5PayAbilityReqBO req) {
        AliH5PayAbilityRspBO rsp = new AliH5PayAbilityRspBO();
        this.checkInputParas(req);
        PayOrderRspBo orderInfo = this.payOrderBusiService.selectOrderByOrderId(Long.valueOf(req.getOrderId()));
        if (!"0000".equals(orderInfo.getRspCode())) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed8\u6839\u636e\u8ba2\u5355id\u3010ORDER_ID=" + req.getOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        if (StringUtils.isEmpty((Object)orderInfo.getMerchantId())) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed8\u6839\u636e\u8ba2\u5355id\u3010ORDER_ID=" + req.getOrderId() + "\u3011\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f\u4e2d\u65e0\u5546\u6237\u53f7\uff01");
        }
        rsp.setRedirectUrl(orderInfo.getRedirectUrl());
        rsp.setDetailName(orderInfo.getDetailName());
        if ("A10".equals(orderInfo.getOrderStatus())) {
            rsp.setRspCode("214007");
            rsp.setRspName("\u8be5\u8ba2\u5355\u3010" + req.getOrderId() + "\u3011\u5df2\u7ecf\u652f\u4ed8\u8fc7");
            return rsp;
        }
        if ("B10".equals(orderInfo.getOrderStatus())) {
            rsp.setRspCode("214008");
            rsp.setRspName("\u8be5\u8ba2\u5355\u3010" + req.getOrderId() + "\u3011\u5df2\u7ecf\u9000\u6b3e\uff0c\u8bf7\u4e0d\u8981\u518d\u652f\u4ed8\uff01");
            return rsp;
        }
        if ("B20".equals(orderInfo.getOrderStatus())) {
            rsp.setRspCode("214009");
            rsp.setRspName("\u8be5\u8ba2\u5355\u3010" + req.getOrderId() + "\u3011\u5df2\u7ecf\u652f\u4ed8\u8fc7\uff0c\u5e76\u5c1d\u8bd5\u8fc7\u9000\u6b3e\u4f46\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u4e0d\u8981\u518d\u652f\u4ed8\uff01");
            return rsp;
        }
        String merchantId = String.valueOf(orderInfo.getMerchantId());
        Map<String, Object> paramMap = this.getParamMap(merchantId, "23");
        AliH5PayBusiReqBO aliH5PayBusiReqBO = new AliH5PayBusiReqBO();
        aliH5PayBusiReqBO.setOrderId(req.getOrderId());
        aliH5PayBusiReqBO.setMerchantId(merchantId);
        aliH5PayBusiReqBO.setTotalFee(new BigDecimal(req.getTotalFee()));
        aliH5PayBusiReqBO.setParamMap(paramMap);
        aliH5PayBusiReqBO.setReturnUrl(this.payPropertiesVo.getUnicodeAliH5PayReturnUrl());
        try {
            AliH5PayBusiRspBO aliH5PayBusiRsp = this.aliH5PayBusiService.dealAliH5Pay(aliH5PayBusiReqBO);
            if (!"0000".equals(aliH5PayBusiRsp.getRspCode())) {
                rsp.setRspCode("214006");
                rsp.setRspName(aliH5PayBusiRsp.getRspName());
                return rsp;
            }
            BeanUtils.copyProperties((Object)aliH5PayBusiRsp, (Object)rsp);
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed8\u8c03\u7528\u5fae\u4fe1\u516c\u4f17\u53f7\u652f\u4ed8\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return rsp;
    }

    private void checkInputParas(AliH5PayAbilityReqBO req) {
        if (req == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed8\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed8\u5165\u53c2\u8ba2\u5355\u7f16\u53f7\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)req.getTotalFee())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed8\u5165\u53c2\u652f\u4ed8\u91d1\u989d\u3010totalFee\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private Map<String, Object> getParamMap(String merchant_id, String payMethod) {
        QueryCashierInfoPayParaAttrReqBo paraReq = new QueryCashierInfoPayParaAttrReqBo();
        paraReq.setMerchantId(merchant_id);
        paraReq.setPayMethod(payMethod);
        QueryCashierInfoPayParaAttrRspBo paraInfo = this.queryCashierInfoPayParaAttrService.queryPayParaAttr(paraReq);
        if (paraInfo == null || !"0000".equals(paraInfo.getRspCode())) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed8\u6839\u636e\u5546\u6237\u53f7\u3010" + merchant_id + "\u3011\u67e5\u8be2\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01");
        }
        if (paraInfo.getInfoPayParaAttrList() == null || paraInfo.getInfoPayParaAttrList().size() < 1) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u652f\u4ed8\u5b9d\u624b\u673a\u7f51\u7ad9\u652f\u4ed8\u6839\u636e\u5546\u6237\u53f7\u3010" + merchant_id + "\u3011\u67e5\u8be2\u65e0\u652f\u4ed8\u53c2\u6570\u914d\u7f6e\uff01");
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        for (PayParaInfoAttrBo para : paraInfo.getInfoPayParaAttrList()) {
            paramMap.put(para.getAttrCode(), para.getAttrValue());
        }
        return paramMap;
    }
}

