/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.ChinaBankRealPayAbilityService;
import com.tydic.payment.pay.ability.bo.ChinaBankRealPayAbilityReqBo;
import com.tydic.payment.pay.ability.bo.ChinaBankRealPayAbilityRspBo;
import com.tydic.payment.pay.busi.ChinaBankRealPayBusiService;
import com.tydic.payment.pay.busi.PayProQueryInfoBusiSystemByConditionService;
import com.tydic.payment.pay.busi.bo.ChinaBankRealPayBusiReqBo;
import com.tydic.payment.pay.busi.bo.ChinaBankRealPayBusiRspBo;
import com.tydic.payment.pay.busi.bo.PayProQueryInfoBusiSystemByConditionBusiInfoRspBo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.ability.ChinaBankRealPayAbilityService"})
public class ChinaBankPayAbilityServiceImpl
implements ChinaBankRealPayAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ChinaBankPayAbilityServiceImpl.class);
    private static final String SERVICE_NAME = "\u4e2d\u884c-\u5b9e\u4ed8ability\u670d\u52a1";
    @Autowired
    private PayProQueryInfoBusiSystemByConditionService queryInfoBusiSystemByConditionService;
    @Autowired
    private ChinaBankRealPayBusiService chinaBankRealPayBusiService;

    @PostMapping(value={"realPay"})
    public ChinaBankRealPayAbilityRspBo realPay(@RequestBody ChinaBankRealPayAbilityReqBo reqBo) {
        if (log.isDebugEnabled()) {
            log.info("\u4e2d\u884c-\u5b9e\u4ed8ability\u670d\u52a1-> \u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        }
        ChinaBankRealPayAbilityRspBo retBo = new ChinaBankRealPayAbilityRspBo();
        String validateArgStr = this.validateArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("214030");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        String busiCode = reqBo.getBusiCode();
        PayProQueryInfoBusiSystemByConditionBusiInfoRspBo busiCodeRspBo = this.queryInfoBusiSystemByConditionService.queryBusiSysByBusiCode(busiCode);
        if (!"0000".equals(busiCodeRspBo.getRespCode())) {
            retBo.setRespCode("214030");
            retBo.setRespDesc("\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25:" + busiCodeRspBo.getRespDesc());
            return retBo;
        }
        if (!"1".equals(busiCodeRspBo.getState())) {
            retBo.setRespCode("214030");
            retBo.setRespDesc("\u8be5\u4e1a\u52a1\u7cfb\u7edf(" + busiCode + ")\u5df2\u5931\u6548");
            return retBo;
        }
        Long busiId = busiCodeRspBo.getBusiId();
        ChinaBankRealPayBusiReqBo orderReqBo = new ChinaBankRealPayBusiReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)orderReqBo);
        orderReqBo.setBusiId(busiId);
        orderReqBo.setPayMethod(Long.valueOf(Long.parseLong(reqBo.getPayMethod())));
        ChinaBankRealPayBusiRspBo orderRspBo = this.chinaBankRealPayBusiService.realPay(orderReqBo);
        if (!"0000".equals(orderRspBo.getRespCode())) {
            retBo.setRespCode("214018");
            retBo.setRespDesc("\u8c03\u7528\u4e0d\u52a0\u5bc6\u670d\u52a1\u5931\u8d25\uff1a" + orderRspBo.getRespDesc());
            return retBo;
        }
        BeanUtils.copyProperties((Object)orderRspBo, (Object)retBo);
        retBo.setBusiCode(busiId.toString());
        retBo.setRespCode("0000");
        retBo.setRespDesc(orderRspBo.getRespDesc());
        return retBo;
    }

    private String validateArg(ChinaBankRealPayAbilityReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e2d\u7684'busiCode'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOutOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e2d\u7684'outOrderId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e2d\u7684'merchantId'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getTotalFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e2d\u7684'totalFee'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayMethod())) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e2d\u7684'payMethod'\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

