/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.payment.pay.ability.ClosePayOrderAbilityService;
import com.tydic.payment.pay.ability.bo.ClosePayOrderAbilityReqBo;
import com.tydic.payment.pay.atom.PayOrderAtomService;
import com.tydic.payment.pay.atom.PorderPayTransAtomService;
import com.tydic.payment.pay.atom.bo.PorderPayTransAtomRspBo;
import com.tydic.payment.pay.bo.BaseRspInfoBO;
import com.tydic.payment.pay.busi.OrderQueryConstructionBusiService;
import com.tydic.payment.pay.busi.QueryInfoBusiSystemService;
import com.tydic.payment.pay.busi.bo.OrderQueryConstructionReqBo;
import com.tydic.payment.pay.busi.bo.OrderQueryConstructionRspBo;
import com.tydic.payment.pay.busi.bo.QueryInfoBusiSystemBo;
import com.tydic.payment.pay.busi.bo.QueryInfoBusiSystemReqBo;
import com.tydic.payment.pay.busi.bo.QueryInfoBusiSystemRspBo;
import com.tydic.payment.pay.comb.PayCloseOrderCombService;
import com.tydic.payment.pay.comb.bo.CloseOrderCombReqBO;
import com.tydic.payment.pay.comb.bo.CloseOrderCombRspBO;
import com.tydic.payment.pay.dao.po.PorderPo;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.ability.ClosePayOrderAbilityService"})
public class ClosePayOrderAbilityServiceImpl
implements ClosePayOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ClosePayOrderAbilityServiceImpl.class);
    @Autowired
    private QueryInfoBusiSystemService queryInfoBusiSystemService;
    @Autowired
    private OrderQueryConstructionBusiService orderQueryConstructionBusiService;
    @Autowired
    private PayCloseOrderCombService payCloseOrderCombService;
    @Autowired
    private PayOrderAtomService payOrderAtomService;
    @Autowired
    private PorderPayTransAtomService porderPayTransAtomService;

    @PostMapping(value={"dealClosePayOrder"})
    public BaseRspInfoBO dealClosePayOrder(@RequestBody ClosePayOrderAbilityReqBo reqBo) {
        BaseRspInfoBO rspBo = new BaseRspInfoBO();
        rspBo.setRspCode("8888");
        try {
            BaseRspInfoBO checkRsp = this.checkReqBoLegal(reqBo);
            if (!checkRsp.getRspCode().equals("0000")) {
                log.info("\u652f\u4ed8\u8ba2\u5355(\u4e8c\u7ef4\u7801)\u5173\u95ed\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)checkRsp));
                return checkRsp;
            }
            String orderId = checkRsp.getRspName();
            PorderPo orderInfo = this.payOrderAtomService.queryByOrderId(Long.valueOf(orderId));
            if (orderInfo.getOrderStatus().equals("A10")) {
                log.info("\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8\u6210\u529f");
                rspBo.setRspName("\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8\u6210\u529f,\u652f\u4ed8\u8ba2\u5355(\u4e8c\u7ef4\u7801\u652f\u4ed8)\u5173\u95ed\u5931\u8d25");
                return rspBo;
            }
            PorderPayTransAtomRspBo orderPayTransRsp = this.porderPayTransAtomService.queryLastRecordByOrderId(Long.valueOf(orderId));
            if (orderPayTransRsp.getOrderStatus().equals("A10")) {
                log.info("\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8\u6210\u529f");
                rspBo.setRspName("\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8\u6210\u529f,\u652f\u4ed8\u8ba2\u5355(\u4e8c\u7ef4\u7801\u652f\u4ed8)\u5173\u95ed\u5931\u8d25");
                return rspBo;
            }
            String payMethod = orderPayTransRsp.getPayMethod().toString();
            if (!payMethod.equals("11") & !payMethod.equals("21")) {
                log.info("\u652f\u4ed8\u8ba2\u5355(\u4e8c\u7ef4\u7801\u652f\u4ed8)\u5173\u95ed\u5931\u8d25");
                rspBo.setRspName("\u652f\u4ed8\u8ba2\u5355(\u4e8c\u7ef4\u7801\u652f\u4ed8)\u5173\u95ed\u5931\u8d25,\u8be5\u8ba2\u5355\u652f\u4ed8\u65b9\u5f0f\u4e0d\u662f\u5fae\u4fe1\u4e8c\u7ef4\u7801\u652f\u4ed8\uff0c\u6216\u652f\u4ed8\u5b9d\u4e8c\u7ef4\u7801\u652f\u4ed8");
                return rspBo;
            }
            CloseOrderCombReqBO closeOrderCombReq = new CloseOrderCombReqBO();
            closeOrderCombReq.setOrderId(orderId);
            closeOrderCombReq.setPayOrderId(orderPayTransRsp.getPayOrderId());
            CloseOrderCombRspBO closeOrderCombRsp = this.payCloseOrderCombService.dealCloseOrder(closeOrderCombReq);
            if (closeOrderCombRsp.getRspCode().equals("0000")) {
                rspBo.setRspCode("0000");
                rspBo.setRspName("\u652f\u4ed8\u8ba2\u5355(\u4e8c\u7ef4\u7801\u652f\u4ed8)\u5173\u95ed\u6210\u529f");
                return rspBo;
            }
            log.info("\u652f\u4ed8\u8ba2\u5355(\u4e8c\u7ef4\u7801\u652f\u4ed8)\u5173\u95ed\u5931\u8d25\uff0c\u8c03\u7528\u3010CloseOrderCombService\u3011\u670d\u52a1\u8fd4\u56de\u9519\u8bef\u4fe1\u606f");
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u652f\u4ed8\u8ba2\u5355(\u4e8c\u7ef4\u7801\u652f\u4ed8)\u5173\u95ed\u5931\u8d25");
            return rspBo;
        }
        catch (Exception e) {
            log.error("\u652f\u4ed8\u8ba2\u5355\uff08\u4e8c\u7ef4\u7801\uff09\u5173\u95ed\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            rspBo.setRspCode("8888");
            rspBo.setRspName("\u8c03\u7528\u5173\u95ed\u8ba2\u5355\u80fd\u529b\u63a5\u53e3\u3010ClosePayOrderAbilityService\u3011\u5931\u8d25");
            return rspBo;
        }
    }

    private BaseRspInfoBO checkReqBoLegal(ClosePayOrderAbilityReqBo reqBo) {
        BaseRspInfoBO checkRsp = new BaseRspInfoBO();
        checkRsp.setRspCode("8888");
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            checkRsp.setRspName("\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return checkRsp;
        }
        if (StringUtils.isEmpty((Object)reqBo.getOutOrderId())) {
            checkRsp.setRspName("\u5916\u90e8\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            return checkRsp;
        }
        String busiId = null;
        String orderId = null;
        try {
            QueryInfoBusiSystemReqBo qryBusiReq = new QueryInfoBusiSystemReqBo();
            qryBusiReq.setBusiCode(reqBo.getBusiCode());
            QueryInfoBusiSystemRspBo qryBusiRsp = this.queryInfoBusiSystemService.queryInfoBusiSystem(qryBusiReq);
            if (qryBusiRsp.getRspCode().equals("8888")) {
                log.info("\u8c03\u7528\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1\u3010QueryInfoBusiSystemService\u3011\u51fa\u9519");
                checkRsp.setRspName("\u8c03\u7528\u67e5\u8be2\u4e1a\u52a1\u7cfb\u7edf\u4fe1\u606f\u670d\u52a1\u51fa\u9519");
                return checkRsp;
            }
            if (CollectionUtils.isEmpty((Collection)qryBusiRsp.getInfoBusiBoList())) {
                log.info("\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801\u4e0d\u5b58\u5728");
                checkRsp.setRspName("\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801\u4e0d\u5b58\u5728");
                return checkRsp;
            }
            busiId = ((QueryInfoBusiSystemBo)qryBusiRsp.getInfoBusiBoList().get(0)).getBusiId();
            OrderQueryConstructionReqBo orderQueryReq = new OrderQueryConstructionReqBo();
            orderQueryReq.setBusiId(Long.valueOf(busiId));
            orderQueryReq.setOutOrderId(reqBo.getOutOrderId());
            OrderQueryConstructionRspBo orderQueryRsp = this.orderQueryConstructionBusiService.queryConstruction(orderQueryReq);
            if (orderQueryRsp.getRspCode().equals("8888")) {
                log.info("\u67e5\u8be2\u5931\u8d25\uff0c\u8c03\u7528OrderQueryConstructionBusiService\u670d\u52a1\u5f02\u5e38");
                checkRsp.setRspName("\u67e5\u8be2\u5931\u8d25,\u67e5\u8be2\u5206\u5e93\u5efa\u8868\u670d\u52a1\u3010OrderQueryConstructionBusiService\u3011\u51fa\u9519");
                return checkRsp;
            }
            orderId = orderQueryRsp.getOrderId().toString();
        }
        catch (Exception e) {
            log.error("\u6821\u9a8c\u5165\u53c2\u662f\u5426\u5408\u6cd5\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            checkRsp.setRspName("\u5165\u53c2\u6821\u9a8c\u5931\u8d25,\u670d\u52a1\u51fa\u9519");
            return checkRsp;
        }
        checkRsp.setRspCode("0000");
        checkRsp.setRspName(orderId);
        log.info("\u5165\u53c2\u6821\u9a8c\u6210\u529f\uff0c\u8fd4\u56de\u8ba2\u5355\u53f7 orderId = " + orderId);
        return checkRsp;
    }
}

