/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.atom.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.CashierTemplateAtomService;
import com.tydic.payment.pay.config.PayProCacheManager;
import com.tydic.payment.pay.dao.CashierTemplateMapper;
import com.tydic.payment.pay.dao.po.CashierTemplatePageReqPO;
import com.tydic.payment.pay.dao.po.CashierTemplatePo;
import com.tydic.payment.pay.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="CashierTemplateAtomService")
public class CashierTemplateAtomServiceImpl
implements CashierTemplateAtomService {
    @Autowired
    private CashierTemplateMapper cashierTemplateMapper;
    @Autowired
    private PayProCacheManager payProCacheManager;

    @Override
    public Long createCashierTemplate(CashierTemplatePo po) {
        this.validateArg(po);
        int createCashierTemplate = this.cashierTemplateMapper.createCashierTemplate(po);
        if (createCashierTemplate < 1) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_INFO_CASHIER_TEMPLATE\u65f6mapper insert\u65b9\u6cd5\u8fd4\u56de\u503c\u5c0f\u4e8e1\uff0c\u63d2\u5165\u5931\u8d25\uff01");
        }
        if (po.getCashierTemplate() == null) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_INFO_CASHIER_TEMPLATE\u540e\u672a\u8fd4\u56de\u63d2\u5165\u7684id");
        }
        return po.getCashierTemplate();
    }

    @Override
    public List<CashierTemplatePo> queryCashierTemplateByCondition(CashierTemplatePo po) {
        List<CashierTemplatePo> queryCashierTemplateByCondition;
        if (po == null) {
            po = new CashierTemplatePo();
        }
        if ((queryCashierTemplateByCondition = this.cashierTemplateMapper.queryCashierTemplateByCondition(po)) == null || queryCashierTemplateByCondition.isEmpty()) {
            return new ArrayList<CashierTemplatePo>();
        }
        return queryCashierTemplateByCondition;
    }

    @Override
    public int updateCashierTemplate(CashierTemplatePo po) {
        this.validateArgUpdate(po);
        int updateCashierTemplate = this.cashierTemplateMapper.updateCashierTemplate(po);
        return updateCashierTemplate;
    }

    @Override
    public int deleteCashierTemplate(CashierTemplatePo po) {
        this.validateArgDel(po);
        int deleteCashierTemplate = this.cashierTemplateMapper.deleteCashierTemplate(po);
        return deleteCashierTemplate;
    }

    private void validateArgDel(CashierTemplatePo po) {
        if (po == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_INFO_CASHIER_TEMPLATE\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getCashierTemplate() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5220\u9664P_INFO_CASHIER_TEMPLATE\u5165\u53c2\u5c5e\u6027CashierTemplate\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateArgUpdate(CashierTemplatePo po) {
        if (po == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0P_INFO_CASHIER_TEMPLATE\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getCashierTemplate() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0P_INFO_CASHIER_TEMPLATE\u5165\u53c2\u5c5e\u6027CashierTemplate\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateArg(CashierTemplatePo po) {
        if (po == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_CASHIER_TEMPLATE\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getCashierTemplate() != null) {
            po.setCashierTemplate(null);
        }
        if (po.getCashierTemplateName() == null || po.getCashierTemplateName().trim().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_CASHIER_TEMPLATE\u5165\u53c2\u5c5e\u6027CashierTemplateName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getCashierTemplateUrl() == null || po.getCashierTemplateUrl().trim().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_CASHIER_TEMPLATE\u5165\u53c2\u5c5e\u6027CashierTemplateUrl\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getFlag() == null || po.getFlag().trim().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_CASHIER_TEMPLATE\u5165\u53c2\u5c5e\u6027Flag\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public List<CashierTemplatePo> queryCashierTemplateBetweenTimeWithPage(CashierTemplatePageReqPO po, Page<CashierTemplatePageReqPO> page, Date createTimeStart, Date createTimeEnd, Date updateTimeStart, Date updateTimeEnd) {
        if (po == null) {
            po = new CashierTemplatePageReqPO();
        }
        List<CashierTemplatePo> queryCashierTemplateByCondition = this.cashierTemplateMapper.queryCashierTemplateBetweenTimeWithPage(po, page, createTimeStart, createTimeEnd, updateTimeStart, updateTimeEnd);
        return queryCashierTemplateByCondition;
    }

    @Override
    public Long createCashierTemplateWithId(CashierTemplatePo po) {
        this.validateCreateWithIdArg(po);
        int createCashierTemplate = this.cashierTemplateMapper.createCashierTemplateWithId(po);
        if (createCashierTemplate < 1) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_INFO_CASHIER_TEMPLATE\u65f6mapper insert\u65b9\u6cd5\u8fd4\u56de\u503c\u5c0f\u4e8e1\uff0c\u63d2\u5165\u5931\u8d25\uff01");
        }
        if (po.getCashierTemplate() == null) {
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u63d2\u5165P_INFO_CASHIER_TEMPLATE\u540e\u672a\u8fd4\u56de\u63d2\u5165\u7684id");
        }
        return po.getCashierTemplate();
    }

    private void validateCreateWithIdArg(CashierTemplatePo po) {
        if (po == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_CASHIER_TEMPLATE\u5165\u53c2po\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getCashierTemplateName() == null || po.getCashierTemplateName().trim().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_CASHIER_TEMPLATE\u5165\u53c2\u5c5e\u6027CashierTemplateName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getCashierTemplateUrl() == null || po.getCashierTemplateUrl().trim().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_CASHIER_TEMPLATE\u5165\u53c2\u5c5e\u6027CashierTemplateUrl\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (po.getFlag() == null || po.getFlag().trim().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u63d2\u5165P_INFO_CASHIER_TEMPLATE\u5165\u53c2\u5c5e\u6027Flag\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public CashierTemplatePo queryCashierTemplateById(Long cashierTemplate) {
        if (cashierTemplate == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2P_INFO_CASHIER_TEMPLATE\u5165\u53c2cashierTemplate\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CashierTemplatePo qryCashierPo = this.cashierTemplateMapper.queryCashierTemplateById(cashierTemplate);
        return qryCashierPo;
    }
}

