/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.payable.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleCallBackRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleQryPayStatusRspBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundReqBo;
import com.tydic.payment.pay.busi.bo.PayAbleRefundRspBo;
import com.tydic.payment.pay.config.PayProSequence;
import com.tydic.payment.pay.config.vo.PayPropertiesVo;
import com.tydic.payment.pay.dao.PayProOrderQueryMapper;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.payable.api.PayAble;
import com.tydic.payment.pay.payable.impl.transbo.SftCallBackRspBO;
import com.tydic.payment.pay.payable.impl.transbo.SftQueryOrderStateReqBO;
import com.tydic.payment.pay.payable.impl.transbo.SftQueryOrderStateRspBO;
import com.tydic.payment.pay.payable.impl.transbo.SftReFundReqBO;
import com.tydic.payment.pay.payable.impl.transbo.SftRefundRspBO;
import com.tydic.payment.pay.sft.MD5;
import com.tydic.payment.pay.sft.RSATool;
import com.tydic.payment.pay.util.SftHttpClient;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public abstract class AbstractSftPayAble
implements PayAble {
    private static final Logger log = LoggerFactory.getLogger(AbstractSftPayAble.class);
    private static final String UTF_8 = "UTF-8";
    private String formHead = "<form name=\"message_form\" method=\"post\" action=\"URL\">";
    private String inputItem = "<input type=\"hidden\" name=\"CODE\" value=\"VALUE\">";
    private String submit = "<input type=\"submit\" value=\"\u63d0\u4ea4\" style=\"display:none\">";
    private String script = "<script>document.forms[0].submit();</script>";
    private String requestUrl;
    private String thirdSysId;
    private String publicKey;
    private String md5Key;
    @Autowired
    private SftHttpClient sftHttpClient;
    @Autowired
    private PayProOrderQueryMapper payProOrderQueryMapper;
    @Autowired
    private PayPropertiesVo payPropertiesVo;

    public PayAbleRefundRspBo dealRefund(PayAbleRefundReqBo reqBo) {
        PayAbleRefundRspBo retBo = new PayAbleRefundRspBo();
        String validateArgStr = this.validateRefundArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        SftReFundReqBO sftReFundReqBO = new SftReFundReqBO();
        sftReFundReqBO.setTxcode("SFT10013");
        sftReFundReqBO.setTransId(String.valueOf(PayProSequence.nextId()));
        sftReFundReqBO.setPaybackNo(reqBo.getRefundOrderId());
        sftReFundReqBO.setOrderNo(reqBo.getPayOrderId());
        sftReFundReqBO.setAmount(String.valueOf(Double.valueOf(reqBo.getRefundFee().longValue()) / 100.0));
        sftReFundReqBO.setSellerUserIdThirdSys("123456789");
        String jsonString = JSONObject.toJSONString((Object)sftReFundReqBO);
        Map reqMap = (Map)JSONObject.parseObject((String)jsonString, Map.class);
        String body = this.sftHttpClient.doPost(reqMap);
        if (!this.isSuccess(body)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5931\u8d25");
            return retBo;
        }
        JSONObject refundBodyJsonObj = JSONObject.parseObject((String)body);
        String decode = this.sftHttpClient.decode(refundBodyJsonObj.getString("Data"));
        SftRefundRspBO sftRefundRspBO = (SftRefundRspBO)JSONObject.parseObject((String)decode, SftRefundRspBO.class);
        return retBo;
    }

    public PayAbleCallBackRspBo dealCallBack(PayAbleCallBackReqBo reqBo) {
        log.info("\u8fdb\u5165\u5efa\u884c-\u5584\u4ed8\u901a\u652f\u4ed8\u7ed3\u679c\u56de\u8c03\u5904\u7406\u65b9\u6cd5\uff1a{}" + JSONObject.toJSONString((Object)reqBo));
        PayAbleCallBackRspBo retBo = new PayAbleCallBackRspBo();
        if (StringUtils.isEmpty((Object)reqBo.getReqData())) {
            log.error("\u5efa\u884c-\u5584\u4ed8\u901a\u56de\u8c03\u5904\u7406\u65b9\u6cd5\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u53c2\u6570'reqData'\u4e0d\u80fd\u4e3a\u7a7a");
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5efa\u884c-\u5584\u4ed8\u901a\u56de\u8c03\u5904\u7406\u65b9\u6cd5\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u53c2\u6570'reqData'\u4e0d\u80fd\u4e3a\u7a7a");
            JSONObject reqDataJson = JSONObject.parseObject((String)reqBo.getReqData());
            return retBo;
        }
        String reqData = reqBo.getReqData();
        if (!this.isSuccess(reqData)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5931\u8d25");
            return retBo;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)reqData);
        String data = jsonObject.getString("Data");
        String decode = this.sftHttpClient.decode(data);
        SftCallBackRspBO sftCallBackRspBO = (SftCallBackRspBO)JSONObject.parseObject((String)decode, SftCallBackRspBO.class);
        if (sftCallBackRspBO == null) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5931\u8d25");
            return retBo;
        }
        String payTime = sftCallBackRspBO.getOrderInfos().get(0).getPayTime();
        String tradeTime = payTime.replaceAll("-", "").replaceAll(" ", "").replaceAll(":", "");
        retBo.setTradeTime(tradeTime);
        retBo.setPayOrderId(sftCallBackRspBO.getOrderInfos().get(0).getOrderNo());
        retBo.setPayOrderId(sftCallBackRspBO.getOrderInfos().get(0).getOrderNo());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    public PayAbleQryPayStatusRspBo qryPayStatus(PayAbleQryPayStatusReqBo reqBo) {
        PayAbleQryPayStatusRspBo retBo = new PayAbleQryPayStatusRspBo();
        String validateArgStr = this.validateQryArg(reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr);
            return retBo;
        }
        SftQueryOrderStateReqBO SftQueryOrderStateReqBO2 = new SftQueryOrderStateReqBO();
        SftQueryOrderStateReqBO2.setTxCode("SFT10003");
        SftQueryOrderStateReqBO2.setTransID(String.valueOf(PayProSequence.nextId()));
        SftQueryOrderStateReqBO.OrderInfos orderInfos = new SftQueryOrderStateReqBO.OrderInfos();
        orderInfos.setOrder_No(reqBo.getPayOrderId());
        ArrayList<SftQueryOrderStateReqBO.OrderInfos> orderInfosList = new ArrayList<SftQueryOrderStateReqBO.OrderInfos>();
        orderInfosList.add(orderInfos);
        SftQueryOrderStateReqBO2.setOrderInfos(orderInfosList);
        String jsonString = JSONObject.toJSONString((Object)SftQueryOrderStateReqBO2);
        Map reqMap = (Map)JSONObject.parseObject((String)jsonString, Map.class);
        String body = this.sftHttpClient.doPost(reqMap);
        if (!this.isSuccess(body)) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u5931\u8d25");
            return retBo;
        }
        JSONObject jsonBody = JSONObject.parseObject((String)body);
        String decodeBodyStr = this.sftHttpClient.decode(jsonBody.getString("Data"));
        SftQueryOrderStateRspBO SftQueryOrderStateRspBO2 = (SftQueryOrderStateRspBO)JSONObject.parseObject((String)decodeBodyStr, SftQueryOrderStateRspBO.class);
        if (SftQueryOrderStateRspBO2 == null) {
            retBo.setRespCode("8888");
            retBo.setRespDesc("\u67e5\u8be2\u5931\u8d25");
            return retBo;
        }
        this.sortQryStatusRetBo(reqBo, SftQueryOrderStateRspBO2, retBo);
        return retBo;
    }

    public String validateQryArg(PayAbleQryPayStatusReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private void sortQryStatusRetBo(PayAbleQryPayStatusReqBo reqBo, SftQueryOrderStateRspBO SftQueryOrderStateRspBO2, PayAbleQryPayStatusRspBo retBo) {
        retBo.setOrderId(reqBo.getOrderId());
        retBo.setPayOrderId(reqBo.getPayOrderId());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u67e5\u8be2\u6210\u529f");
        switch (SftQueryOrderStateRspBO2.getStatus()) {
            case "1": {
                retBo.setTradeTime(SftQueryOrderStateRspBO2.getOrderInfos().get(0).getPayTime());
                retBo.setRealFee(Long.valueOf((long)(Double.parseDouble(SftQueryOrderStateRspBO2.getOrderInfos().get(0).getOrderMoney()) * 100.0)));
                retBo.setPayNotifyTransId(SftQueryOrderStateRspBO2.getOrderInfos().get(0).getOrderNo());
                retBo.setPayStatus("SUCCESS");
                retBo.setPayStatusMsg("\u652f\u4ed8\u6210\u529f(\u5efa\u884c-\u5584\u4ed8\u901a)");
                break;
            }
            case "0": {
                retBo.setPayStatus("FAIL");
                retBo.setPayStatusMsg("\u652f\u4ed8\u5931\u8d25");
                break;
            }
            default: {
                retBo.setRespCode("8888");
                retBo.setRespDesc("\u5931\u8d25");
            }
        }
    }

    public String validateRefundArg(PayAbleRefundReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027payOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getParaMap()) || reqBo.getParaMap().isEmpty()) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027paraMap\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundFee())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundFee\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getRefundOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027refundOrderId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    public <T> String buildHtml(String txCode, T sftReqBO) {
        Map<String, String> dataMap = this.encryptionData(txCode, sftReqBO);
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append(this.formHead.replace("URL", this.requestUrl));
        for (String key : dataMap.keySet()) {
            String input = this.inputItem.replace("CODE", key).replace("VALUE", dataMap.get(key));
            htmlBuilder.append(input);
        }
        htmlBuilder.append(this.submit);
        htmlBuilder.append("</form>");
        htmlBuilder.append(this.script);
        if (log.isDebugEnabled()) {
            log.debug("\u7ec4\u88c5\u597d\u7684HTML\u4e3a\uff1a{}", (Object)htmlBuilder);
        }
        return htmlBuilder.toString();
    }

    private <T> Map<String, String> encryptionData(String txCode, T sftReqBO) {
        String initResult = this.init();
        if (!StringUtils.isEmpty((Object)initResult)) {
            log.error("\u5584\u4ed8\u901a\u7f3a\u5c11\u914d\u7f6e\u4fe1\u606f:{}", (Object)initResult);
            throw new BusinessException("219001", initResult);
        }
        String reqJsonStr = JSONObject.toJSONString(sftReqBO);
        String enCodeStr = "";
        try {
            enCodeStr = RSATool.clientEncrypt((String)reqJsonStr, (String)this.publicKey);
        }
        catch (Exception e) {
            log.error("\u5584\u4ed8\u901a\u8bf7\u6c42\u62a5\u6587RSA\u52a0\u5bc6\u5931\u8d25");
            throw new BusinessException("219001", "\u5584\u4ed8\u901a\u8bf7\u6c42\u62a5\u6587RSA\u52a0\u5bc6\u5931\u8d25");
        }
        String data = "";
        try {
            data = URLEncoder.encode(enCodeStr, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String auth = MD5.getMD5((String)(this.thirdSysId + txCode + data + this.md5Key), (String)"utf-8");
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("ThirdSysID", this.thirdSysId);
        dataMap.put("Data", data);
        dataMap.put("TxCode", txCode);
        dataMap.put("Auth", auth);
        return dataMap;
    }

    private String init() {
        this.thirdSysId = this.payPropertiesVo.getSFTThirdSysId();
        if (StringUtils.isEmpty((Object)this.thirdSysId)) {
            return "\u914d\u7f6e\u6587\u4ef6\u5584\u4ed8\u901a\u4e09\u65b9Id\u4fe1\u606f\u672a\u914d\u7f6e";
        }
        this.requestUrl = this.payPropertiesVo.getSFTRequestUrl();
        if (StringUtils.isEmpty((Object)this.requestUrl)) {
            return "\u914d\u7f6e\u6587\u4ef6\u5584\u4ed8\u901a\u8bf7\u6c42\u5730\u5740\u4fe1\u606f\u672a\u914d\u7f6e";
        }
        this.md5Key = this.payPropertiesVo.getSFTMD5Key();
        if (StringUtils.isEmpty((Object)this.md5Key)) {
            return "\u914d\u7f6e\u6587\u4ef6\u5584\u4ed8\u901amd5Key\u4fe1\u606f\u672a\u914d\u7f6e";
        }
        this.publicKey = this.payPropertiesVo.getSFTPublicKey();
        if (StringUtils.isEmpty((Object)this.publicKey)) {
            return "\u914d\u7f6e\u6587\u4ef6\u5584\u4ed8\u901apublicKey\u4fe1\u606f\u672a\u914d\u7f6e";
        }
        return null;
    }

    private boolean isSuccess(String body) {
        if (body == null) {
            return false;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        return StringUtils.isEmpty((Object)jsonObject.get((Object)"errorCode")) && StringUtils.isEmpty((Object)jsonObject.get((Object)"errorMsg"));
    }
}

