/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import com.tydic.payment.pay.atom.BusiSystemInfoAtomService;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.busi.QueryPCodeInfoService;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoReqBO;
import com.tydic.payment.pay.busi.bo.QueryPCodeInfoRspBO;
import com.tydic.payment.pay.dao.BillCompareResultMapper;
import com.tydic.payment.pay.dao.po.BillCompareResultPO;
import com.tydic.payment.pay.dao.po.BillCompareResultPageReqPO;
import com.tydic.payment.pay.dao.po.BusiSystemInfoPO;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.req.BillCmpRsListQryWebReqBO;
import com.tydic.payment.pay.web.bo.rsp.BillCmpRsListQryWebRspBO;
import com.tydic.payment.pay.web.service.BillCmpRsListQryWebService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.web.service.BillCmpRsListQryWebService"})
public class BillCmpRsListQryWebServiceImpl
implements BillCmpRsListQryWebService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BillCmpRsListQryWebServiceImpl.class);
    @Autowired
    private BillCompareResultMapper billCompareResultMapper;
    @Autowired
    private QueryPCodeInfoService queryPCodeInfoService;
    @Autowired
    private PaymentInsAtomService paymentInsAtomService;
    @Autowired
    private BusiSystemInfoAtomService busiSystemInfoAtomService;

    @PostMapping(value={"qryBillCmpRsList"})
    public RspPage<BillCmpRsListQryWebRspBO> qryBillCmpRsList(@RequestBody BillCmpRsListQryWebReqBO req) {
        LOGGER.info("\u5bf9\u8d26\u7ed3\u679c\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + req);
        RspPage retBo = new RspPage();
        ArrayList<BillCmpRsListQryWebRspBO> rspList = new ArrayList<BillCmpRsListQryWebRspBO>();
        retBo.setRows(rspList);
        if (StringUtils.isEmpty((Object)req.getBusiId())) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5165\u53c2\u3010busiId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            BillCompareResultPageReqPO po = new BillCompareResultPageReqPO();
            LOGGER.info("\u5bf9\u4e0e\u5426" + !StringUtils.isEmpty((Object)req.getBillDateEnd()));
            if (!StringUtils.isEmpty((Object)req.getBillDateBegin())) {
                po.setBillDateBegin(Long.valueOf(req.getBillDateBegin().replace("-", "")));
            }
            if (!StringUtils.isEmpty((Object)req.getBillDateEnd())) {
                po.setBillDateEnd(Long.valueOf(req.getBillDateEnd().replace("-", "")));
            }
            if (!StringUtils.isEmpty((Object)req.getBillDateBegin()) || StringUtils.isEmpty((Object)req.getBillDateEnd())) {
                // empty if block
            }
            po.setBusiId(Long.valueOf(req.getBusiId()));
            if (!StringUtils.isEmpty((Object)req.getPaymentInsId())) {
                po.setPaymentInsId(Long.valueOf(req.getPaymentInsId()));
            }
            Page page = null;
            if (req.getPageNo() > 1) {
                page = new Page(req.getPageNo(), req.getPageSize());
            } else {
                page = new Page();
                BeanUtils.copyProperties((Object)req, (Object)page);
                if (page.getPageNo() < 1) {
                    page.setPageNo(1);
                }
                if (page.getPageSize() < 1) {
                    page.setPageSize(10);
                }
            }
            List<Object> list = new ArrayList();
            try {
                list = this.billCompareResultMapper.queryBillCompareResultByPage((Page<BillCompareResultPageReqPO>)page, po);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            if (!CollectionUtils.isEmpty(list)) {
                PaymentInsPo paymentInsPo = new PaymentInsPo();
                QueryPCodeInfoReqBO queryPCodeInfoReq = new QueryPCodeInfoReqBO();
                BusiSystemInfoPO busiSystemInfoPO = new BusiSystemInfoPO();
                for (BillCompareResultPO billCompareResultPO : list) {
                    BillCmpRsListQryWebRspBO bo = new BillCmpRsListQryWebRspBO();
                    if (!StringUtils.isEmpty((Object)billCompareResultPO.getBillDate()) && billCompareResultPO.getBillDate() > 0L) {
                        bo.setBillDate(String.valueOf(billCompareResultPO.getBillDate()));
                    }
                    if (!StringUtils.isEmpty((Object)billCompareResultPO.getBusiId()) && billCompareResultPO.getBusiId() > 0L) {
                        bo.setBusiId(String.valueOf(billCompareResultPO.getBusiId()));
                        busiSystemInfoPO.setBusiId(billCompareResultPO.getBusiId());
                        List<BusiSystemInfoPO> busiSystemInfoList = this.busiSystemInfoAtomService.queryBusiSystemInfoByCondition(busiSystemInfoPO);
                        if (!busiSystemInfoList.isEmpty()) {
                            String busiName = busiSystemInfoList.get(0).getBusiName();
                            bo.setBusiName(busiName == null ? "" : busiName);
                        }
                    }
                    if (!StringUtils.isEmpty((Object)billCompareResultPO.getPaymentInsId()) && billCompareResultPO.getPaymentInsId() != 0L) {
                        bo.setPaymentInsId(String.valueOf(billCompareResultPO.getPaymentInsId()));
                        paymentInsPo.setPaymentInsId(billCompareResultPO.getPaymentInsId());
                        List<PaymentInsPo> queryPayemntInfResult = this.paymentInsAtomService.queryPaymentInf(paymentInsPo);
                        if (!queryPayemntInfResult.isEmpty()) {
                            String paymentInsName = queryPayemntInfResult.get(0).getPaymentInsName();
                            bo.setPaymentInsName(paymentInsName == null ? "" : paymentInsName);
                        }
                    }
                    if (!StringUtils.isEmpty((Object)billCompareResultPO.getResultFlag()) && billCompareResultPO.getResultFlag() != 0L) {
                        queryPCodeInfoReq.setTypeCode("COMPARE_RESULT_RESULT_FLAG");
                        queryPCodeInfoReq.setCodeValue(String.valueOf(billCompareResultPO.getResultFlag()));
                        QueryPCodeInfoRspBO queryPCodeInfoRsp = this.queryPCodeInfoService.queryPCodeInfo(queryPCodeInfoReq);
                        bo.setResultFlag(queryPCodeInfoRsp.getCodeInfo() == null ? "" : queryPCodeInfoRsp.getCodeInfo());
                    }
                    if (billCompareResultPO.getBeginDate() != null) {
                        bo.setBeginDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(billCompareResultPO.getBeginDate()));
                    }
                    if (billCompareResultPO.getEndDate() != null) {
                        bo.setEndDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(billCompareResultPO.getEndDate()));
                    }
                    rspList.add(bo);
                }
            }
            retBo.setRecordsTotal(page.getTotalCount());
            retBo.setTotal(page.getTotalPages());
            retBo.setPageNo(page.getPageNo());
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "BillCmpRsListQryWebService\u670d\u52a1\u5f02\u5e38");
        }
        return retBo;
    }
}

