/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.service.impl;

import com.tydic.payment.pay.atom.MerchantInfoAtomService;
import com.tydic.payment.pay.bo.BaseRspInfoBO;
import com.tydic.payment.pay.busi.QueryDBDateBusiService;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.MerchantInfoBoStr;
import com.tydic.payment.pay.web.bo.req.UpdateMechartBaseInfoWebReqBo;
import com.tydic.payment.pay.web.service.UpdateInfoMechartWebService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"PAYMENT_GROUP_DEV/2.0.0/com.tydic.payment.pay.web.service.UpdateInfoMechartWebService"})
public class UpdateInfoMechartWebServiceImpl
implements UpdateInfoMechartWebService {
    private static final Logger log = LoggerFactory.getLogger(UpdateInfoMechartWebServiceImpl.class);
    @Autowired
    private MerchantInfoAtomService merchantInfoAtomService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;

    @PostMapping(value={"enableMerchant"})
    public BaseRspInfoBO enableMerchant(@RequestBody UpdateMechartBaseInfoWebReqBo reqBo) {
        log.info("UpdateInfoMechartWebService-\u542f\u7528\u5546\u6237\u5165\u53c2\uff1a" + reqBo);
        BaseRspInfoBO rsp = new BaseRspInfoBO();
        try {
            int updFlag;
            if (reqBo == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u3010merchantId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            MerChantInfoPo qryMerRPo = this.merchantInfoAtomService.queryMerchantInfoById(Long.valueOf(reqBo.getMerchantId()));
            if (!qryMerRPo.getFlag().equals("0")) {
                rsp.setRspName("\u53ea\u6709\u5904\u4e8e\u672a\u751f\u6548\u72b6\u6001\u7684\u5546\u6237\u624d\u80fd\u542f\u7528");
                rsp.setRspCode("8888");
                return rsp;
            }
            MerChantInfoPo upMerPo = new MerChantInfoPo();
            upMerPo.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
            upMerPo.setFlag("1");
            upMerPo.setUpdateTime(this.queryDBDateBusiService.getDBDate());
            if (!StringUtils.isEmpty((Object)reqBo.getOperId())) {
                upMerPo.setUpdateOperId(reqBo.getOperId());
            }
            if ((updFlag = this.merchantInfoAtomService.updateMerChantInfo(upMerPo)) < 1) {
                rsp.setRspCode("0000");
                rsp.setRspName("\u542f\u7528\u5931\u8d25\uff0c\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef");
            } else {
                rsp.setRspCode("0000");
                rsp.setRspName("\u542f\u7528\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.info("UpdateInfoMechartWebService-\u542f\u7528\u5546\u6237\u5f02\u5e38" + e);
            rsp.setRspCode("8888");
            rsp.setRspCode("\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return rsp;
    }

    @PostMapping(value={"disableMerchant"})
    public BaseRspInfoBO disableMerchant(@RequestBody UpdateMechartBaseInfoWebReqBo reqBo) {
        log.info("UpdateInfoMechartWebService-\u505c\u7528\u5546\u6237\u5165\u53c2\uff1a" + reqBo);
        BaseRspInfoBO rsp = new BaseRspInfoBO();
        try {
            int updFlag;
            if (reqBo == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u3010merchantId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            MerChantInfoPo qryMerRPo = this.merchantInfoAtomService.queryMerchantInfoById(Long.valueOf(reqBo.getMerchantId()));
            if (!qryMerRPo.getFlag().equals("1")) {
                rsp.setRspName("\u53ea\u6709\u5904\u4e8e\u5df2\u751f\u6548\u72b6\u6001\u7684\u5546\u6237\u624d\u80fd\u505c\u7528");
                rsp.setRspCode("8888");
                return rsp;
            }
            MerChantInfoPo upMerPo = new MerChantInfoPo();
            upMerPo.setMerchantId(Long.valueOf(reqBo.getMerchantId()));
            upMerPo.setFlag("0");
            upMerPo.setUpdateTime(this.queryDBDateBusiService.getDBDate());
            if (!StringUtils.isEmpty((Object)reqBo.getOperId())) {
                upMerPo.setUpdateOperId(reqBo.getOperId());
            }
            if ((updFlag = this.merchantInfoAtomService.updateMerChantInfo(upMerPo)) < 1) {
                rsp.setRspCode("0000");
                rsp.setRspName("\u505c\u7528\u5931\u8d25\uff0c\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef");
            } else {
                rsp.setRspCode("0000");
                rsp.setRspName("\u505c\u7528\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.info("UpdateInfoMechartWebService-\u505c\u7528\u5546\u6237\u5f02\u5e38" + e);
            rsp.setRspCode("8888");
            rsp.setRspCode("\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return rsp;
    }

    @PostMapping(value={"updateMainMerchant"})
    public MerchantInfoBoStr updateMainMerchant(@RequestBody UpdateMechartBaseInfoWebReqBo reqBo) {
        MerchantInfoBoStr rspBo = new MerchantInfoBoStr();
        try {
            if (reqBo == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u3010merchantId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            MerChantInfoPo qryMerRPo = this.merchantInfoAtomService.queryMerchantInfoById(Long.valueOf(reqBo.getMerchantId()));
            Integer mainType = Integer.valueOf("1");
            if (!qryMerRPo.getMerchantType().equals(mainType)) {
                rspBo.setRspName("\u4fee\u6539\u4e3b\u5546\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8be5\u5546\u6237\u4e0d\u662f\u4e3b\u5546\u6237");
                rspBo.setRspCode("8888");
                return rspBo;
            }
            if (!StringUtils.isEmpty((Object)reqBo.getMainMerchantId())) {
                rspBo.setRspName("\u4fee\u6539\u4e3b\u5546\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u65e0\u6cd5\u4e3a\u4e3b\u5546\u6237\u6dfb\u52a0\u4e00\u4e2a\u4e3b\u5546\u6237ID\uff0c\u8bf7\u5c06mainMerchantId\u7f6e\u4e3a\u7a7a");
                rspBo.setRspCode("8888");
                return rspBo;
            }
            MerChantInfoPo updMainMerPo = new MerChantInfoPo();
            BeanUtils.copyProperties((Object)reqBo, (Object)updMainMerPo);
            updMainMerPo.setMerchantId(Long.parseLong(reqBo.getMerchantId()));
            if (!StringUtils.isEmpty((Object)reqBo.getOperId())) {
                updMainMerPo.setUpdateOperId(reqBo.getOperId());
            }
            updMainMerPo.setUpdateTime(this.queryDBDateBusiService.getDBDate());
            this.merchantInfoAtomService.updateMerChantInfo(updMainMerPo);
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u6210\u529f");
            MerChantInfoPo resultPo = this.merchantInfoAtomService.queryMerchantInfoById(Long.valueOf(reqBo.getMerchantId()));
            BeanUtils.copyProperties((Object)resultPo, (Object)rspBo);
            rspBo.setMerchantId(String.valueOf(resultPo.getMerchantId()));
            rspBo.setMerchantId(String.valueOf(updMainMerPo.getMerchantId()));
        }
        catch (Exception e) {
            log.info("UpdateInfoMechartWebService-\u4fee\u6539\u4e3b\u5546\u6237\u5f02\u5e38" + e);
            rspBo.setRspCode("8888");
            rspBo.setRspCode("\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return rspBo;
    }

    @PostMapping(value={"updateSubMerchant"})
    public MerchantInfoBoStr updateSubMerchant(@RequestBody UpdateMechartBaseInfoWebReqBo reqBo) {
        MerchantInfoBoStr rspBo = new MerchantInfoBoStr();
        try {
            if (reqBo == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u3010merchantId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            MerChantInfoPo qryMerRPo = this.merchantInfoAtomService.queryMerchantInfoById(Long.valueOf(reqBo.getMerchantId()));
            Integer subType = Integer.valueOf("2");
            if (!qryMerRPo.getMerchantType().equals(subType)) {
                rspBo.setRspName("\u4fee\u6539\u5b50\u5546\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u8be5\u5546\u6237\u4e0d\u662f\u5b50\u5546\u6237");
                rspBo.setRspCode("8888");
                return rspBo;
            }
            MerChantInfoPo updSubMerPo = new MerChantInfoPo();
            BeanUtils.copyProperties((Object)reqBo, (Object)updSubMerPo);
            updSubMerPo.setMerchantId(Long.parseLong(reqBo.getMerchantId()));
            if (!StringUtils.isEmpty((Object)reqBo.getMainMerchantId())) {
                updSubMerPo.setMainMerchantId(Long.valueOf(reqBo.getMainMerchantId()));
            }
            if (!StringUtils.isEmpty((Object)reqBo.getOperId())) {
                updSubMerPo.setUpdateOperId(reqBo.getOperId());
            }
            updSubMerPo.setUpdateTime(this.queryDBDateBusiService.getDBDate());
            this.merchantInfoAtomService.updateMerChantInfo(updSubMerPo);
            rspBo.setRspCode("0000");
            rspBo.setRspName("\u6210\u529f");
            MerChantInfoPo resultPo = this.merchantInfoAtomService.queryMerchantInfoById(Long.valueOf(reqBo.getMerchantId()));
            BeanUtils.copyProperties((Object)resultPo, (Object)rspBo);
            rspBo.setMerchantId(String.valueOf(updSubMerPo.getMerchantId()));
        }
        catch (Exception e) {
            log.info("UpdateInfoMechartWebService-\u4fee\u6539\u5b50\u5546\u6237\u5f02\u5e38" + e);
            rspBo.setRspCode("8888");
            rspBo.setRspCode("\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return rspBo;
    }
}

