/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.base.utils;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DelFormatHelper;
import com.tydic.dyc.atom.base.bo.DycEsbCommParamBO;
import com.tydic.dyc.atom.base.utils.DycEsbSignUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import java.text.ParseException;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DycHttpUtil {
    private static final Logger log = LoggerFactory.getLogger(DycHttpUtil.class);
    private static String appkey = DycPropertiesUtil.getProperty("ESB_CGD_APPKEY");
    private static String key = DycPropertiesUtil.getProperty("ESB_CGD_KEY");
    private static final String ENCODING = "UTF-8";

    public static String doGetReuest(String urlString) {
        return DycHttpUtil.doEexcute(urlString, null, Method.POST);
    }

    public static String doPostReuest(String urlString, String body) {
        return DycHttpUtil.doEexcute(urlString, body, Method.POST);
    }

    public static String doPostReuest(String urlString, String body, String hsn) {
        return DycHttpUtil.doEexcute(urlString, DycHttpUtil.initPostStr(body, hsn, "BUSINESS_ORDER"), Method.POST);
    }

    private static String doEexcute(String urlString, String body, Method method) {
        HttpResponse httpResponse;
        block4: {
            httpResponse = null;
            try {
                httpResponse = new HttpRequest(urlString).method(method).body(body).execute();
            }
            catch (Exception e1) {
                if (e1 instanceof IORuntimeException) {
                    throw new ZTBusinessException("ESB\u8fde\u63a5\u5f02\u5e38\uff1a" + e1.getMessage());
                }
                if (e1 instanceof IllegalArgumentException) {
                    throw new ZTBusinessException("ESB\u8c03\u7528\u53c2\u6570\u5f02\u5e38\uff1a" + e1.getMessage());
                }
                if (!(e1 instanceof RuntimeException)) break block4;
                throw new ZTBusinessException("ESB\u8c03\u7528\u7cfb\u7edf\u5f02\u5e38\uff1a" + e1.getMessage());
            }
        }
        return httpResponse.body();
    }

    private static String initPostStr(String reqJsonStr, String hsn, String center) {
        try {
            JSONObject resultJson = new JSONObject();
            JSONObject reqJsonObject = JSONObject.parseObject((String)reqJsonStr);
            JSONObject esbCommParamJson = DycHttpUtil.getEsbCommParam(hsn, center);
            resultJson.putAll((Map)esbCommParamJson);
            resultJson.putAll((Map)reqJsonObject);
            return JSONObject.toJSONString((Object)resultJson);
        }
        catch (Exception e) {
            log.error("ESB\u80fd\u529b\u5e73\u53f0\u62a5\u6587\u5c01\u88c5\u5de5\u5177\u83b7\u53d6ESB\u8bf7\u6c42\u62a5\u6587\u5931" + e);
            throw new RuntimeException("\u83b7\u53d6ESB\u8bf7\u6c42\u62a5\u6587\u5931\u8d25");
        }
    }

    private static JSONObject getEsbCommParam(String hsn, String center) {
        try {
            DycEsbCommParamBO eSBCommParam = new DycEsbCommParamBO();
            eSBCommParam.setAppkey(appkey);
            eSBCommParam.setHsn(hsn);
            String timeStamp = DycHttpUtil.getTimeStamp();
            eSBCommParam.setTimeStamp(timeStamp);
            String serialnumber = DycHttpUtil.getSerialNumber(timeStamp, center);
            eSBCommParam.setSerialNumber(serialnumber);
            String token = DycEsbSignUtil.getESBToken(ENCODING, key, appkey, serialnumber, timeStamp);
            eSBCommParam.setToken(token);
            return (JSONObject)JSONObject.toJSON((Object)eSBCommParam);
        }
        catch (Exception e) {
            log.error("ESB\u80fd\u529b\u5e73\u53f0\u62a5\u6587\u5c01\u88c5\u5de5\u5177\u83b7\u53d6ESB\u516c\u5171\u53c2\u6570\u5931\u8d25" + e);
            throw new RuntimeException("\u83b7\u53d6ESB\u516c\u5171\u53c2\u6570\u5931\u8d25" + e);
        }
    }

    private static String getTimeStamp() {
        return DelFormatHelper.getNowTimeForString();
    }

    private static String getSerialNumber(String timeStamp, String center) throws ParseException {
        return DycPropertiesUtil.getProperty(center) + DelFormatHelper.getNowTimeForString((String)timeStamp) + DycHttpUtil.get4Random();
    }

    private static String get4Random() {
        int min = 1000;
        int max = 9999;
        Random random = new Random();
        int resultInt = random.nextInt(max) % (max - min + 1) + min;
        return String.valueOf(resultInt);
    }
}

