/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.busicommon.api.DycUocOrderTrackQueryFunction;
import com.tydic.dyc.atom.busicommon.bo.DycOrderTraceInfoDataFuncBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocOrderTrackQueryFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocOrderTrackQueryFuncRspBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DycUocOrderTrackQueryFunctionImpl
implements DycUocOrderTrackQueryFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocOrderTrackQueryFunctionImpl.class);

    @Override
    public DycUocOrderTrackQueryFuncRspBO qryOrderTrack(DycUocOrderTrackQueryFuncReqBO reqBo) {
        this.validateArg(reqBo);
        DycUocOrderTrackQueryFuncRspBO rspBO = new DycUocOrderTrackQueryFuncRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setTraceList(new ArrayList<DycOrderTraceInfoDataFuncBO>());
        JSONObject json = new JSONObject();
        this.initParams(reqBo, json);
        try {
            String httpRspStr = DycEsbUtil.doPostReuest((String)DycPropertiesUtil.getProperty((String)"ESB_QRY_LOGISTICS_TRACK_URL"), (String)json.toJSONString());
            log.info("\u8c03\u7528\u5feb\u9012100\u5b9e\u65f6\u7269\u6d41\u6570\u636e\u67e5\u8be2\u63a5\u53e3,\u8fd4\u56de\u51fa\u53c2: {}", (Object)httpRspStr);
            JSONObject jsonObject = JSONObject.parseObject((String)httpRspStr);
            if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("result")) && !"true".equalsIgnoreCase(jsonObject.getString("result"))) {
                rspBO.setRespCode(jsonObject.getString("returnCode"));
                rspBO.setRespDesc(jsonObject.getString("message"));
            }
            rspBO.setComCode(jsonObject.getString("com"));
            rspBO.setNumber(jsonObject.getString("nu"));
            rspBO.setIsCheck(jsonObject.getString("ischeck"));
            rspBO.setState(jsonObject.getString("state"));
            Optional.ofNullable(jsonObject.getJSONArray("data")).ifPresent(o -> {
                List traceInfoDataFuncBOS = o.toJavaList(DycOrderTraceInfoDataFuncBO.class);
                rspBO.setTraceList(traceInfoDataFuncBOS);
            });
        }
        catch (ZTBusinessException e) {
            log.error("\u8c03\u7528\u5feb\u9012100\u5b9e\u65f6\u7269\u6d41\u6570\u636e\u67e5\u8be2\u5f02\u5e38: {}", (Object)e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        return rspBO;
    }

    private void initParams(DycUocOrderTrackQueryFuncReqBO reqBo, JSONObject json) {
        json.put("com", (Object)reqBo.getComCode());
        json.put("num", (Object)reqBo.getTrackNo());
        if (StringUtils.isNotBlank((CharSequence)reqBo.getPhone())) {
            json.put("phone", (Object)reqBo.getPhone());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getFrom())) {
            json.put("from", (Object)reqBo.getFrom());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getTo())) {
            json.put("to", (Object)reqBo.getTo());
        }
        if (reqBo.getResultV2() != null) {
            json.put("resultv2", (Object)reqBo.getResultV2());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getShow())) {
            json.put("show", (Object)reqBo.getShow());
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getOrder())) {
            json.put("order", (Object)reqBo.getOrder());
        }
    }

    public void validateArg(DycUocOrderTrackQueryFuncReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getComCode())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u5feb\u9012\u516c\u53f8\u7f16\u7801[comCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getTrackNo())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u5feb\u9012\u5355\u53f7[trackNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

