/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.order.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.order.api.DycUocRefundPayFunction;
import com.tydic.dyc.atom.busicommon.order.bo.DycUocRefundPayFunctionReqBO;
import com.tydic.dyc.atom.busicommon.order.bo.DycUocRefundPayFunctionRspBO;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.domainservice.UocQryShouldPayOrderListService;
import com.tydic.dyc.oc.service.domainservice.UocSaleOrderStakeholderQryService;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShouldPayOrderListServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShouldPayOrderListServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderStakeholderQryServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderStakeholderQryServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayOrderBo;
import com.tydic.fsc.common.ability.api.FscCreditDeductAbilityService;
import com.tydic.fsc.common.ability.bo.FscCreditDeductAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscCreditDeductAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscCreditDeductOrderInfo;
import com.tydic.fsc.pay.ability.api.FscShouldPayTerminationAbilityService;
import com.tydic.fsc.pay.ability.bo.FscShouldPayTerminationAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscShouldPayTerminationAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycUocRefundPayFunctionImpl
implements DycUocRefundPayFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocRefundPayFunctionImpl.class);
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV")
    private FscCreditDeductAbilityService fscCreditDeductAbilityService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV")
    private FscShouldPayTerminationAbilityService fscShouldPayTerminationAbilityService;
    @HSFConsumer(serviceVersion="3.0.0", serviceGroup="OC_GROUP_DEV")
    private UocSaleOrderStakeholderQryService uocSaleOrderStakeholderQryService;
    @HSFConsumer(serviceVersion="3.0.0", serviceGroup="OC_GROUP_DEV")
    private UocQryShouldPayOrderListService uocQryShouldPayOrderListService;

    @Override
    public DycUocRefundPayFunctionRspBO refundPay(DycUocRefundPayFunctionReqBO reqBO) {
        DycUocRefundPayFunctionRspBO rspBO = new DycUocRefundPayFunctionRspBO();
        this.verifyParam(reqBO);
        if (UocDicConstant.PAY_STATE.PAYED.equals(reqBO.getPayState())) {
            if (UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(reqBO.getPayType())) {
                this.refundCredit(reqBO);
            } else if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(reqBO.getPayType()) || UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(reqBO.getPayType())) {
                this.cancelFscShouldPayOrder(reqBO);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void cancelFscShouldPayOrder(DycUocRefundPayFunctionReqBO reqBO) {
        UocQryShouldPayOrderListServiceReqBo uocQryShouldPayOrderListServiceReqBo = new UocQryShouldPayOrderListServiceReqBo();
        uocQryShouldPayOrderListServiceReqBo.setIsPayCompleted(UocDicConstant.SHOULD_PAY_ORDER_PAY_STATE.NOT_PAY_COMPLETED);
        uocQryShouldPayOrderListServiceReqBo.setObjectId(reqBO.getSaleOrderId());
        uocQryShouldPayOrderListServiceReqBo.setOrderId(reqBO.getOrderId());
        uocQryShouldPayOrderListServiceReqBo.setObjectType(UocDicConstant.OBJ_TYPE.SALE);
        UocQryShouldPayOrderListServiceRspBo uocQryShouldPayOrderListServiceRspBo = this.uocQryShouldPayOrderListService.qryShouldPayOrderList(uocQryShouldPayOrderListServiceReqBo);
        if ("0000".equals(uocQryShouldPayOrderListServiceRspBo.getRespCode()) && !CollectionUtils.isEmpty((Collection)uocQryShouldPayOrderListServiceRspBo.getShouldPayOrderList())) {
            ArrayList<Long> shouldPayIds = new ArrayList<Long>();
            for (UocShouldPayOrderBo uocShouldPayOrderBo : uocQryShouldPayOrderListServiceRspBo.getShouldPayOrderList()) {
                shouldPayIds.add(uocShouldPayOrderBo.getShouldPayId());
            }
            FscShouldPayTerminationAbilityReqBO fscShouldPayTerminationAbilityReqBO = new FscShouldPayTerminationAbilityReqBO();
            fscShouldPayTerminationAbilityReqBO.setShouldPayIds(shouldPayIds);
            FscShouldPayTerminationAbilityRspBO fscShouldPayTerminationAbilityRspBO = this.fscShouldPayTerminationAbilityService.dealShouldPayTermination(fscShouldPayTerminationAbilityReqBO);
            if (!"0000".equals(fscShouldPayTerminationAbilityRspBO.getRespCode())) {
                throw new ZTBusinessException(fscShouldPayTerminationAbilityRspBO.getRespDesc());
            }
        }
    }

    private void refundCredit(DycUocRefundPayFunctionReqBO reqBO) {
        UocSaleOrderStakeholderQryServiceReqBo uocSaleOrderStakeholderQryServiceReqBo = new UocSaleOrderStakeholderQryServiceReqBo();
        uocSaleOrderStakeholderQryServiceReqBo.setStakeholderId(reqBO.getStakeholderId());
        UocSaleOrderStakeholderQryServiceRspBo uocSaleOrderStakeholderQryServiceRspBo = this.uocSaleOrderStakeholderQryService.qrySaleOrderStakeholder(uocSaleOrderStakeholderQryServiceReqBo);
        if ("0000".equals(uocSaleOrderStakeholderQryServiceRspBo.getRespCode())) {
            FscCreditDeductAbilityReqBO fscCreditDeductAbilityReqBO = new FscCreditDeductAbilityReqBO();
            fscCreditDeductAbilityReqBO.setSupId(Long.valueOf(uocSaleOrderStakeholderQryServiceRspBo.getSupId()));
            fscCreditDeductAbilityReqBO.setCreditOrgId(Long.valueOf(uocSaleOrderStakeholderQryServiceRspBo.getPurOrgId()));
            fscCreditDeductAbilityReqBO.setAmount(reqBO.getTotalSaleFee());
            ArrayList<FscCreditDeductOrderInfo> orderInfoList = new ArrayList<FscCreditDeductOrderInfo>();
            FscCreditDeductOrderInfo fscCreditDeductOrderInfo = new FscCreditDeductOrderInfo();
            fscCreditDeductOrderInfo.setOrderId(reqBO.getSaleOrderId().longValue());
            fscCreditDeductOrderInfo.setOrderNo(reqBO.getSaleOrderNo());
            orderInfoList.add(fscCreditDeductOrderInfo);
            fscCreditDeductAbilityReqBO.setOrderInfoList(orderInfoList);
            FscCreditDeductAbilityRspBO fscCreditDeductAbilityRspBO = this.fscCreditDeductAbilityService.dealAccountDeduct(fscCreditDeductAbilityReqBO);
            if (!"0000".equals(fscCreditDeductAbilityRspBO.getRespCode())) {
                throw new ZTBusinessException(fscCreditDeductAbilityRspBO.getRespDesc());
            }
        } else {
            throw new ZTBusinessException(uocSaleOrderStakeholderQryServiceRspBo.getRespDesc());
        }
    }

    private void verifyParam(DycUocRefundPayFunctionReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u652f\u4ed8\u9000\u6b3e\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayState()) {
            throw new ZTBusinessException("\u652f\u4ed8\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

